/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.join;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.stream.sql.join.TestTemporalTable$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001U\u0011a\u0002T8pWV\u0004(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000b\t\fGo\u00195\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tI\"\"A\u0003vi&d7/\u0003\u0002\u001c1\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dJ\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"B\u000f%\u0001\u0004q\u0002bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\ti\u0016\u001cH/\u0016;jYV\tQ\u0006\u0005\u0002\u0018]%\u0011q\u0006\u0007\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u00042\u0001\u0001\u0006I!L\u0001\ni\u0016\u001cH/\u0016;jY\u0002BQa\r\u0001\u0005\u0002Q\naAY3g_J,G#A\u001b\u0011\u0005}1\u0014BA\u001c!\u0005\u0011)f.\u001b;)\u0005IJ\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0013\u0003\u0015QWO\\5u\u0013\tq4H\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u0001\u0002!\t\u0001N\u0001!i\u0016\u001cHOS8j]&sg/\u00197jI*{\u0017N\u001c+f[B|'/\u00197UC\ndW\r\u000b\u0002@\u0005B\u0011!hQ\u0005\u0003\tn\u0012A\u0001V3ti\")a\t\u0001C\u0001i\u0005\u0011C/Z:u\u001d>$H)[:uS:\u001cGO\u0012:p[&s'j\\5o\u0007>tG-\u001b;j_:D#!\u0012\"\t\u000b%\u0003A\u0011\u0001\u001b\u00029Q,7\u000f\u001e)zi\"|g.\u0016#G\u0013:Tu.\u001b8D_:$\u0017\u000e^5p]\"\u0012\u0001J\u0011\u0005\u0006\u0019\u0002!\t\u0001N\u0001\u0010i\u0016\u001cH\u000fT8hS\u000e\fG\u000e\u00157b]\"\u00121J\u0011\u0005\u0006\u001f\u0002!\t\u0001N\u0001$i\u0016\u001cH\u000fT8hS\u000e\fG\u000e\u00157b]^KG\u000f[%na2L7-\u001b;UsB,7)Y:uQ\tq%\tC\u0003S\u0001\u0011\u0005A'A\u000buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0005E\u0013\u0005\"B+\u0001\t\u0003!\u0014!\u0007;fgRdUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016D#\u0001\u0016\"\t\u000ba\u0003A\u0011\u0001\u001b\u0002IQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b(fgR,G-U;fefD#a\u0016\"\t\u000bm\u0003A\u0011\u0001\u001b\u0002WQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b)s_*,7\r^5p]B+8\u000f\u001b#po:D#A\u0017\"\t\u000by\u0003A\u0011\u0001\u001b\u0002OQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b$jYR,'\u000fU;tQ\u0012{wO\u001c\u0015\u0003;\nCQ!\u0019\u0001\u0005\u0002Q\n!\u0004^3ti\u00063x.\u001b3BO\u001e\u0014XmZ1uKB+8\u000f\u001b#po:D#\u0001\u0019\"\t\u000b\u0011\u0004A\u0011\u0001\u001b\u0002MQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b+sk\u0016\u001cuN\u001c3ji&|g\u000e\u000b\u0002d\u0005\")q\r\u0001C\u0001i\u00059C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7oQ\t1'\tC\u0003k\u0001\u0011\u0005A'\u0001\u001auKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0017I\u001c3QkNDGi\\<oQ\tI'\tC\u0003n\u0001\u0011\u0005A'A\u0006uKN$(+Z;tS:<\u0007F\u00017C\u0011\u0015\u0001\b\u0001\"\u0003r\u0003U)\u0007\u0010]3di\u0016C8-\u001a9uS>tG\u000b\u001b:po:$B!\u000e:{y\")Qa\u001ca\u0001gB\u0011Ao\u001e\b\u0003?UL!A\u001e\u0011\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003m\u0002BQa_8A\u0002M\f\u0001b[3zo>\u0014Hm\u001d\u0005\b{>\u0004\n\u00111\u0001\u007f\u0003\u0015\u0019G.\u0019>{a\ry\u0018\u0011\u0002\t\u0006i\u0006\u0005\u0011QA\u0005\u0004\u0003\u0007I(!B\"mCN\u001c\b\u0003BA\u0004\u0003\u0013a\u0001\u0001B\u0006\u0002\fq\f\t\u0011!A\u0003\u0002\u00055!aA0%cE!\u0011qBA\u000b!\ry\u0012\u0011C\u0005\u0004\u0003'\u0001#a\u0002(pi\"Lgn\u001a\t\u0005\u0003/\t9C\u0004\u0003\u0002\u001a\u0005\rb\u0002BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}A#\u0001\u0004=e>|GOP\u0005\u0002C%\u0019\u0011Q\u0005\u0011\u0002\u000fA\f7m[1hK&!\u0011\u0011FA\u0016\u0005%!\u0006N]8xC\ndWMC\u0002\u0002&\u0001B\u0011\"a\f\u0001#\u0003%I!!\r\u0002?\u0015D\b/Z2u\u000bb\u001cW\r\u001d;j_:$\u0006N]8x]\u0012\"WMZ1vYR$3'\u0006\u0002\u00024A\"\u0011QGA\u001d!\u0015!\u0018\u0011AA\u001c!\u0011\t9!!\u000f\u0005\u0019\u0005-\u0011QFA\u0001\u0002\u0003\u0015\t!!\u0004)\u000f\u0001\ti$!\u0013\u0002LA!\u0011qHA#\u001b\t\t\tEC\u0002\u0002Dm\naA];o]\u0016\u0014\u0018\u0002BA$\u0003\u0003\u0012qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002NA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002Tm\nqA];o]\u0016\u00148/\u0003\u0003\u0002X\u0005E#!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0002\\\tA\t!!\u0018\u0002\u001d1{wn[;q\u0015>Lg\u000eV3tiB\u0019\u0001&a\u0018\u0007\r\u0005\u0011\u0001\u0012AA1'\u0011\ty&a\u0019\u0011\u0007}\t)'C\u0002\u0002h\u0001\u0012a!\u00118z%\u00164\u0007bB\u0013\u0002`\u0011\u0005\u00111\u000e\u000b\u0003\u0003;B\u0001\"a\u001c\u0002`\u0011\u0005\u0011\u0011O\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA:!\u0019\t)(a \u0002\u00046\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(\u0001\u0003vi&d'BAA?\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0015q\u000f\u0002\u000b\u0007>dG.Z2uS>t\u0007#B\u0010\u0002\u0006\u0006%\u0015bAADA\t)\u0011I\u001d:bsB!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006m\u0014\u0001\u00027b]\u001eLA!a%\u0002\u000e\n1qJ\u00196fGRD\u0003\"!\u001c\u0002\u0018\u0006\u0015\u0016q\u0015\t\u0005\u00033\u000byJ\u0004\u0003\u0002P\u0005m\u0015\u0002BAO\u0003#\nQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BAQ\u0003G\u0013!\u0002U1sC6,G/\u001a:t\u0015\u0011\ti*!\u0015\u0002\t9\fW.Z\u0011\u0003\u0003S\u000bQ\u0003T3hC\u000eLH+\u00192mKN{WO]2f{m\u0004T\u0010")
public class LookupJoinTest
extends TableTestBase {
    private final boolean legacyTableSource;
    private final BatchTableTestUtil testUtil;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("id");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("name");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("age");

    @Parameterized.Parameters(name="LegacyTableSource={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil testUtil() {
        return this.testUtil;
    }

    @Before
    public void before() {
        this.testUtil().addDataStream("T0", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$4 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.testUtil().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.testUtil().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        Table myTable = this.testUtil().tableEnv().sqlQuery("SELECT *, PROCTIME() as proctime FROM T0");
        this.testUtil().tableEnv().createTemporaryView("MyTable", myTable);
        if (this.legacyTableSource) {
            TestTemporalTable$.MODULE$.createTemporaryTable(this.testUtil().tableEnv(), "LookupTable", true);
        } else {
            this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE LookupTable (\n          |  `id` INT,\n          |  `name` STRING,\n          |  `age` INT\n          |) WITH (\n          |  'connector' = 'values',\n          |  'bounded' = 'true'\n          |)\n          |")).stripMargin());
            this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE LookupTableWithComputedColumn (\n          |  `id` INT,\n          |  `name` STRING,\n          |  `age` INT,\n          |  `nominal_age` as age + 1\n          |) WITH (\n          |  'connector' = 'values',\n          |  'bounded' = 'true'\n          |)\n          |")).stripMargin());
        }
    }

    @Test
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proc AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM LookupTable FOR SYSTEM_TIME AS OF TIMESTAMP '2017-08-09 14:36:11'", "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with a constant timestamp '2017-08-09 14:36:11' is not supported yet", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", null, AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 1", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
    }

    @Test
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @Test
    public void testPythonUDFInJoinCondition() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Only inner join condition with equality predicates supports the Python UDF taking the inputs from the left table and the right table at the same time, e.g., ON T1.id = T2.id && pythonUdf(T1.a, T2.b)");
        this.testUtil().addFunction("pyFunc", new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |LEFT OUTER JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND pyFunc(D.age, T.a) > 100\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testLogicalPlan() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT T.* FROM (", ") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql1})))).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (", ") AS T\n         |GROUP BY b\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql2})))).stripMargin();
        FlinkChainedProgram programs = FlinkBatchProgram$.MODULE$.buildProgram(this.testUtil().tableEnv().getConfig().getConfiguration());
        programs.remove(FlinkBatchProgram$.MODULE$.PHYSICAL());
        this.testUtil().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.testUtil().verifyRelPlan(sql);
    }

    @Test
    public void testLogicalPlanWithImplicitTypeCast() {
        FlinkChainedProgram programs = FlinkBatchProgram$.MODULE$.buildProgram(this.testUtil().tableEnv().getConfig().getConfiguration());
        programs.remove(FlinkBatchProgram$.MODULE$.PHYSICAL());
        this.testUtil().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("VARCHAR(2147483647) and INTEGER does not have common type now");
        this.testUtil().verifyRelPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id");
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT T.* FROM (", ") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql1})))).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (", ") AS T\n         |GROUP BY b\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql2})))).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithTrueCondition() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.testUtil().verifyExplain(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testReusing() {
        this.testUtil().tableEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, true);
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM (", ") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql1})))).stripMargin();
        String sql3 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT id as a, b FROM (", ") AS T\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql2})))).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT count(T1.a), count(T1.id), sum(T2.a)\n         |FROM (", ") AS T1, (", ") AS T2\n         |WHERE T1.a = T2.a\n         |GROUP BY T1.b, T2.b\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql2, sql3})))).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    private void expectExceptionThrown(String sql, String keywords, Class<? extends Throwable> clazz) {
        Throwable throwable2;
        block5: {
            try {
                this.testUtil().verifyExplain(sql);
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a ", ", but no exception is thrown."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz})));
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                Class<?> clazz2 = throwable3.getClass();
                Class<? extends Throwable> clazz3 = clazz;
                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                    BoxedUnit boxedUnit;
                    if (keywords == null) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Assert.assertTrue((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The actual exception message \\n", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable3.getMessage()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"doesn't contain expected keyword \\n", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keywords}))).toString(), (boolean)throwable3.getMessage().contains(keywords));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
                if (throwable3 == null) break block5;
                Throwable throwable4 = throwable3;
                throwable4.printStackTrace();
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected throw ", ", but is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getSimpleName(), throwable4})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }

    public LookupJoinTest(boolean legacyTableSource) {
        this.legacyTableSource = legacyTableSource;
        this.testUtil = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

