/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.calcite.Expand;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001#\tQb\t\\5oWJ+G.\u00143S_^\u001cu\u000e\u001c7bi&|g\u000eV3ti*\u00111\u0001B\u0001\t[\u0016$\u0018\rZ1uC*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u00033\u0019c\u0017N\\6SK2lE\rS1oI2,'\u000fV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"a\u0005\u0001\t\u0011m\u0001\u0001R1A\u0005\u0012q\tqbY8mY\u0006$\u0018n\u001c8WC2,Xm]\u000b\u0002;A\u0011a$J\u0007\u0002?)\u0011\u0001%I\u0001\bY><\u0017nY1m\u0015\t\u00113%A\u0002sK2T!\u0001\n\u0007\u0002\u000f\r\fGnY5uK&\u0011ae\b\u0002\u000e\u0019><\u0017nY1m-\u0006dW/Z:\t\u0011!\u0002\u0001\u0012!Q!\nu\t\u0001cY8mY\u0006$\u0018n\u001c8WC2,Xm\u001d\u0011\t\u000b)\u0002A\u0011A\u0016\u00023Q,7\u000f^\"pY2\fG/[8og>sG+\u00192mKN\u001b\u0017M\u001c\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t!QK\\5uQ\tI3\u0007\u0005\u00025o5\tQG\u0003\u00027\u001d\u0005)!.\u001e8ji&\u0011\u0001(\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003;\u0001\u0011\u00051&\u0001\fuKN$8i\u001c7mCRLwN\\:P]Z\u000bG.^3tQ\tI4\u0007C\u0003>\u0001\u0011\u00051&A\fuKN$8i\u001c7mCRLwN\\:P]B\u0013xN[3di\"\u0012Ah\r\u0005\u0006\u0001\u0002!\taK\u0001\u0017i\u0016\u001cHoQ8mY\u0006$\u0018n\u001c8t\u001f:4\u0015\u000e\u001c;fe\"\u0012qh\r\u0005\u0006\u0007\u0002!\taK\u0001\u0017i\u0016\u001cHoQ8mY\u0006$\u0018n\u001c8t\u001f:,\u0005\u0010]1oI\"\u0012!i\r\u0005\u0006\r\u0002!\taK\u0001\u0019i\u0016\u001cHoQ8mY\u0006$\u0018n\u001c8t\u001f:,\u0005p\u00195b]\u001e,\u0007FA#4\u0011\u0015I\u0005\u0001\"\u0001,\u0003Q!Xm\u001d;D_2d\u0017\r^5p]N|eNU1oW\"\u0012\u0001j\r\u0005\u0006\u0019\u0002!\taK\u0001\u0015i\u0016\u001cHoQ8mY\u0006$\u0018n\u001c8t\u001f:\u001cvN\u001d;)\u0005-\u001b\u0004\"B(\u0001\t\u0003Y\u0013A\u0006;fgR\u001cu\u000e\u001c7bi&|gn](o/&tGm\\<)\u00059\u001b\u0004\"\u0002*\u0001\t\u0003Y\u0013!\u0007;fgR\u001cu\u000e\u001c7bi&|gn](o\u0003\u001e<'/Z4bi\u0016D#!U\u001a\t\u000bU\u0003A\u0011A\u0016\u0002)Q,7\u000f^\"pY2\fG/[8og>s'j\\5oQ\t!6\u0007C\u0003Y\u0001\u0011\u00051&A\u000buKN$8i\u001c7mCRLwN\\:P]Vs\u0017n\u001c8)\u0005]\u001b\u0004\"B.\u0001\t\u0003Y\u0013!\u0007;fgR\u001cu\u000e\u001c7bi&|gn](o\u0013:$XM]:fGRD#AW\u001a\t\u000by\u0003A\u0011A\u0016\u0002+Q,7\u000f^\"pY2\fG/[8og>sW*\u001b8vg\"\u0012Ql\r\u0005\u0006C\u0002!\taK\u0001\u0018i\u0016\u001cHoQ8mY\u0006$\u0018n\u001c8t\u001f:$UMZ1vYRD#\u0001Y\u001a\t\u000b\u0011\u0004A\u0011B3\u0002+\r|gN^3siR{'+\u001a7D_2d\u0017\r^5p]R\u0011aM\u001b\t\u0003O\"l\u0011!I\u0005\u0003S\u0006\u0012ABU3m\u0007>dG.\u0019;j_:DQa[2A\u00021\f!C]3m\r&,G\u000eZ\"pY2\fG/[8ogB\u0019Q.\u001e=\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9\u0011\u0003\u0019a$o\\8u}%\tq&\u0003\u0002u]\u00059\u0001/Y2lC\u001e,\u0017B\u0001<x\u0005\u0011a\u0015n\u001d;\u000b\u0005Qt\u0003CA\u0017z\u0013\tQhFA\u0002J]R\u0004")
public class FlinkRelMdRowCollationTest
extends FlinkRelMdHandlerTestBase {
    private LogicalValues collationValues;
    private volatile boolean bitmap$0;

    private LogicalValues collationValues$lzycompute() {
        FlinkRelMdRowCollationTest flinkRelMdRowCollationTest = this;
        synchronized (flinkRelMdRowCollationTest) {
            if (!this.bitmap$0) {
                RelDataType valuesType = this.relBuilder().getTypeFactory().builder().add("a", SqlTypeName.BIGINT).add("b", SqlTypeName.DOUBLE).add("c", SqlTypeName.BOOLEAN).add("d", SqlTypeName.INTEGER).build();
                List tupleList = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "9.0", "true", "2"})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2", "6.0", "false", "3"})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3", "3.0", "true", "4"}))})).map((Function1)new Serializable(this, valuesType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FlinkRelMdRowCollationTest $outer;
                    private final RelDataType valuesType$1;

                    public final java.util.List<RexLiteral> apply(List<String> x$1) {
                        return this.$outer.createLiteralList(this.valuesType$1, (Seq<String>)x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.valuesType$1 = valuesType$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                this.relBuilder().clear();
                this.relBuilder().values((Iterable)JavaConversions$.MODULE$.seqAsJavaList((Seq)tupleList), valuesType);
                this.collationValues = (LogicalValues)this.relBuilder().build();
                this.bitmap$0 = true;
            }
            return this.collationValues;
        }
    }

    public LogicalValues collationValues() {
        return this.bitmap$0 ? this.collationValues : this.collationValues$lzycompute();
    }

    @Test
    public void testCollationsOnTableScan() {
        Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentBatchScan(), this.studentStreamScan()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(TableScan scan) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations((RelNode)scan));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnValues() {
        Assert.assertEquals((Object)ImmutableList.of((Object)RelCollations.of((int)6)), (Object)this.mq().collations((RelNode)this.logicalValues()));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToInteger((int)8), (Integral)Numeric.IntIsIntegral$.MODULE$)))), (Object)this.mq().collations((RelNode)this.emptyValues()));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)RelCollations.of((int)3)), (Object)this.mq().collations((RelNode)this.collationValues()));
    }

    @Test
    public void testCollationsOnProject() {
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.mq().collations((RelNode)this.logicalProject()));
        this.relBuilder().push((RelNode)this.collationValues());
        List projects = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))}), this.relBuilder().field(2), this.relBuilder().field(3), this.rexBuilder().makeLiteral((Object)BoxesRunTime.boxToLong((long)2L), this.longType(), true)}));
        LogicalProject project = (LogicalProject)this.relBuilder().project((Iterable)JavaConversions$.MODULE$.seqAsJavaList((Seq)projects)).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)RelCollations.of((int)2)), (Object)this.mq().collations((RelNode)project));
        this.relBuilder().clear();
        RelDataType valuesType = this.relBuilder().getTypeFactory().builder().add("a", SqlTypeName.BIGINT).add("ts", SqlTypeName.VARCHAR).build();
        List tupleList = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3", "2015-07-24 10:00:00"}))})).map((Function1)new Serializable(this, valuesType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;
            private final RelDataType valuesType$2;

            public final java.util.List<RexLiteral> apply(List<String> x$2) {
                return this.$outer.createLiteralList(this.valuesType$2, (Seq<String>)x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.valuesType$2 = valuesType$2;
            }
        }, List$.MODULE$.canBuildFrom());
        this.relBuilder().values((Iterable)JavaConversions$.MODULE$.seqAsJavaList((Seq)tupleList), valuesType);
        RelNode project2 = this.relBuilder().project(new RexNode[]{this.relBuilder().field(0), this.relBuilder().call((SqlOperator)FlinkSqlOperatorTable.UNIX_TIMESTAMP, new RexNode[]{this.relBuilder().field(1)})}).build();
        Assert.assertTrue((boolean)this.mq().collations(project2).isEmpty());
        this.relBuilder().clear();
        this.relBuilder().values((Iterable)JavaConversions$.MODULE$.seqAsJavaList((Seq)tupleList), valuesType);
        RelNode project3 = this.relBuilder().project(new RexNode[]{this.relBuilder().field(0), this.relBuilder().call((SqlOperator)FlinkSqlOperatorTable.UNIX_TIMESTAMP, new RexNode[0])}).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)RelCollations.of((int)1)), (Object)this.mq().collations(project3));
        this.relBuilder().clear();
        this.relBuilder().values((Iterable)JavaConversions$.MODULE$.seqAsJavaList((Seq)tupleList), valuesType);
        RelNode project4 = this.relBuilder().project(new RexNode[]{this.relBuilder().field(0), this.relBuilder().call((SqlOperator)FlinkSqlOperatorTable.UUID, new RexNode[0])}).build();
        Assert.assertTrue((boolean)this.mq().collations(project4).isEmpty());
    }

    @Test
    public void testCollationsOnFilter() {
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.mq().collations(this.logicalFilter()));
        this.relBuilder().push((RelNode)this.studentLogicalScan());
        this.relBuilder().push((RelNode)this.collationValues());
        RexNode expr = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))});
        LogicalFilter filter = (LogicalFilter)this.relBuilder().filter(new RexNode[]{expr}).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)this.convertToRelCollation((List<Object>)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$))), (Object)RelCollations.of((int)3)), (Object)this.mq().collations((RelNode)filter));
    }

    @Test
    public void testCollationsOnExpand() {
        Predef$.MODULE$.refArrayOps((Object[])new Expand[]{this.logicalExpand(), this.flinkLogicalExpand(), this.batchExpand(), this.streamExpand()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(Expand expand) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations((RelNode)expand));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnExchange() {
        Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(RelNode exchange) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations(exchange));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnRank() {
        Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchLocalRank(), this.streamRank()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(RelNode rank) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations(rank));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnSort() {
        Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort(), this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchSortLimit(), this.streamSortLimit()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(RelNode sort) {
                Assert.assertEquals((Object)ImmutableList.of((Object)RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(6), new RelFieldCollation(2, RelFieldCollation.Direction.DESCENDING)})), (Object)this.$outer.mq().collations(sort));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])new Sort[]{this.logicalLimit(), this.logicalLimit(), this.batchLimit(), this.streamLimit()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(Sort limit) {
                Assert.assertEquals((Object)ImmutableList.of((Object)RelCollations.of((RelFieldCollation[])new RelFieldCollation[0])), (Object)this.$outer.mq().collations((RelNode)limit));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnWindow() {
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.mq().collations((RelNode)this.flinkLogicalOverAgg()));
    }

    @Test
    public void testCollationsOnAggregate() {
        Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithLocal(), this.batchGlobalAggWithoutLocal(), this.batchLocalAgg()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(SingleRel agg) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations((RelNode)agg));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnJoin() {
        Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalInnerJoinOnUniqueKeys(), this.logicalLeftJoinNotOnUniqueKeys(), this.logicalRightJoinOnRHSUniqueKeys(), this.logicalFullJoinWithoutEquiCond(), this.logicalSemiJoinOnLHSUniqueKeys(), this.logicalAntiJoinOnRHSUniqueKeys()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(RelNode join) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations(join));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnUnion() {
        Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalUnion(), this.logicalUnionAll()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(RelNode union) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations(union));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnIntersect() {
        Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalIntersect(), this.logicalIntersectAll()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(RelNode intersect) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations(intersect));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnMinus() {
        Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalMinus(), this.logicalMinusAll()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdRowCollationTest $outer;

            public final void apply(RelNode minus) {
                Assert.assertEquals((Object)ImmutableList.of(), (Object)this.$outer.mq().collations(minus));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCollationsOnDefault() {
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.mq().collations((RelNode)this.testRel()));
    }

    private RelCollation convertToRelCollation(List<Object> relFieldCollations) {
        return RelCollations.of((RelFieldCollation[])((RelFieldCollation[])((TraversableOnce)relFieldCollations.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RelFieldCollation apply(int i) {
                return new RelFieldCollation(i);
            }
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RelFieldCollation.class))));
    }
}

