/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.calcite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalExpand;
import org.apache.flink.table.planner.plan.nodes.calcite.RelNodeTestBase;
import org.apache.flink.table.types.logical.LogicalType;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001'\tQQ\t\u001f9b]\u0012$Vm\u001d;\u000b\u0005\r!\u0011aB2bY\u000eLG/\u001a\u0006\u0003\u000b\u0019\tQA\\8eKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005=\u0011V\r\u001c(pI\u0016$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\t)\u0002\u0001C\u0004\u001e\u0001\t\u0007I\u0011\u0002\u0010\u0002\u0015\u0019LW\r\u001c3OC6,7/F\u0001 !\r\u00013%J\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t)\u0011I\u001d:bsB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005Y\u0006twMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#AB*ue&tw\r\u0003\u0004/\u0001\u0001\u0006IaH\u0001\fM&,G\u000e\u001a(b[\u0016\u001c\b\u0005C\u00041\u0001\t\u0007I\u0011B\u0019\u0002\u0015\u0019LW\r\u001c3UsB,7/F\u00013!\r\u00013e\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\nq\u0001\\8hS\u000e\fGN\u0003\u00029\u0015\u0005)A/\u001f9fg&\u0011!(\u000e\u0002\f\u0019><\u0017nY1m)f\u0004X\r\u0003\u0004=\u0001\u0001\u0006IAM\u0001\fM&,G\u000e\u001a+za\u0016\u001c\b\u0005\u0003\u0005?\u0001!\u0015\r\u0011\"\u0003@\u0003AawnZ5dC2$\u0016M\u00197f'\u000e\fg.F\u0001A!\t\te)D\u0001C\u0015\t14I\u0003\u0002E\u000b\u0006\u0019!/\u001a7\u000b\u0005\rq\u0011BA$C\u0005AaunZ5dC2$\u0016M\u00197f'\u000e\fg\u000e\u0003\u0005J\u0001!\u0005\t\u0015)\u0003A\u0003EawnZ5dC2$\u0016M\u00197f'\u000e\fg\u000e\t\u0005\u0006\u0017\u0002!\t\u0001T\u00011i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fI\u0016C\b/\u00198e!J|'.Z2ug^KG\u000f\u001b#jM\u001a,'/\u001a8u\u0019\u0016tw\r\u001e5\u0015\u00035\u0003\"\u0001\t(\n\u0005=\u000b#\u0001B+oSRDCAS)X1B\u0011!+V\u0007\u0002'*\u0011A\u000bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003-N\u0013A\u0001V3ti\u0006AQ\r\u001f9fGR,GmI\u0001Z!\t1#,\u0003\u0002\\O\tq\u0011i]:feRLwN\\#se>\u0014\b\"B/\u0001\t\u0003a\u0015\u0001\u000b;fgR,fn];qa>\u0014H/\u001a3FqB\fg\u000e\u001a)s_*,7\r^:XSRD'+\u001a=DC2d\u0007\u0006\u0002/R/bCQ\u0001\u0019\u0001\u0005\u00021\u000ba\u0006^3tiVs7/\u001e9q_J$X\rZ#ya\u0006tG\r\u0015:pU\u0016\u001cGo],ji\"tunQ8n[>tG+\u001f9fg\"\"q,U,Y\u0001")
public class ExpandTest
extends RelNodeTestBase {
    private final String[] fieldNames = (String[])((Object[])new String[]{"string", "double", "long"});
    private final LogicalType[] fieldTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
    private LogicalTableScan logicalTableScan;
    private volatile boolean bitmap$0;

    private LogicalTableScan logicalTableScan$lzycompute() {
        ExpandTest expandTest = this;
        synchronized (expandTest) {
            if (!this.bitmap$0) {
                this.logicalTableScan = this.buildLogicalTableScan(this.fieldNames(), this.fieldTypes());
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.fieldNames = null;
            this.fieldTypes = null;
            return this.logicalTableScan;
        }
    }

    private String[] fieldNames() {
        return this.fieldNames;
    }

    private LogicalType[] fieldTypes() {
        return this.fieldTypes;
    }

    private LogicalTableScan logicalTableScan() {
        return this.bitmap$0 ? this.logicalTableScan : this.logicalTableScan$lzycompute();
    }

    @Test(expected=AssertionError.class)
    public void testUnsupportedExpandProjectsWithDifferentLength() {
        List inputFields = this.logicalTableScan().getRowType().getFieldList();
        ArrayList expandProjects = new ArrayList();
        RexBuilder rexBuilder = this.logicalTableScan().getCluster().getRexBuilder();
        ArrayList<Object> project = new ArrayList<Object>();
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(1)).getType(), 1));
        project.add(rexBuilder.makeNullLiteral(((RelDataTypeField)inputFields.get(2)).getType()));
        expandProjects.add(project);
        ArrayList<Object> project2 = new ArrayList<Object>();
        project2.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project2.add(rexBuilder.makeBigintLiteral(new BigDecimal(1)));
        expandProjects.add(project2);
        new LogicalExpand(this.cluster(), this.logicalTableScan().getTraitSet(), (RelNode)this.logicalTableScan(), expandProjects, 2);
    }

    @Test(expected=AssertionError.class)
    public void testUnsupportedExpandProjectsWithRexCall() {
        List inputFields = this.logicalTableScan().getRowType().getFieldList();
        ArrayList expandProjects = new ArrayList();
        RexBuilder rexBuilder = this.logicalTableScan().getCluster().getRexBuilder();
        ArrayList<Object> project = new ArrayList<Object>();
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(1)).getType(), 1));
        project.add(rexBuilder.makeNullLiteral(((RelDataTypeField)inputFields.get(2)).getType()));
        expandProjects.add(project);
        ArrayList<Object> project2 = new ArrayList<Object>();
        project2.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project2.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{new RexInputRef(0, this.logicalTableScan().getRowType()), new RexInputRef(1, this.logicalTableScan().getRowType())}));
        project2.add(rexBuilder.makeBigintLiteral(new BigDecimal(1)));
        expandProjects.add(project2);
        new LogicalExpand(this.cluster(), this.logicalTableScan().getTraitSet(), (RelNode)this.logicalTableScan(), expandProjects, 2);
    }

    @Test(expected=AssertionError.class)
    public void testUnsupportedExpandProjectsWithNoCommonTypes() {
        List inputFields = this.logicalTableScan().getRowType().getFieldList();
        ArrayList expandProjects = new ArrayList();
        RexBuilder rexBuilder = this.logicalTableScan().getCluster().getRexBuilder();
        ArrayList<Object> project = new ArrayList<Object>();
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project.add(rexBuilder.makeBinaryLiteral(ByteString.of((String)"10001", (int)2)));
        project.add(rexBuilder.makeNullLiteral(((RelDataTypeField)inputFields.get(2)).getType()));
        expandProjects.add(project);
        ArrayList<Object> project2 = new ArrayList<Object>();
        project2.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project2.add(rexBuilder.makeTimestampLiteral(new TimestampString("2021-03-23 23:11:17.123"), 3));
        project2.add(rexBuilder.makeBigintLiteral(new BigDecimal(1)));
        expandProjects.add(project2);
        new LogicalExpand(this.cluster(), this.logicalTableScan().getTraitSet(), (RelNode)this.logicalTableScan(), expandProjects, 2);
    }
}

