/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonSerializer;
import org.apache.flink.types.RowKind;
import org.junit.Assert;
import org.junit.Test;

public class ChangelogModeJsonSerdeTest {
    @Test
    public void testChangelogModeSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new ChangelogModeJsonSerializer());
        module.addDeserializer(ChangelogMode.class, (JsonDeserializer)new ChangelogModeJsonDeserializer());
        mapper.registerModule((Module)module);
        ChangelogMode changelogMode = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.DELETE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.UPDATE_BEFORE).build();
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)changelogMode);
        }
        String json = writer.toString();
        ChangelogMode actual = (ChangelogMode)mapper.readValue(json, ChangelogMode.class);
        Assert.assertEquals((Object)changelogMode, (Object)actual);
    }
}

