/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.spec.IntervalJoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntervalJoinSpecJsonSerdeTest {
    private ObjectMapper mapper;

    @Before
    public void setUp() {
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        this.mapper.registerModule((Module)module);
    }

    @Test
    public void testWindowBoundsSerde() throws IOException {
        IntervalJoinSpec.WindowBounds windowBounds = new IntervalJoinSpec.WindowBounds(true, 0L, 10L, 1, 2);
        Assert.assertEquals((Object)windowBounds, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)windowBounds), IntervalJoinSpec.WindowBounds.class));
    }

    @Test
    public void testIntervalJoinSpecSerde() throws IOException {
        JoinSpec joinSpec = new JoinSpec(FlinkJoinType.ANTI, new int[]{1}, new int[]{1}, new boolean[]{true}, null);
        IntervalJoinSpec.WindowBounds windowBounds = new IntervalJoinSpec.WindowBounds(true, 0L, 10L, 1, 2);
        IntervalJoinSpec actual = new IntervalJoinSpec(joinSpec, windowBounds);
        Assert.assertEquals((Object)actual, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)actual), IntervalJoinSpec.class));
    }
}

