/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JoinSpecJsonSerdeTest {
    private ObjectMapper mapper;

    @Before
    public void setUp() {
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        this.mapper.registerModule((Module)module);
    }

    @Test
    public void testJoinSpecSerde() throws IOException {
        JoinSpec joinSpec = new JoinSpec(FlinkJoinType.ANTI, new int[]{1}, new int[]{1}, new boolean[]{true}, null);
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = this.mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)joinSpec);
        }
        String json = writer.toString();
        JoinSpec actual = (JoinSpec)this.mapper.readValue(json, JoinSpec.class);
        Assert.assertEquals((Object)joinSpec, (Object)actual);
    }
}

