/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.typeutils.DataViewUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalTypeSerdeTest {
    @Parameterized.Parameter
    public LogicalType logicalType;

    @Test
    public void testLogicalTypeSerde() throws IOException {
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)new FlinkContextImpl(TableConfig.getDefault(), null, null, null), Thread.currentThread().getContextClassLoader(), FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new LogicalTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new ObjectIdentifierJsonSerializer());
        module.addDeserializer(LogicalType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        mapper.registerModule((Module)module);
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)this.logicalType);
        }
        String json = writer.toString();
        LogicalType actual = (LogicalType)mapper.readValue(json, LogicalType.class);
        Assert.assertEquals((Object)this.logicalType, (Object)actual);
        Assert.assertEquals((Object)this.logicalType.asSummaryString(), (Object)actual.asSummaryString());
    }

    @Parameterized.Parameters(name="{0}")
    public static List<LogicalType> testData() {
        List<LogicalType> types = Arrays.asList(new BooleanType(), new TinyIntType(), new SmallIntType(), new IntType(), new BigIntType(), new FloatType(), new DoubleType(), new DecimalType(10), new DecimalType(15, 5), CharType.ofEmptyLiteral(), new CharType(), new CharType(5), VarCharType.ofEmptyLiteral(), new VarCharType(), new VarCharType(5), BinaryType.ofEmptyLiteral(), new BinaryType(), new BinaryType(100), VarBinaryType.ofEmptyLiteral(), new VarBinaryType(), new VarBinaryType(100), new DateType(), new TimeType(), new TimeType(3), new TimestampType(), new TimestampType(3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new TimestampType(false, TimestampKind.ROWTIME, 3), new ZonedTimestampType(), new ZonedTimestampType(3), new ZonedTimestampType(false, TimestampKind.ROWTIME, 3), new LocalZonedTimestampType(), new LocalZonedTimestampType(3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR), new DayTimeIntervalType(false, DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR, 3, 6), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH), new YearMonthIntervalType(false, YearMonthIntervalType.YearMonthResolution.MONTH, 2), new ZonedTimestampType(), new LocalZonedTimestampType(), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new SymbolType(TimeIntervalUnit.class), new TypeInformationRawType(), new TypeInformationRawType(Types.STRING), new LegacyTypeInformationType(LogicalTypeRoot.RAW, Types.STRING), new ArrayType((LogicalType)new IntType(false)), new ArrayType((LogicalType)new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3)), new ArrayType((LogicalType)new ZonedTimestampType(false, TimestampKind.ROWTIME, 3)), new ArrayType((LogicalType)new TimestampType()), new ArrayType((LogicalType)CharType.ofEmptyLiteral()), new ArrayType((LogicalType)VarCharType.ofEmptyLiteral()), new ArrayType((LogicalType)BinaryType.ofEmptyLiteral()), new ArrayType((LogicalType)VarBinaryType.ofEmptyLiteral()), new MapType((LogicalType)new BigIntType(), (LogicalType)new IntType(false)), new MapType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3), (LogicalType)new ZonedTimestampType()), new MapType((LogicalType)CharType.ofEmptyLiteral(), (LogicalType)CharType.ofEmptyLiteral()), new MapType((LogicalType)VarCharType.ofEmptyLiteral(), (LogicalType)VarCharType.ofEmptyLiteral()), new MapType((LogicalType)BinaryType.ofEmptyLiteral(), (LogicalType)BinaryType.ofEmptyLiteral()), new MapType((LogicalType)VarBinaryType.ofEmptyLiteral(), (LogicalType)VarBinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)new IntType(false)), new MultisetType((LogicalType)new TimestampType()), new MultisetType((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 3)), new MultisetType((LogicalType)CharType.ofEmptyLiteral()), new MultisetType((LogicalType)VarCharType.ofEmptyLiteral()), new MultisetType((LogicalType)BinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)VarBinaryType.ofEmptyLiteral()), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}, (String[])new String[]{"f1", "f2", "f3"}), RowType.of((LogicalType[])new LogicalType[]{new TimestampType(false, TimestampKind.ROWTIME, 3), new TimestampType(false, TimestampKind.REGULAR, 3), new ZonedTimestampType(false, TimestampKind.ROWTIME, 3), new ZonedTimestampType(false, TimestampKind.REGULAR, 3), new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new LocalZonedTimestampType(false, TimestampKind.REGULAR, 3)}), RowType.of((LogicalType[])new LogicalType[]{CharType.ofEmptyLiteral(), VarCharType.ofEmptyLiteral(), BinaryType.ofEmptyLiteral(), VarBinaryType.ofEmptyLiteral()}), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"structuredType"), PojoClass.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BigIntType(true)), new StructuredType.StructuredAttribute("f2", (LogicalType)new VarCharType(200), "desc"))).comparision(StructuredType.StructuredComparision.FULL).setFinal(false).setInstantiable(false).superType(StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"structuredType2")).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("f0", (LogicalType)new BigIntType(false)))).build()).description("description for StructuredType").build(), DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"distinctType"), (LogicalType)new VarCharType(5)).build(), DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"distinctType"), (LogicalType)new VarCharType(false, 5)).build(), new RawType(PojoClass.class, (TypeSerializer)new KryoSerializer(PojoClass.class, new ExecutionConfig())));
        ArrayList<LogicalType> mutableTypes = new ArrayList<LogicalType>(types);
        LogicalTypeSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new VarCharType(100), (LogicalType)new VarCharType(100));
        LogicalTypeSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new VarCharType(100), (LogicalType)new BigIntType());
        LogicalTypeSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new BigIntType(), (LogicalType)new VarCharType(100));
        LogicalTypeSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new BigIntType(), (LogicalType)new BigIntType());
        LogicalTypeSerdeTest.addRawTypesForListView(mutableTypes, (LogicalType)new VarCharType(100));
        LogicalTypeSerdeTest.addRawTypesForListView(mutableTypes, (LogicalType)new BigIntType());
        ArrayList<LogicalType> finalTypes = new ArrayList<LogicalType>();
        for (LogicalType type : mutableTypes) {
            finalTypes.add(type.copy(true));
            finalTypes.add(type.copy(false));
        }
        finalTypes.add((LogicalType)new NullType());
        return finalTypes;
    }

    private static void addRawTypesForMapView(List<LogicalType> types, LogicalType keyType, LogicalType valueType) {
        for (boolean hasStateBackedDataViews : Arrays.asList(true, false)) {
            for (boolean keyNullable : Arrays.asList(true, false)) {
                for (boolean isInternalKeyType : Arrays.asList(true, false)) {
                    for (boolean valueNullable : Arrays.asList(true, false)) {
                        for (boolean isInternalValueType : Arrays.asList(true, false)) {
                            types.add(LogicalTypeDataTypeConverter.toLogicalType((DataType)DataViewUtils.adjustDataViews((DataType)MapView.newMapViewDataType((DataType)LogicalTypeSerdeTest.convertToInternalTypeIfNeeded(LogicalTypeDataTypeConverter.toDataType((LogicalType)keyType.copy(keyNullable)), isInternalKeyType), (DataType)LogicalTypeSerdeTest.convertToInternalTypeIfNeeded(LogicalTypeDataTypeConverter.toDataType((LogicalType)valueType.copy(valueNullable)), isInternalValueType)), (boolean)hasStateBackedDataViews)));
                        }
                    }
                }
            }
        }
    }

    private static void addRawTypesForListView(List<LogicalType> types, LogicalType elementType) {
        for (boolean hasStateBackedDataViews : Arrays.asList(true, false)) {
            for (boolean elementNullable : Arrays.asList(true, false)) {
                for (boolean isInternalType : Arrays.asList(true, false)) {
                    types.add(LogicalTypeDataTypeConverter.toLogicalType((DataType)DataViewUtils.adjustDataViews((DataType)ListView.newListViewDataType((DataType)LogicalTypeSerdeTest.convertToInternalTypeIfNeeded(LogicalTypeDataTypeConverter.toDataType((LogicalType)elementType.copy(elementNullable)), isInternalType)), (boolean)hasStateBackedDataViews)));
                }
            }
        }
    }

    private static DataType convertToInternalTypeIfNeeded(DataType dataType, boolean isInternalType) {
        return isInternalType ? DataTypeUtils.toInternalDataType((DataType)dataType) : dataType;
    }

    public static class PojoClass {
        private final int f0;
        private final long f1;
        private final String f2;

        public PojoClass(int f0, long f1, String f2) {
            this.f0 = f0;
            this.f1 = f1;
            this.f2 = f2;
        }
    }
}

