/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.junit.Assert;
import org.junit.Test;

public class LookupKeySerdeTest {
    @Test
    public void testLookupKey() throws JsonProcessingException {
        LookupJoinUtil.LookupKey[] lookupKeys;
        TableConfig tableConfig = TableConfig.getDefault();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(Thread.currentThread().getContextClassLoader()).config((ReadableConfig)tableConfig.getConfiguration()).defaultCatalog("default_catalog", (Catalog)new GenericInMemoryCatalog("default_db")).build();
        FlinkContextImpl flinkContext = new FlinkContextImpl(tableConfig, new FunctionCatalog(tableConfig, catalogManager, new ModuleManager()), catalogManager, null);
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)flinkContext, Thread.currentThread().getContextClassLoader(), FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new LogicalTypeJsonSerializer());
        module.addDeserializer(LogicalType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        mapper.registerModule((Module)module);
        for (LookupJoinUtil.LookupKey lookupKey : lookupKeys = new LookupJoinUtil.LookupKey[]{new LookupJoinUtil.ConstantLookupKey((LogicalType)new BigIntType(), new RexBuilder((RelDataTypeFactory)FlinkTypeFactory.INSTANCE()).makeLiteral("a")), new LookupJoinUtil.FieldRefLookupKey(3)}) {
            LookupJoinUtil.LookupKey result = (LookupJoinUtil.LookupKey)mapper.readValue(mapper.writeValueAsString((Object)lookupKey), LookupJoinUtil.LookupKey.class);
            Assert.assertEquals((Object)lookupKey, (Object)result);
        }
    }
}

