/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class WatermarkAssignerJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
    }

    @Test
    public void testWatermarkAssigner() {
        String srcTableDdl = "CREATE TABLE WatermarkTable (\n  a bigint,\n  b int,\n  c timestamp(3),\n  watermark for c as c - interval '5' second\n) with (\n  'connector' = 'values',\n  'bounded' = 'false',  'enable-watermark-push-down' = 'false',  'disable-lookup' = 'true')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE sink (\n  a bigint,\n  b int,\n  c timestamp(3)\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into sink select * from WatermarkTable");
    }
}

