/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRule$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001'\tQ2i\u001c8wKJ$Hk\u001c(pi&swJ]%o%VdW\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQa]3ukB$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'N\u0007\u0002g)\u0011A\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003mM\u0012aAQ3g_J,\u0007\"\u0002\u001d\u0001\t\u0003I\u0013!\n;fgR\u001cuN\u001c<feR$v.\u00138`\u0019\u0016\u001c8\u000f\u00165b]RC'/Z:i_2$w,\u00138uQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&A\u0013uKN$8i\u001c8wKJ$Hk\\%o?\u0016\u000bX/\u00197t)>$\u0006N]3tQ>dGmX%oi\"\u0012QH\u000f\u0005\u0006\u0003\u0002!\t!K\u0001)i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8J]~;%/Z1uKJ$\u0006.\u00198UQJ,7\u000f[8mI~Ke\u000e\u001e\u0015\u0003\u0001jBQ\u0001\u0012\u0001\u0005\u0002%\n\u0001\u0006^3ti\u000e{gN^3siR{\u0017J\\0MKN\u001cH\u000b[1o)\"\u0014Xm\u001d5pY\u0012|Fi\\;cY\u0016D#a\u0011\u001e\t\u000b\u001d\u0003A\u0011A\u0015\u0002WQ,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:|vI]3bi\u0016\u0014H\u000b[1o)\"\u0014Xm\u001d5pY\u0012|Fi\\;cY\u0016D#A\u0012\u001e\t\u000b)\u0003A\u0011A\u0015\u0002/Q,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:|v+\u001b;i\u001fJ\f\u0004FA%;\u0011\u0015i\u0005\u0001\"\u0001*\u0003]!Xm\u001d;D_:4XM\u001d;U_&swlV5uQ>\u0013(\u0007\u000b\u0002Mu!)\u0001\u000b\u0001C\u0001S\u0005AB/Z:u\u0007>tg/\u001a:u)>LenX,ji\"\fe\u000eZ\u0019)\u0005=S\u0004\"B*\u0001\t\u0003I\u0013\u0001\u0007;fgR\u001cuN\u001c<feR$v.\u00138`/&$\b.\u00118ee!\u0012!K\u000f\u0005\u0006-\u0002!\t!K\u0001)i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLen\u0018'fgN$\u0006.\u00198UQJ,7\u000f[8mI~Ke\u000e\u001e\u0015\u0003+jBQ!\u0017\u0001\u0005\u0002%\n\u0001\u0006^3ti\u000e{gN^3siR{gj\u001c;J]~+\u0015/^1mgR{G\u000b\u001b:fg\"|G\u000eZ0J]RD#\u0001\u0017\u001e\t\u000bq\u0003A\u0011A\u0015\u0002WQ,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0He\u0016\fG/\u001a:UQ\u0006tG\u000b\u001b:fg\"|G\u000eZ0J]RD#a\u0017\u001e\t\u000b}\u0003A\u0011A\u0015\u0002WQ,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0MKN\u001cH\u000b[1o)\"\u0014Xm\u001d5pY\u0012|Fi\\;cY\u0016D#A\u0018\u001e\t\u000b\t\u0004A\u0011A\u0015\u0002]Q,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0He\u0016\fG/\u001a:UQ\u0006tG\u000b\u001b:fg\"|G\u000eZ0E_V\u0014G.\u001a\u0015\u0003CjBQ!\u001a\u0001\u0005\u0002%\n!\u0004^3ti\u000e{gN^3siR{gj\u001c;J]~;\u0016\u000e\u001e5PeFB#\u0001\u001a\u001e\t\u000b!\u0004A\u0011A\u0015\u00025Q,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0XSRDwJ\u001d\u001a)\u0005\u001dT\u0004\"B6\u0001\t\u0003I\u0013A\u0007;fgR\u001cuN\u001c<feR$vNT8u\u0013:|v+\u001b;i\u001fJ\u001c\u0004F\u00016;\u0011\u0015q\u0007\u0001\"\u0001*\u0003m!Xm\u001d;D_:4XM\u001d;U_:{G/\u00138`/&$\b.\u00118ec!\u0012QN\u000f\u0005\u0006c\u0002!\t!K\u0001\u001ci\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLenX,ji\"\fe\u000e\u001a\u001a)\u0005AT\u0004\"\u0002;\u0001\t\u0003I\u0013\u0001\u0007;fgR\u001cuN\u001c<feR$v.\u00138B]\u0012tu\u000e^%oc!\u00121O\u000f\u0005\u0006o\u0002!\t!K\u0001\u0019i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8J]\u0006sGMT8u\u0013:\u0014\u0004F\u0001<;\u0011\u0015Q\b\u0001\"\u0001*\u0003a!Xm\u001d;D_:4XM\u001d;U_&s\u0017I\u001c3O_RLen\r\u0015\u0003sj\u0002")
public class ConvertToNotInOrInRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("e");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ConvertToNotInOrInRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5)}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)((String)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3");
    }

    @Test
    public void testConvertToIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR a = 5");
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1");
    }

    @Test
    public void testConvertToIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR b = 1 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a = 1 OR a = 2 OR a = 3 OR a = 4) AND b = 1");
    }

    @Test
    public void testConvertToIn_WithAnd2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3");
    }

    @Test
    public void testConvertToNotIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4");
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND a = 5");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToNotIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4) OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 OR a <> 2 OR a <> 3 OR a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd2() {
        String sqlQuery = "SELECT * FROM MyTable WHERE a <> 1 AND a <> 2  AND b = 1 AND a <> 3 AND a <> 4";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testConvertToInAndNotIn1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR a = 1 OR a = 2 OR a = 3 OR a = 4  AND (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR b = 2 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND c = 1) OR b = 3 OR b = 4 OR c = 1");
    }
}

