/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.CorrelateSortToRankRule$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001'\tY2i\u001c:sK2\fG/Z*peR$vNU1oWJ+H.\u001a+fgRT!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006q\u0001!\t!K\u0001\u0018i\u0016\u001cHoQ8se\u0016d\u0017\r^3T_J$Hk\u001c*b].D#a\u000e\u001e\u0011\u0005IZ\u0014B\u0001\u001f4\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0015\u00029Q,7\u000f\u001e(p]&sg.\u001a:K_&tgj\u001c;TkB\u0004xN\u001d;fI\"\u0012QH\u000f\u0005\u0006\u0003\u0002!\t!K\u0001\u0018i\u0016\u001cH/Q4h\u0007\u0006dGNT8u'V\u0004\bo\u001c:uK\u0012D#\u0001\u0011\u001e\t\u000b\u0011\u0003A\u0011A\u0015\u0002CQ,7\u000f^'vYRL\u0007\u000f\\3He>,\b/\u001b8hg:{GoU;qa>\u0014H/\u001a3)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013A\t;fgR\fumZ%oaV$hj\u001c8NCB\u0004\u0018N\\4O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002Gu!)!\n\u0001C\u0001S\u0005qB/Z:u'>\u0014HoV5uQ>3gm]3u\u001d>$8+\u001e9q_J$X\r\u001a\u0015\u0003\u0013jBQ!\u0014\u0001\u0005\u0002%\n\u0011\u0005^3ti:{g.R9vC2\u001cuN\u001c3ji&|gNT8u'V\u0004\bo\u001c:uK\u0012D#\u0001\u0014\u001e\t\u000bA\u0003A\u0011A\u0015\u0002GQ,7\u000f\u001e$jYR,'oQ8oI&$\u0018n\u001c8O_R\u001cuN\u001d:fY\u0006$\u0018n\u001c8J\t\"\u0012qJ\u000f")
public class CorrelateSortToRankRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CorrelateSortToRankRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)programs);
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table t1(\n         |  f0 int,\n         |  f1 bigint,\n         |  f2 varchar(20)\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(createTable);
    }

    @Test
    public void testCorrelateSortToRank() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testNonInnerJoinNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2\n         |  NATURAL LEFT JOIN\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testAggCallNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT mf0, f1\n         |FROM\n         |  (SELECT max(f0) as mf0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.mf0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testMultipleGroupingsNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT f0, f2\n         |FROM\n         |  (SELECT DISTINCT f0, f1 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0 AND f1 = t2.f1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testAggInputNonMappingNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM (SELECT f0 + f1 as f0 from t1)) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testSortWithOffsetNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2 DESC\n         |    OFFSET 2 ROWS\n         |    FETCH NEXT 3 ROWS ONLY\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testNonEqualConditionNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 > t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testFilterConditionNotCorrelationID() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE t2.f0 = f0 + 1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(query);
    }
}

