/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001+\ti\u0011iZ4sK\u001e\fG/\u001a+fgRT!a\u0001\u0003\u0002\u0007\u0005<wM\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011AB:ue\u0016\fWN\u0003\u0002\n\u0015\u0005!\u0001\u000f\\1o\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033)\tQ!\u001e;jYNL!a\u0007\r\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\tU$\u0018\u000e\\\u000b\u0002IA\u0011q#J\u0005\u0003Ma\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2Da\u0001\u000b\u0001!\u0002\u0013!\u0013!B;uS2\u0004\u0003\"\u0002\u0016\u0001\t\u0003Y\u0013A\b;fgR<%o\\;qS:<wJ\u001c(p]\u0016C\u0018n\u001d;f]R4\u0015.\u001a7e)\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#\u0001B+oSRDC!K\u001a:uA\u0011AgN\u0007\u0002k)\u0011aGE\u0001\u0006UVt\u0017\u000e^\u0005\u0003qU\u0012A\u0001V3ti\u0006AQ\r\u001f9fGR,GmI\u0001<!\tat(D\u0001>\u0015\tqD\"A\u0002ba&L!\u0001Q\u001f\u0003'Y\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\t\u000b\t\u0003A\u0011A\u0016\u00029Q,7\u000f^$s_V\u0004\u0018N\\4J]Z\fG.\u001b3TK2,7\r^5p]\"\"\u0011iM\u001d;\u0011\u0015)\u0005\u0001\"\u0001,\u0003q!Xm\u001d;DC:tw\u000e^\"pk:$xJ\\'vYRLg)[3mIND#\u0001R\u001a\t\u000b!\u0003A\u0011A\u0016\u0002)Q,7\u000f^!hO^KG\u000f['j]&\u0014\u0015\r^2iQ\t95\u0007C\u0003L\u0001\u0011\u00051&\u0001\u0010uKN$\u0018iZ4BMR,'/\u00168j_:<\u0016\u000e\u001e5NS:L')\u0019;dQ\"\u0012!j\r\u0005\u0006\u001d\u0002!\taK\u0001\u0019i\u0016\u001cHo\u0012:pkB\u0014\u0015pV5uQ>,HoV5oI><\bFA'4\u0011\u0015\t\u0006\u0001\"\u0001,\u0003q!Xm\u001d;M_\u000e\fGn\u00127pE\u0006d\u0017iZ4BMR,'/\u00168j_:D#\u0001U\u001a\t\u000bQ\u0003A\u0011A\u0016\u0002/Q,7\u000f^!hO^KG\u000f\u001b$jYR,'o\u00117bkN,\u0007FA*4\u0011\u00159\u0006\u0001\"\u0001,\u0003\u0019\"Xm\u001d;BO\u001e<\u0016\u000e\u001e5GS2$XM]\"mCV\u001cXmV5uQ2{7-\u00197HY>\u0014\u0017\r\u001c\u0015\u0003-NBQA\u0017\u0001\u0005\u0002-\nq\u0003^3ti\u0006;wm\u00148ES\u001a4WM]3oiRK\b/Z:)\u0005e\u001b\u0004\"B/\u0001\t\u0003Y\u0013a\u0006;fgR\feoZ(o\t&4g-\u001a:f]R$\u0016\u0010]3tQ\ta6\u0007C\u0003a\u0001\u0011\u00051&\u0001\nuKN$\u0018I^4XSRD'+\u001a;sC\u000e$\bFA04\u0011\u0015\u0019\u0007\u0001\"\u0001,\u0003\u001d!Xm\u001d;Tk6D#AY\u001a\t\u000b\u0019\u0004A\u0011A\u0016\u0002%Q,7\u000f^*v[^KG\u000f\u001b*fiJ\f7\r\u001e\u0015\u0003KNBQ!\u001b\u0001\u0005\u0002-\nq\u0003^3ti6Kgn\u00148ES\u001a4WM]3oiRK\b/Z:)\u0005!\u001c\u0004\"\u00027\u0001\t\u0003Y\u0013A\u0005;fgRl\u0015N\\,ji\"\u0014V\r\u001e:bGRD#a[\u001a\t\u000b=\u0004A\u0011A\u0016\u0002/Q,7\u000f^'bq>sG)\u001b4gKJ,g\u000e\u001e+za\u0016\u001c\bF\u000184\u0011\u0015\u0011\b\u0001\"\u0001,\u0003I!Xm\u001d;NCb<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;)\u0005E\u001c\u0004\"B;\u0001\t\u0003Y\u0013A\u0007;fgR<%o\\;q\u0005f<\u0016\u000e\u001e5D_:\u001cH/\u00198u\u0017\u0016L\bF\u0001;4\u0011\u0015A\b\u0001\"\u0001,\u0003q!Xm\u001d;D_2,XN\\%oi\u0016\u0014h/\u00197WC2LG-\u0019;j_:D#a^\u001a\t\u000bm\u0004A\u0011A\u0016\u0002IQ,7\u000f\u001e$jYR,'/\u001a3D_2,XN\\%oi\u0016\u0014h/\u00197WC2LG-\u0019;j_:D#A_\u001a")
public class AggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("d");

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test(expected=ValidationException.class)
    public void testGroupingOnNonExistentField() {
        this.util().verifyExecPlan("SELECT COUNT(*) FROM MyTable GROUP BY foo");
    }

    @Test(expected=ValidationException.class)
    public void testGroupingInvalidSelection() {
        this.util().verifyExecPlan("SELECT b FROM MyTable GROUP BY a");
    }

    @Test
    public void testCannotCountOnMultiFields() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("We now only support the count of one field");
        this.util().verifyExecPlan("SELECT b, COUNT(a, c) FROM MyTable GROUP BY b");
    }

    @Test
    public void testAggWithMiniBatch() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        this.util().verifyExecPlan("SELECT b, COUNT(DISTINCT a), MAX(b), SUM(c)  FROM MyTable GROUP BY b");
    }

    @Test
    public void testAggAfterUnionWithMiniBatch() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, sum(b), count(distinct c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(query);
    }

    @Test
    public void testGroupByWithoutWindow() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testLocalGlobalAggAfterUnion() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b), COUNT(DISTINCT c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClause() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClauseWithLocalGlobal() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  COUNT(DISTINCT c) FILTER (WHERE b = 1),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggOnDifferentTypes() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n      |SELECT\n      |  a,\n      |  SUM(CAST(1 as INT)),\n      |  SUM(CAST(2 as BIGINT)),\n      |  SUM(CAST(3 as TINYINT)),\n      |  SUM(CAST(4 as SMALLINT)),\n      |  SUM(CAST(5 as FLOAT)),\n      |  SUM(CAST(6 as DECIMAL)),\n      |  SUM(CAST(7 as DOUBLE))\n      |FROM T GROUP BY a\n    ")).stripMargin();
        this.util().verifyRelPlanWithType(sql);
    }

    @Test
    public void testAvgOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT AVG(`byte`),\n        |       AVG(`short`),\n        |       AVG(`int`),\n        |       AVG(`long`),\n        |       AVG(`float`),\n        |       AVG(`double`),\n        |       AVG(`decimal3020`),\n        |       AVG(`decimal105`)\n        |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testAvgWithRetract() {
        this.util().verifyRelPlan("SELECT AVG(a) FROM (SELECT AVG(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSum() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUM(`byte`),\n        |       SUM(`short`),\n        |       SUM(`int`),\n        |       SUM(`long`),\n        |       SUM(`float`),\n        |       SUM(`double`),\n        |       SUM(`decimal3020`),\n        |       SUM(`decimal105`)\n        |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testSumWithRetract() {
        this.util().verifyRelPlan("SELECT SUM(a) FROM (SELECT SUM(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(`byte`),\n        |       MIN(`short`),\n        |       MIN(`int`),\n        |       MIN(`long`),\n        |       MIN(`float`),\n        |       MIN(`double`),\n        |       MIN(`decimal3020`),\n        |       MIN(`decimal105`),\n        |       MIN(`boolean`),\n        |       MIN(`date`),\n        |       MIN(`time`),\n        |       MIN(`timestamp`),\n        |       MIN(`string`)\n        |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMinWithRetract() {
        this.util().verifyRelPlan("SELECT MIN(a) FROM (SELECT MIN(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMaxOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MAX(`byte`),\n        |       MAX(`short`),\n        |       MAX(`int`),\n        |       MAX(`long`),\n        |       MAX(`float`),\n        |       MAX(`double`),\n        |       MAX(`decimal3020`),\n        |       MAX(`decimal105`),\n        |       MAX(`boolean`),\n        |       MAX(`date`),\n        |       MAX(`time`),\n        |       MAX(`timestamp`),\n        |       MAX(`string`)\n        |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMaxWithRetract() {
        this.util().verifyRelPlan("SELECT MAX(a) FROM (SELECT MAX(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupByWithConstantKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, MAX(b), c FROM (SELECT a, 'test' AS c, b FROM T) t GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testColumnIntervalValidation() {
        this.util().verifyExecPlan("SELECT b, SUM(a) FROM MyTable WHERE a > 0.1 and a < 10 GROUP BY b");
    }

    @Test
    public void testFilteredColumnIntervalValidation() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  SUM(uv) FILTER (WHERE c = 'all') AS all_uv\n         |FROM (\n         |  SELECT\n         |    c, COUNT(1) AS uv\n         |  FROM T\n         |  GROUP BY c\n         |) t\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin());
    }

    public AggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$6)}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$7 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("MyTable1", (TypeInformation[])((Object[])new TypeInformation[]{Types.BYTE(), Types.SHORT(), Types.INT(), Types.LONG(), Types.FLOAT(), Types.DOUBLE(), Types.BOOLEAN(), Types.STRING(), Types.LOCAL_DATE(), Types.LOCAL_TIME(), Types.LOCAL_DATE_TIME(), DecimalDataTypeInfo.of((int)30, (int)20), DecimalDataTypeInfo.of((int)10, (int)5)}), (String[])((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "string", "date", "time", "timestamp", "decimal3020", "decimal105"}));
    }
}

