/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestDataTypeTableSource$;
import org.apache.flink.table.planner.utils.TestFileInputFormatTableSource$;
import org.apache.flink.table.planner.utils.TestInputFormatTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001'\t9B*Z4bGf$\u0016M\u00197f'>,(oY3J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011QBQ1uG\"$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0011\"\u0003\u0019\u0011WMZ8sKR\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0003V]&$\bFA\u0010*!\tQS&D\u0001,\u0015\ta\u0003#A\u0003kk:LG/\u0003\u0002/W\t1!)\u001a4pe\u0016DQ\u0001\r\u0001\u0005\u0002\u0005\n\u0011\u0003^3tiNKW\u000e\u001d7f!J|'.Z2uQ\ty#\u0007\u0005\u0002+g%\u0011Ag\u000b\u0002\u0005)\u0016\u001cH\u000fC\u00037\u0001\u0011\u0005\u0011%\u0001\u000euKN$\bK]8kK\u000e$x+\u001b;i_V$\u0018J\u001c9viJ+g\r\u000b\u00026e!)\u0011\b\u0001C\u0001C\u0005\tB/Z:u\u001d\u0016\u001cH/\u001a3Qe>TWm\u0019;)\u0005a\u0012\u0004\"\u0002\u001f\u0001\t\u0003\t\u0013!\b;fgR$\u0016M\u00197f'>,(oY3XSRDg)\u001b7uKJ\f'\r\\3)\u0005m\u0012\u0004\"B \u0001\t\u0003\t\u0013!\n;fgR$\u0016M\u00197f'>,(oY3XSRDg)\u001e8di&|gNR5mi\u0016\u0014\u0018M\u00197fQ\tq$\u0007C\u0003C\u0001\u0011\u0005\u0011%\u0001\u0011uKN$H+\u00192mKN{WO]2f/&$\b\u000eU1si&$\u0018n\u001c8bE2,\u0007FA!3\u0011\u0015)\u0005\u0001\"\u0001\"\u0003I!Xm\u001d;DgZ$\u0016M\u00197f'>,(oY3)\u0005\u0011\u0013\u0004\"\u0002%\u0001\t\u0003\t\u0013A\b;fgRdun\\6va*{\u0017N\\\"tmR+W\u000e]8sC2$\u0016M\u00197fQ\t9%\u0007C\u0003L\u0001\u0011\u0005\u0011%A\u000buKN$\u0018J\u001c9vi\u001a{'/\\1u'>,(oY3)\u0005)\u0013\u0004\"\u0002(\u0001\t\u0003\t\u0013a\u0005;fgRlU\u000f\u001c;j)f\u0004XmU8ve\u000e,\u0007FA'3\u0011\u0015\t\u0006\u0001\"\u0001\"\u00039!Xm\u001d;Nk2$\u0018\u000eU1uQND#\u0001\u0015\u001a\t\u000bQ\u0003A\u0011A\u0011\u0002\u001bQ,7\u000f\u001e+bE2,\u0007*\u001b8uQ\t\u0019&\u0007")
public class LegacyTableSourceITCase
extends BatchTestBase {
    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()})).build();
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("MyTable", (TableSource)new TestLegacyProjectableTableSource(true, tableSchema, (TypeInformation<Row>)new RowTypeInfo((TypeInformation[])Predef$.MODULE$.refArrayOps((Object[])tableSchema.getFieldDataTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(DataType x$1) {
                return TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class))), tableSchema.getFieldNames()), TestData$.MODULE$.smallData3(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$6(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
    }

    @Test
    public void testSimpleProject() {
        this.checkResult("SELECT a, c FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.checkResult("SELECT COUNT(*) FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Sarah", new Integer(100)}), Row.of((Object[])new Object[]{new Integer(1000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Peter", new Integer(10000)}), "Mary"}), Row.of((Object[])new Object[]{new Long(2L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Rob", new Integer(200)}), Row.of((Object[])new Object[]{new Integer(2000), new Boolean(false)})}), Row.of((Object[])new Object[]{"Lucy", new Integer(20000)}), "Bob"}), Row.of((Object[])new Object[]{new Long(3L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Mike", new Integer(300)}), Row.of((Object[])new Object[]{new Integer(3000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Betty", new Integer(30000)}), "Liz"})}));
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(true, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Sarah", BoxesRunTime.boxToInteger((int)10000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)1000)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Rob", BoxesRunTime.boxToInteger((int)20000), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)2000)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Mike", BoxesRunTime.boxToInteger((int)30000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)3000)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFilterable() {
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), TestLegacyFilterableTableSource$.MODULE$.defaultSchema(), "FilterableTable", true, TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$5(), TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$6());
        this.checkResult("SELECT id, name FROM FilterableTable WHERE amount > 4 AND price < 9", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Record_5"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "Record_6"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "Record_7"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "Record_8"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFunctionFilterable() {
        TableEnvironment x$1 = this.tEnv();
        TableSchema x$2 = TestLegacyFilterableTableSource$.MODULE$.defaultSchema();
        String x$3 = "FilterableTable";
        boolean x$4 = true;
        List x$5 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount", "name"}));
        List<Row> x$6 = TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$5();
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(x$1, x$2, x$3, x$4, x$6, (List<String>)x$5);
        this.checkResult("SELECT id, name FROM FilterableTable WHERE amount > 4 AND price < 9 AND upper(name) = 'RECORD_5'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Record_5"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithPartitionable() {
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(this.tEnv(), "PartitionableTable", true);
        this.checkResult("SELECT * FROM PartitionableTable WHERE part2 > 1 and id > 2 AND part1 = 'A'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "John", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "nosharp", "A", BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCsvTableSource() {
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "csvTable");
        this.checkResult("SELECT id, `first`, `last`, score FROM csvTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Mike", "Smith", BoxesRunTime.boxToDouble((double)12.3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Bob", "Taylor", BoxesRunTime.boxToDouble((double)45.6)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Sam", "Miller", BoxesRunTime.boxToDouble((double)7.89)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Peter", "Smith", BoxesRunTime.boxToDouble((double)0.12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Liz", "Williams", BoxesRunTime.boxToDouble((double)34.5)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "Sally", "Miller", BoxesRunTime.boxToDouble((double)6.78)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "Alice", "Smith", BoxesRunTime.boxToDouble((double)90.1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "Kelly", "Williams", BoxesRunTime.boxToDouble((double)2.34)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLookupJoinCsvTemporalTable() {
        TestTableSourceSinks$.MODULE$.createOrdersCsvTemporaryTable(this.tEnv(), "orders");
        TestTableSourceSinks$.MODULE$.createRatesCsvTemporaryTable(this.tEnv(), "rates");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT o.amount, o.currency, r.rate\n        |FROM (SELECT *, PROCTIME() as proc FROM orders) AS o\n        |JOIN rates FOR SYSTEM_TIME AS OF o.proc AS r\n        |ON o.currency = r.currency\n      ")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Euro", BoxesRunTime.boxToInteger((int)119)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "US Dollar", BoxesRunTime.boxToInteger((int)102)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)50), "Yen", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Euro", BoxesRunTime.boxToInteger((int)119)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "US Dollar", BoxesRunTime.boxToInteger((int)102)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInputFormatSource() {
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()})).build();
        TestInputFormatTableSource$.MODULE$.createTemporaryTable(this.tEnv(), tableSchema, TestData$.MODULE$.smallData3(), "MyInputFormatTable");
        this.checkResult("SELECT a, c FROM MyInputFormatTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testMultiTypeSource() {
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c", "d", "e", "f"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.DECIMAL((int)5, (int)2), DataTypes.VARCHAR((int)5), DataTypes.CHAR((int)5), DataTypes.TIMESTAMP((int)9), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)})).build();
        List ints = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), null}));
        List decimals = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{new BigDecimal(5.1), new BigDecimal(6.1), new BigDecimal(7.1), new BigDecimal(8.123), null}));
        List varchars = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "12", "123", "1234", null}));
        List chars = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "12", "123", "1234", null}));
        List datetimes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDateTime[]{LocalDateTime.of(1969, 1, 1, 0, 0, 0, 123456789), LocalDateTime.of(1970, 1, 1, 0, 0, 0, 123456000), LocalDateTime.of(1971, 1, 1, 0, 0, 0, 123000000), LocalDateTime.of(1972, 1, 1, 0, 0, 0, 0), null}));
        MutableList instants = new MutableList();
        datetimes.indices().foreach((Function1)new Serializable(this, datetimes, instants){
            public static final long serialVersionUID = 0L;
            private final List datetimes$1;
            private final MutableList instants$1;

            public final MutableList<Instant> apply(int i) {
                return this.datetimes$1.apply(i) == null ? this.instants$1.$plus$eq(null) : this.instants$1.$plus$eq((Object)((ChronoLocalDateTime)this.datetimes$1.apply(i)).toInstant(ZoneId.of("UTC").getRules().getOffset((LocalDateTime)this.datetimes$1.apply(i))));
            }
            {
                this.datetimes$1 = datetimes$1;
                this.instants$1 = instants$1;
            }
        });
        MutableList data = new MutableList();
        ints.indices().foreach((Function1)new Serializable(this, ints, decimals, varchars, chars, datetimes, instants, data){
            public static final long serialVersionUID = 0L;
            private final List ints$1;
            private final List decimals$1;
            private final List varchars$1;
            private final List chars$1;
            private final List datetimes$1;
            private final MutableList instants$1;
            private final MutableList data$1;

            public final MutableList<Row> apply(int i) {
                return this.data$1.$plus$eq((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ints$1.apply(i), this.decimals$1.apply(i), this.varchars$1.apply(i), this.chars$1.apply(i), this.datetimes$1.apply(i), this.instants$1.apply(i)})));
            }
            {
                this.ints$1 = ints$1;
                this.decimals$1 = decimals$1;
                this.varchars$1 = varchars$1;
                this.chars$1 = chars$1;
                this.datetimes$1 = datetimes$1;
                this.instants$1 = instants$1;
                this.data$1 = data$1;
            }
        });
        TestDataTypeTableSource$.MODULE$.createTemporaryTable(this.tEnv(), tableSchema, "MyInputFormatTable", (Seq<Row>)data.seq());
        this.checkResult("SELECT a, b, c, d, e, f FROM MyInputFormatTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "5.10", "1", "1", "1969-01-01T00:00:00.123456789", "1969-01-01T00:00:00.123456789Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "6.10", "12", "12", "1970-01-01T00:00:00.123456", "1970-01-01T00:00:00.123456Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "7.10", "123", "123", "1971-01-01T00:00:00.123", "1971-01-01T00:00:00.123Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "8.12", "1234", "1234", "1972-01-01T00:00", "1972-01-01T00:00:00Z"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testMultiPaths() {
        File tmpFile1 = BatchAbstractTestBase.TEMPORARY_FOLDER.newFile("tmpFile1.tmp");
        new FileWriter(tmpFile1).append("t1\n").append("t2\n").close();
        File tmpFile2 = BatchAbstractTestBase.TEMPORARY_FOLDER.newFile("tmpFile2.tmp");
        new FileWriter(tmpFile2).append("t3\n").append("t4\n").close();
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"a"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING()}));
        String[] paths = (String[])((Object[])new String[]{tmpFile1.getPath(), tmpFile2.getPath()});
        TestFileInputFormatTableSource$.MODULE$.createTemporaryTable(this.tEnv(), schema, "MyMultiPathTable", paths);
        this.checkResult("select * from MyMultiPathTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t2"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t3"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"t4"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableHint() {
        this.tEnv().getConfig().getConfiguration().setBoolean(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, true);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MyTable1 (\n         |  name STRING,\n         |  a bigint,\n         |  b int,\n         |  c double\n         |) with (\n         |  'connector.type' = 'TestFilterableSource',\n         |  'is-bounded' = 'true'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.tEnv().executeSql(ddl);
        String resultPath = BatchAbstractTestBase.TEMPORARY_FOLDER.newFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MySink (\n         |  `a` BIGINT,\n         |  `b` INT,\n         |  `c` DOUBLE\n         |) WITH (\n         |  'connector' = 'filesystem',\n         |  'format' = 'testcsv',\n         |  'path' = '", "'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultPath})))).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable1\n        |  /*+ OPTIONS('source.num-element-to-skip'='31') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable1\n        |  /*+ OPTIONS('source.num-element-to-skip'='32') */\n        |")).stripMargin());
        stmtSet.execute().await();
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"31,31,31.0", "32,32,32.0", "32,32,32.0"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)result.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

