/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001'\tI\u0002+\u0019:uSRLwN\\1cY\u0016\u001cv.\u001e:dK&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/\u001a\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005)2o\\;sG\u00164U\r^2i!\u0006\u0014H/\u001b;j_:\u001cX#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000f\t{w\u000e\\3b]\"AA\u0005\u0001B\u0001B\u0003%Q$\u0001\ft_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:!\u0011!1\u0003A!b\u0001\n\u0003a\u0012\u0001E;tK\u000e\u000bG/\u00197pO\u001aKG\u000e^3s\u0011!A\u0003A!A!\u0002\u0013i\u0012!E;tK\u000e\u000bG/\u00197pO\u001aKG\u000e^3sA!)!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"2\u0001\f\u00180!\ti\u0003!D\u0001\u0003\u0011\u0015Y\u0012\u00061\u0001\u001e\u0011\u00151\u0013\u00061\u0001\u001e\u0011\u0015\t\u0004\u0001\"\u00113\u0003\u0019\u0011WMZ8sKR\t1\u0007\u0005\u0002\u001fi%\u0011Qg\b\u0002\u0005+:LG\u000f\u000b\u00021oA\u0011\u0001hO\u0007\u0002s)\u0011!\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003ye\u0012aAQ3g_J,\u0007\"\u0002 \u0001\t\u0003\u0011\u0014A\t;fgR\u001c\u0016.\u001c9mKB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0017\u0007\u000b\u0002>\u0001B\u0011\u0001(Q\u0005\u0003\u0005f\u0012A\u0001V3ti\")A\t\u0001C\u0001e\u0005QC/Z:u!\u0006\u0014H/[1m!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016\u0004Vo\u001d5E_^t\u0007FA\"A\u0011\u00159\u0005\u0001\"\u00013\u0003e!Xm\u001d;V]\u000e|gN^3si\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8)\u0005\u0019\u0003\u0005\u0006\u0002\u0001K!F\u0003\"a\u0013(\u000e\u00031S!!T\u001d\u0002\rI,hN\\3s\u0013\tyEJA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003I\u0003\"a\u0015,\u000e\u0003QS!!V\u001d\u0002\u000fI,hN\\3sg&\u0011q\u000b\u0016\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000be\u0013\u0001\u0012\u0001.\u00023A\u000b'\u000f^5uS>t\u0017M\u00197f'>,(oY3J)\u000e\u000b7/\u001a\t\u0003[m3Q!\u0001\u0002\t\u0002q\u001b\"aW/\u0011\u0005yq\u0016BA0 \u0005\u0019\te.\u001f*fM\")!f\u0017C\u0001CR\t!\fC\u0003d7\u0012\u0005A-\u0001\u0006qCJ\fW.\u001a;feN$\u0012!\u001a\t\u0004M.lW\"A4\u000b\u0005!L\u0017\u0001B;uS2T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007yq\u0007/\u0003\u0002p?\t)\u0011I\u001d:bsB\u0011a$]\u0005\u0003e~\u00111!\u00118zQ\u0011\u0011Go\u001f?\u0011\u0005UDhBA*w\u0013\t9H+A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0003sj\u0014!\u0002U1sC6,G/\u001a:t\u0015\t9H+\u0001\u0003oC6,\u0017%A?\u0002_M|WO]2f\r\u0016$8\r\u001b)beRLG/[8ogvZ\b' \u0017!kN,7)\u0019;bY><g)\u001b7uKJl40M?")
public class PartitionableSourceITCase
extends BatchTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;

    @Parameterized.Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)}))}));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddlTemp = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE MyTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'data-id' = '", "',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{myTableDataId})))).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(ddlTemp, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.tEnv().useCatalog("test_catalog");
            this.tEnv().executeSql(String.format(ddlTemp, ""));
            ObjectPath mytablePath = ObjectPath.fromString((String)"test_database.MyTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1)new Serializable(this, catalog, mytablePath){
                public static final long serialVersionUID = 0L;
                private final TestValuesCatalog catalog$1;
                private final ObjectPath mytablePath$1;

                public final void apply(Map<String, String> partition) {
                    CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.mapAsJavaMap(partition));
                    CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap<K, V>(), "");
                    this.catalog$1.createPartition(this.mytablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
                }
                {
                    this.catalog$1 = catalog$1;
                    this.mytablePath$1 = mytablePath$1;
                }
            });
        }
    }

    @Test
    public void testSimplePartitionFieldPredicate1() {
        this.checkResult("SELECT * FROM MyTable WHERE part1 = 'A'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPartialPartitionFieldPredicatePushDown() {
        this.checkResult("SELECT * FROM MyTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnconvertedExpression() {
        this.checkResult("select * from MyTable where trim(part1) = 'A' and part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    public PartitionableSourceITCase(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
    }
}

