/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001'\ty1k\u001c:u\u0019&l\u0017\u000e^%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011I\u0011\u0002\r\t,gm\u001c:f)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSRD#aH\u0015\u0011\u0005)jS\"A\u0016\u000b\u00051\u0002\u0012!\u00026v]&$\u0018B\u0001\u0018,\u0005\u0019\u0011UMZ8sK\")\u0001\u0007\u0001C\u0001C\u0005iB/Z:u\u001fJ$WM\u001d\"z/&$\bn\u00144gg\u0016$\u0018I\u001c3GKR\u001c\u0007\u000e\u000b\u00020eA\u0011!fM\u0005\u0003i-\u0012A\u0001V3ti\")\u0001\u0007\u0001C\u0005mQ\u0011!e\u000e\u0005\u0006qU\u0002\r!O\u0001\u0006_J$WM\u001d\t\u0003GiJ!a\u000f\u0013\u0003\u000f\t{w\u000e\\3b]\")Q\b\u0001C\u0001C\u0005\u0001B/Z:u\u001fJ$WM\u001d\"z\u0019&l\u0017\u000e\u001e\u0015\u0003yIBQ!\u0010\u0001\u0005\n\u0001#2AI!D\u0011\u0015\u0011u\b1\u0001:\u0003\u0019y'\u000fZ3sc!)Ai\u0010a\u0001s\u00051qN\u001d3feJBQA\u0012\u0001\u0005\u0002\u0005\n\u0011\u0004^3ti>\u0013H-\u001a:Cs2+7o\u001d+iC:|eMZ:fi\"\u0012QI\r\u0005\u0006\u0013\u0002!\t!I\u0001\u001ci\u0016\u001cHo\u0014:eKJ\u0014\u0015\u0010T5nSR\u0014U\r[5oI\u001aKW\r\u001c3)\u0005!\u0013\u0004\"\u0002'\u0001\t\u0003\t\u0013\u0001\u0006;fgR|%\u000fZ3s\u0005\u0016D\u0017N\u001c3GS\u0016dG\r\u000b\u0002Le!)q\n\u0001C\u0001C\u0005IB/Z:u\u001fJ$WM\u001d\"z%\u0016\u0004X-\u0019;fI\u001aKW\r\u001c3tQ\tq%\u0007")
public class SortLimitITCase
extends BatchTestBase {
    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        this.registerCollection("Table3", (Iterable<Row>)TestData$.MODULE$.data3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
    }

    @Test
    public void testOrderByWithOffsetAndFetch() {
        this.testOrderByWithOffsetAndFetch(true);
        this.testOrderByWithOffsetAndFetch(false);
    }

    private void testOrderByWithOffsetAndFetch(boolean order) {
        String sqlOrder = order ? "ASC" : "DESC";
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1)new Serializable(this, order){
            public static final long serialVersionUID = 0L;
            private final boolean order$1;

            public final int apply(Row x) {
                return this.order$1 ? BoxesRunTime.unboxToInt((Object)x.getField(0)) : -BoxesRunTime.unboxToInt((Object)x.getField(0));
            }
            {
                this.order$1 = order$1;
            }
        }, (Ordering)Ordering.Int$.MODULE$)).slice(2, 7);
        this.checkResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM Table3 ORDER BY a ", " OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlOrder})), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLimit() {
        this.testOrderByLimit(true, false);
        this.testOrderByLimit(false, false);
        this.testOrderByLimit(true, true);
        this.testOrderByLimit(false, true);
    }

    private void testOrderByLimit(boolean order1, boolean order2) {
        String sqlOrder1 = order1 ? "ASC" : "DESC";
        String sqlOrder2 = order2 ? "ASC" : "DESC";
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1)new Serializable(this, order1, order2){
            public static final long serialVersionUID = 0L;
            private final boolean order1$1;
            private final boolean order2$1;

            public final Tuple2<Object, Object> apply(Row x) {
                return new Tuple2.mcJI.sp(this.order2$1 ? BoxesRunTime.unboxToLong((Object)x.getField(1)) : -BoxesRunTime.unboxToLong((Object)x.getField(1)), this.order1$1 ? BoxesRunTime.unboxToInt((Object)x.getField(0)) : -BoxesRunTime.unboxToInt((Object)x.getField(0)));
            }
            {
                this.order1$1 = order1$1;
                this.order2$1 = order2$1;
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$))).slice(0, 5);
        this.checkResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM Table3 ORDER BY b ", ", a ", " LIMIT 5"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlOrder2, sqlOrder1})), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLessThanOffset() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Row x) {
                return BoxesRunTime.unboxToInt((Object)x.getField(0));
            }
        }, (Ordering)Ordering.Int$.MODULE$)).slice(2, TestData$.MODULE$.data3().size());
        this.checkResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM Table3 ORDER BY a ASC OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY"})).s((Seq)Nil$.MODULE$), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLimitBehindField() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x) {
                return (String)x.getField(2);
            }
        }, (Ordering)Ordering.String$.MODULE$)).slice(0, 5);
        this.checkResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM Table3 ORDER BY c LIMIT 5"})).s((Seq)Nil$.MODULE$), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderBehindField() {
        this.conf().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 1);
        Seq expected = (Seq)TestData$.MODULE$.data3().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x) {
                return (String)x.getField(2);
            }
        }, (Ordering)Ordering.String$.MODULE$);
        this.checkResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM Table3 ORDER BY c"})).s((Seq)Nil$.MODULE$), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByRepeatedFields() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Row x) {
                return BoxesRunTime.unboxToInt((Object)x.getField(0));
            }
        }, (Ordering)Ordering.Int$.MODULE$)).slice(0, 5);
        this.checkResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM Table3 ORDER BY a, a, a LIMIT 5"})).s((Seq)Nil$.MODULE$), (Seq<Row>)expected, true);
    }
}

