/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.utils.Func13;
import org.apache.flink.table.planner.expressions.utils.RichFunc1;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.expressions.utils.RichFunc3;
import org.apache.flink.table.planner.expressions.utils.SplitUDF;
import org.apache.flink.table.planner.runtime.batch.table.CalcITCase$;
import org.apache.flink.table.planner.runtime.batch.table.HashCode$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple8;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001I\u0011!bQ1mG&#6)Y:f\u0015\t\u0019A!A\u0003uC\ndWM\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005\rY!B\u0001\u0007\u000e\u0003\u00151G.\u001b8l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\tQ!\u001e;jYNL!\u0001G\u000b\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003 \u0001\u0011\u0005\u0001%\u0001\bvg\u0016\u001cH*Z4bGf\u0014vn^:\u0016\u0003\u0005\u0002\"A\t\u0013\u000e\u0003\rR!A\u0006\u0006\n\u0005\u0015\u001a#!\u0005'fO\u0006\u001c\u0017PU8x%\u0016\u001cx.\u001e:dK\"\u0012ad\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U=\tQA[;oSRL!\u0001L\u0015\u0003\tI+H.\u001a\u0005\u0006]\u0001!\teL\u0001\u0007E\u00164wN]3\u0015\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012A!\u00168ji\"\u0012Qf\u000e\t\u0003QaJ!!O\u0015\u0003\r\t+gm\u001c:f\u0011\u0015Y\u0004\u0001\"\u00010\u0003M!Xm\u001d;TS6\u0004H.Z*fY\u0016\u001cG/\u00117mQ\tQT\b\u0005\u0002)}%\u0011q(\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0003B\u0001\u0011\u0005q&A\ruKN$8+[7qY\u0016\u001cV\r\\3di\u0006cGnV5uQ\u0006\u001b\bF\u0001!>\u0011\u0015!\u0005\u0001\"\u00010\u0003i!Xm\u001d;TS6\u0004H.Z*fY\u0016\u001cGoV5uQ:\u000bW.\u001b8hQ\t\u0019U\bC\u0003H\u0001\u0011\u0005q&A\ruKN$8+[7qY\u0016\u001cV\r\\3diJ+g.Y7f\u00032d\u0007F\u0001$>\u0011\u0015Q\u0005\u0001\"\u00010\u00039!Xm\u001d;TK2,7\r^*uCJD#!S\u001f\t\u000b5\u0003A\u0011A\u0018\u0002-Q,7\u000f^!mYJ+'.Z2uS:<g)\u001b7uKJD#\u0001T\u001f\t\u000bA\u0003A\u0011A\u0018\u0002)Q,7\u000f^!mYB\u000b7o]5oO\u001aKG\u000e^3sQ\tyU\bC\u0003T\u0001\u0011\u0005q&\u0001\u000fuKN$h)\u001b7uKJ|en\u0015;sS:<G+\u001e9mK\u001aKW\r\u001c3)\u0005Ik\u0004\"\u0002,\u0001\t\u0003y\u0013!\b;fgR4\u0015\u000e\u001c;fe>s\u0017J\u001c;fO\u0016\u0014H+\u001e9mK\u001aKW\r\u001c3)\u0005Uk\u0004\"B-\u0001\t\u0003y\u0013!\u0004;fgRtu\u000e^#rk\u0006d7\u000f\u000b\u0002Y{!)A\f\u0001C\u0001_\u0005AB/Z:u\t&\u001c(.\u001e8di&4X\r\u0015:fI&\u001c\u0017\r^3)\u0005mk\u0004\"B0\u0001\t\u0003y\u0013A\u0006;fgR\u001cuN\\:fGV$\u0018N^3GS2$XM]:)\u0005yk\u0004\"\u00022\u0001\t\u0003y\u0013a\u0005;fgR4\u0015\u000e\u001c;fe\n\u000b7/[2UsB,\u0007FA1>\u0011\u0015)\u0007\u0001\"\u00010\u0003Y!Xm\u001d;GS2$XM](o\u0007V\u001cHo\\7UsB,\u0007F\u00013>\u0011\u0015A\u0007\u0001\"\u00010\u00039!Xm\u001d;TS6\u0004H.Z\"bY\u000eD#aZ\u001f\t\u000b-\u0004A\u0011A\u0018\u0002-Q,7\u000f^\"bY\u000e<\u0016\u000e\u001e5Uo>4\u0015\u000e\u001c;feND#A[\u001f\t\u000b9\u0004A\u0011A\u0018\u0002/Q,7\u000f^\"bY\u000e<\u0016\u000e\u001e5BO\u001e\u0014XmZ1uS>t\u0007FA7>\u0011\u0015\t\b\u0001\"\u00010\u00031!Xm\u001d;DC2\u001c'j\\5oQ\t\u0001X\bC\u0003u\u0001\u0011\u0005q&A\u000buKN$\u0018\t\u001a<b]\u000e,G\rR1uCRK\b/Z:)\u0005Ml\u0004\"B<\u0001\t\u0003y\u0013!\b;fgR,6/\u001a:EK\u001aLg.\u001a3TG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8)\u0005Yl\u0004\"\u0002>\u0001\t\u0003y\u0013a\b;fgRtU/\\3sS\u000e\fU\u000f^8dCN$\u0018J\\!sSRDW.\u001a;jG\"\u0012\u00110\u0010\u0005\u0006{\u0002!\taL\u0001 i\u0016\u001cHOT;nKJL7-Q;u_\u000e\f7\u000f^%o\u0007>l\u0007/\u0019:jg>t\u0007F\u0001?>\u0011\u0019\t\t\u0001\u0001C\u0001_\u0005YA/Z:u\u0007\u0006\u001cH/\u001b8hQ\tyX\b\u0003\u0004\u0002\b\u0001!\taL\u0001\u0013i\u0016\u001cHoQ1ti\u001a\u0013x.\\*ue&tw\rK\u0002\u0002\u0006uBa!!\u0004\u0001\t\u0003y\u0013A\u000b;fgR,6/\u001a:EK\u001aLg.\u001a3TG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8XSRD\u0007+\u0019:b[\u0016$XM\u001d\u0015\u0004\u0003\u0017i\u0004BBA\n\u0001\u0011\u0005q&A\u0019uKN$Xk]3s\t\u00164\u0017N\\3e'\u000e\fG.\u0019:Gk:\u001cG/[8o/&$\b\u000eR5tiJL'-\u001e;fI\u000e\u000b7\r[3)\u0007\u0005EQ\b\u0003\u0004\u0002\u001a\u0001!\taL\u0001'i\u0016\u001cH/T;mi&\u0004H.Z+tKJ$UMZ5oK\u0012\u001c6-\u00197be\u001a+hn\u0019;j_:\u001c\bfAA\f{!1\u0011q\u0004\u0001\u0005\u0002=\nq\u0005^3tiN\u001b\u0017\r\\1s\rVt7\r^5p]\u000e{gn\u001d;sk\u000e$xN],ji\"\u0004\u0016M]1ng\"\u001a\u0011QD\u001f\t\r\u0005\u0015\u0002\u0001\"\u00010\u0003-!Xm\u001d;S_^$\u0016\u0010]3)\u0007\u0005\rR\b\u0003\u0004\u0002,\u0001!\taL\u0001\u000ei\u0016\u001cH/\u0011:sCf$\u0016\u0010]3)\u0007\u0005%R\b\u0003\u0004\u00022\u0001!\taL\u0001\fi\u0016\u001cH/T1q)f\u0004X\rK\u0002\u00020uBa!a\u000e\u0001\t\u0003y\u0013\u0001\u0006;fgR4\u0016\r\\;f\u0007>t7\u000f\u001e:vGR|'\u000fK\u0002\u00026uBa!!\u0010\u0001\t\u0003y\u0013!\b;fgR\u001cV\r\\3diN#\u0018M\u001d$s_6tUm\u001d;fIR\u000b'\r\\3)\u0007\u0005mR\b\u0003\u0004\u0002D\u0001!\taL\u0001\"i\u0016\u001cHOR;oGRLwN\\,ji\",f.[2pI\u0016\u0004\u0016M]1nKR,'o\u001d\u0015\u0004\u0003\u0003j\u0004BBA%\u0001\u0011\u0005q&A\u000euKN$8\u000b\u001d7ji\u001aKW\r\u001c3t\u001f:\u001cUo\u001d;p[RK\b/\u001a\u0015\u0004\u0003\u000fj\u0004")
public class CalcITCase
extends BatchTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("_1");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("_2");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("_3");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("*");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("f0");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("myString");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("cnt");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("e");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("f");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("_4");
    private static Symbol symbol$15 = Symbol$.MODULE$.apply("_5");
    private static Symbol symbol$16 = Symbol$.MODULE$.apply("_6");
    private static Symbol symbol$17 = Symbol$.MODULE$.apply("_7");
    private static Symbol symbol$18 = Symbol$.MODULE$.apply("_8");
    private static Symbol symbol$19 = Symbol$.MODULE$.apply("a0");
    private static Symbol symbol$20 = Symbol$.MODULE$.apply("a1");
    private static Symbol symbol$21 = Symbol$.MODULE$.apply("b0");
    private static Symbol symbol$22 = Symbol$.MODULE$.apply("b1");
    private static Symbol symbol$23 = Symbol$.MODULE$.apply("c0");
    private static Symbol symbol$24 = Symbol$.MODULE$.apply("c1");
    private static Symbol symbol$25 = Symbol$.MODULE$.apply("myInt");
    private static Symbol symbol$26 = Symbol$.MODULE$.apply("myLong");

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
    }

    @Test
    public void testSimpleSelectAll() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)});
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleSelectAllWithAs() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)});
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleSelectWithNaming() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).as(symbol$4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).as(symbol$5, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).as(symbol$6, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5)});
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleSelectRenameAll() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).as(symbol$4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).as(symbol$5, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).as(symbol$6, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5)});
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSelectStar() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$7)});
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAllRejectingFilter() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.boolean2Literal(false));
        String expected = "\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAllPassingFilter() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.boolean2Literal(true));
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnStringTupleField() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%world%")));
        String expected = "3,2,Hello world\n4,3,Hello world, how are you?\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnIntegerTupleField() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0)));
        String expected = "2,2,Hello\n4,3,Hello world, how are you?\n6,3,Luke Skywalker\n8,4,Comment#2\n10,4,Comment#4\n12,5,Comment#6\n14,5,Comment#8\n16,6,Comment#10\n18,6,Comment#12\n20,6,Comment#14\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNotEquals() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0)));
        String expected = "1,1,Hi\n3,2,Hello world\n5,3,I am fine.\n7,4,Comment#1\n9,4,Comment#3\n11,5,Comment#5\n13,5,Comment#7\n15,5,Comment#9\n17,6,Comment#11\n19,6,Comment#13\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testDisjunctivePredicate() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$bar$bar(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(20))));
        String expected = "1,1,Hi\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testConsecutiveFilters() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table filterDs = ds.filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0))).filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).$percent(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0)));
        String expected = "3,2,Hello world\n7,4,Comment#1\n9,4,Comment#3\n17,6,Comment#11\n19,6,Comment#13\n21,6,Comment#15\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterBasicType() {
        Table ds = CollectionBatchExecTable$.MODULE$.getStringDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getStringDataSet$default$2());
        Table filterDs = ds.filter((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$8).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("H%")));
        String expected = "Hi\nHello\nHello world\nHello world, how are you?\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnCustomType() {
        Table filterDs = CollectionBatchExecTable$.MODULE$.getCustomTypeDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getCustomTypeDataSet$default$2()).filter((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$9).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%a%")));
        String expected = "3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n";
        Seq<Row> results = this.executeQuery(filterDs);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleCalc() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(7))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)});
        String expected = "1,Hi\n2,Hello\n3,Hello world\n4,Hello world, how are you?\n5,I am fine.\n6,Luke Skywalker\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCalcWithTwoFilters() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}).where(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(7))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(3)))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(4))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1)});
        String expected = "4\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCalcWithAggregation() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2()).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(15))).groupBy(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}).select(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).min(), org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).count()).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$10).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(3)));
        String expected = "7,4\n11,4\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCalcJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5)}).join(ds2).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$11))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$11), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$13)}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12)}).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$12).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(2)));
        String expected = "2,2\n3,2\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAdvancedDataTypes() {
        java.math.BigDecimal bd1 = package$.MODULE$.BigDecimal().apply("78.454654654654654").bigDecimal();
        java.math.BigDecimal bd2 = package$.MODULE$.BigDecimal().apply("4E+16").bigDecimal();
        Table t = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)bd1, (Object)bd2, (Object)Date.valueOf("1984-07-12"), (Object)Time.valueOf("14:34:24"), (Object)Timestamp.valueOf("1984-07-12 14:34:24"))})), "_1, _2, _3, _4, _5", ClassTag$.MODULE$.apply(Tuple5.class), new CaseClassTypeInfo<Tuple5<java.math.BigDecimal, java.math.BigDecimal, Date, Time, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<java.math.BigDecimal, java.math.BigDecimal, Date, Time, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$14 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<java.math.BigDecimal, java.math.BigDecimal, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple5<java.math.BigDecimal, java.math.BigDecimal, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple5<java.math.BigDecimal, java.math.BigDecimal, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple5((Object)((java.math.BigDecimal)fields[0]), (Object)((java.math.BigDecimal)fields[1]), (Object)((Date)fields[2]), (Object)((Time)fields[3]), (Object)((Timestamp)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$14), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$15), org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("11.2")), org.apache.flink.table.api.package$.MODULE$.javaDec2Literal(package$.MODULE$.BigDecimal().apply("11.2").bigDecimal()), org.apache.flink.table.api.package$.MODULE$.sqlDate2Literal(Date.valueOf("1984-07-12")), org.apache.flink.table.api.package$.MODULE$.sqlTime2Literal(Time.valueOf("14:34:24")), org.apache.flink.table.api.package$.MODULE$.sqlTimestamp2Literal(Timestamp.valueOf("1984-07-12 14:34:24"))});
        java.math.BigDecimal bd1x = bd1.setScale(DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT.getScale());
        java.math.BigDecimal bd2x = bd2.setScale(DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT.getScale());
        String expected = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ",1984-07-12,14:34:24,1984-07-12T14:34:24,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bd1x, bd2x}))).append((Object)"11.2,11.2,1984-07-12,14:34:24,1984-07-12T14:34:24").toString();
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedScalarFunction() {
        this.registerFunction("hashCode", HashCode$.MODULE$);
        Table table = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}), ClassTag$.MODULE$.apply(String.class), BasicTypeInfo.getInfoFor(String.class));
        Table result = table.select("f0.hashCode()");
        Seq<Row> results = this.executeQuery(result);
        String expected = "97\n98\n99";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNumericAutocastInArithmetic() {
        Table table = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple8[]{new Tuple8((Object)BoxesRunTime.boxToByte((byte)((byte)1)), (Object)BoxesRunTime.boxToShort((short)((short)1)), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1001.1))}), ClassTag$.MODULE$.apply(Tuple8.class), new CaseClassTypeInfo<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$15 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, Object, Object, Object, Object, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[6])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).$plus(org.apache.flink.table.api.package$.MODULE$.long2Literal(1L)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).$plus(org.apache.flink.table.api.package$.MODULE$.float2Literal(1.0f)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).$plus(org.apache.flink.table.api.package$.MODULE$.double2Literal(1.0)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).$plus(org.apache.flink.table.api.package$.MODULE$.double2Literal(1.0)), org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$18).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1))});
        Seq<Row> results = this.executeQuery(table);
        String expected = "2,2,2,2.0,2.0,2.0,2.0,1002.1";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNumericAutocastInComparison() {
        Table table = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToByte((byte)((byte)1)), (Object)BoxesRunTime.boxToShort((short)((short)1)), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple6((Object)BoxesRunTime.boxToByte((byte)((byte)2)), (Object)BoxesRunTime.boxToShort((short)((short)2)), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0))})), "a, b, c, d, e, f", ClassTag$.MODULE$.apply(Tuple6.class), new CaseClassTypeInfo<Tuple6<Object, Object, Object, Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple6<Object, Object, Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$16 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple6<Object, Object, Object, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple6<Object, Object, Object, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple6<Object, Object, Object, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple6((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).filter(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).$greater(org.apache.flink.table.api.package$.MODULE$.long2Literal(1L)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$12).$greater(org.apache.flink.table.api.package$.MODULE$.float2Literal(1.0f)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$11).$greater(org.apache.flink.table.api.package$.MODULE$.double2Literal(1.0)))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$13).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))));
        Seq<Row> results = this.executeQuery(table);
        String expected = "2,2,2,2,2.0,2.0";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCasting() {
        Table table = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToBoolean((boolean)true))}), ClassTag$.MODULE$.apply(Tuple4.class), new CaseClassTypeInfo<Tuple4<Object, Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$17 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.STRING()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).cast(DataTypes.STRING()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.STRING()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).cast(DataTypes.STRING()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.BOOLEAN()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).cast(DataTypes.BOOLEAN()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.BOOLEAN()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.DOUBLE()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).cast(DataTypes.INT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.SMALLINT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).cast(DataTypes.DOUBLE()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.INT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).cast(DataTypes.DOUBLE()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.BIGINT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).cast(DataTypes.BOOLEAN())});
        Seq<Row> results = this.executeQuery(table);
        String expected = "1,0.0,1,true,true,false,true,1.0,0,1,1.0,1,0.0,1,true\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCastFromString() {
        Table table = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"1", (Object)"true", (Object)"2.0")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<String, String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$18 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.TINYINT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.SMALLINT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.INT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.BIGINT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.DOUBLE()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.FLOAT()), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).cast(DataTypes.BOOLEAN())});
        Seq<Row> results = this.executeQuery(table);
        String expected = "1,1,1,1,2.0,2.0,true\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedScalarFunctionWithParameter() {
        this.registerFunction("RichFunc2", new RichFunc2());
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"ABC")}))));
        Table ds = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        this.tEnv().registerTable("t1", ds);
        String sqlQuery = "SELECT c FROM t1 where RichFunc2(c)='ABC#Hello'";
        Table result = this.tEnv().sqlQuery(sqlQuery);
        String expected = "Hello";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedScalarFunctionWithDistributedCache() {
        String words = "Hello\nWord";
        String filePath = UserDefinedFunctionTestUtils$.MODULE$.writeCacheFile("test_words", words);
        this.env().registerCachedFile(filePath, "words");
        this.registerFunction("RichFunc3", new RichFunc3());
        Table ds = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        this.tEnv().registerTable("t1", ds);
        String sqlQuery = "SELECT c FROM t1 where RichFunc3(c)=true";
        Table result = this.tEnv().sqlQuery(sqlQuery);
        String expected = "Hello";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMultipleUserDefinedScalarFunctions() {
        this.registerFunction("RichFunc1", new RichFunc1());
        this.registerFunction("RichFunc2", new RichFunc2());
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"Abc")}))));
        Table ds = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        this.tEnv().registerTable("t1", ds);
        String sqlQuery = "SELECT c FROM t1 where RichFunc2(c)='Abc#Hello' or RichFunc1(a)=3 and b=2";
        Table result = this.tEnv().sqlQuery(sqlQuery);
        String expected = "Hello\nHello world";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testScalarFunctionConstructorWithParams() {
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp")}));
        Table in = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$19 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        Func13 func0 = new Func13("default");
        Func13 func1 = new Func13("Sunny");
        Func13 func2 = new Func13("kevin2");
        Table result = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)})), org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)})), org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)}))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "default-Anna#44,Sunny-Anna#44,kevin2-Anna#44\ndefault-Jack#22,Sunny-Jack#22,kevin2-Jack#22\ndefault-John#19,Sunny-John#19,kevin2-John#19\ndefault-nosharp,Sunny-nosharp,kevin2-nosharp";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRowType() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"));
        Table in = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$20 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        Table result1 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("Hi"), org.apache.flink.table.api.package$.MODULE$.boolean2Literal(true)}))});
        this.executeQuery(result1).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Row record) {
                Row row2 = (Row)record.getField(0);
                Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)row2.getField(0));
                Assert.assertEquals((Object)"Hi", (Object)row2.getField(1));
                Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)row2.getField(2));
            }
        });
        Table result2 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5)}))});
        ((IterableLike)this.executeQuery(result2).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, data){
            public static final long serialVersionUID = 0L;
            private final MutableList data$1;

            public final void apply(Tuple2<Row, Object> x0$1) {
                Tuple2<Row, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Row record = (Row)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    Row row2 = (Row)record.getField(0);
                    Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)row2.getField(0));
                    Assert.assertEquals((Object)((Tuple3)this.data$1.apply(idx))._1(), (Object)row2.getField(1));
                    Assert.assertEquals((Object)((Tuple3)this.data$1.apply(idx))._2(), (Object)row2.getField(2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.data$1 = data$1;
            }
        });
        DecimalData d = DecimalDataUtils.castFrom((double)2.0002, (int)5, (int)4);
        Table result3 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply(2.0002)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)}))});
        ((IterableLike)this.executeQuery(result3).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, data, d){
            public static final long serialVersionUID = 0L;
            private final MutableList data$1;
            private final DecimalData d$1;

            public final void apply(Tuple2<Row, Object> x0$2) {
                Tuple2<Row, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Row record = (Row)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    Row row2 = (Row)record.getField(0);
                    Assert.assertEquals((Object)this.d$1.toBigDecimal(), (Object)row2.getField(0));
                    Assert.assertEquals((Object)((Tuple3)this.data$1.apply(idx))._1(), (Object)row2.getField(1));
                    Assert.assertEquals((Object)((Tuple3)this.data$1.apply(idx))._3(), (Object)row2.getField(2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.data$1 = data$1;
                this.d$1 = d$1;
            }
        });
    }

    @Test
    public void testArrayType() {
        Table in = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2());
        Table t1 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.string2Literal("Hi"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("Hello"), org.apache.flink.table.api.package$.MODULE$.string2Literal("How are you")}))});
        Seq<Row> result1 = this.executeQuery(t1);
        String expected1 = "[Hi, Hello, How are you]\n[Hi, Hello, How are you]\n[Hi, Hello, How are you]\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result1).asJava()), (String)expected1);
        Table t2 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(30), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.int2Literal(10)}))});
        Seq<Row> result2 = this.executeQuery(t2);
        String expected2 = "[30, 1, 10]\n[30, 2, 10]\n[30, 3, 10]\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result2).asJava()), (String)expected2);
        Table t3 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.string2Literal("Test"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}))});
        Seq<Row> result3 = this.executeQuery(t3);
        String expected3 = "[Test, Hi]\n[Test, Hello]\n[Test, Hello world]\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result3).asJava()), (String)expected3);
    }

    @Test
    public void testMapType() {
        Table in = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2());
        Table t1 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), org.apache.flink.table.api.package$.MODULE$.string2Literal("Hello"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.int2Literal(2), org.apache.flink.table.api.package$.MODULE$.string2Literal("Hi")}))});
        Seq<Row> result1 = this.executeQuery(t1);
        String expected1 = "{1=Hello, 2=Hi}\n{1=Hello, 2=Hi}\n{1=Hello, 2=Hi}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result1).asJava()), (String)expected1);
        Table t2 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.int2Literal(30), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.long2Literal(10L), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1)}))});
        Seq<Row> result2 = this.executeQuery(t2);
        String expected2 = "{1=30, 10=1}\n{2=30, 10=2}\n{2=30, 10=3}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result2).asJava()), (String)expected2);
        Table t3 = in.select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))});
        Seq<Row> result3 = this.executeQuery(t3);
        String expected3 = "{1=Hi}\n{2=Hello}\n{3=Hello world}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result3).asJava()), (String)expected3);
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"AAA", (Object)package$.MODULE$.BigDecimal().valueOf(123.45), (Object)"BBB", (Object)package$.MODULE$.BigDecimal().valueOf(234.56)));
        data.$plus$eq((Object)new Tuple4((Object)"CCC", (Object)package$.MODULE$.BigDecimal().valueOf(345.67), (Object)"DDD", (Object)package$.MODULE$.BigDecimal().valueOf(456.78)));
        data.$plus$eq((Object)new Tuple4((Object)"EEE", (Object)package$.MODULE$.BigDecimal().valueOf(567.89), (Object)"FFF", (Object)package$.MODULE$.BigDecimal().valueOf(678.99)));
        Table t4 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c, d", ClassTag$.MODULE$.apply(Tuple4.class), new CaseClassTypeInfo<Tuple4<String, BigDecimal, String, BigDecimal>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, BigDecimal, String, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$21 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<String, BigDecimal, String, BigDecimal>> unused = new ScalaCaseClassSerializer<Tuple4<String, BigDecimal, String, BigDecimal>>(this, fieldSerializers){

                    public Tuple4<String, BigDecimal, String, BigDecimal> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)((BigDecimal)fields[1]), (Object)((String)fields[2]), (Object)((BigDecimal)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12)}))});
        Seq<Row> result4 = this.executeQuery(t4);
        String expected4 = "{AAA=123.45, BBB=234.56}\n{CCC=345.67, DDD=456.78}\n{EEE=567.89, FFF=678.99}\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result4).asJava()), (String)expected4);
    }

    @Test
    public void testValueConstructor() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)"foo", (Object)BoxesRunTime.boxToInteger((int)12), (Object)DateTimeTestUtil$.MODULE$.localDateTime("1984-07-12 14:34:24")));
        Table t = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<String, Object, LocalDateTime>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, LocalDateTime>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$22 $outer;
                    private final ExecutionConfig executionConfig$9;
                    private final TypeSerializer[] fieldSerializers$9;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$9[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$9);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$9 = executionConfig$9;
                        this.fieldSerializers$9 = fieldSerializers$9;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, LocalDateTime>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, LocalDateTime>>(this, fieldSerializers){

                    public Tuple3<String, Object, LocalDateTime> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((LocalDateTime)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.row(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)})), org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(12), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5)})), org.apache.flink.table.api.package$.MODULE$.map(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))});
        Seq<Row> result = this.executeQuery(t);
        Row nestedRow = (Row)((Row)result.head()).getField(0);
        Assert.assertEquals((Object)((Tuple3)data.head())._1(), (Object)nestedRow.getField(0));
        Assert.assertEquals((Object)((Tuple3)data.head())._2(), (Object)nestedRow.getField(1));
        Assert.assertEquals((Object)((Tuple3)data.head())._3(), (Object)nestedRow.getField(2));
        Integer[] arr = (Integer[])((Row)result.head()).getField(1);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)12), (Object)arr[0]);
        Assert.assertEquals((Object)((Tuple3)data.head())._2(), (Object)arr[1]);
        HashMap hashMap = (HashMap)((Row)result.head()).getField(2);
        Assert.assertEquals((Object)((Tuple3)data.head())._3(), hashMap.get((String)((Tuple3)data.head())._1()));
    }

    @Test
    public void testSelectStarFromNestedTable() {
        Table table = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)"0"), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)"1"), new Tuple2((Object)new Tuple2.mcII.sp(2, 2), (Object)"2")})), ClassTag$.MODULE$.apply(Tuple2.class), new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$23 $outer;
                    private final ExecutionConfig executionConfig$10;
                    private final TypeSerializer[] fieldSerializers$12;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$12[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$10);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$10 = executionConfig$10;
                        this.fieldSerializers$12 = fieldSerializers$12;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$7)});
        Seq<Row> results = this.executeQuery(table);
        ((IterableLike)results.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Row, Object> x0$3) {
                Tuple2<Row, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Row row2 = (Row)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 nestedRow = (Tuple2)row2.getField(0);
                    Assert.assertEquals((long)i, (long)nestedRow._1$mcI$sp());
                    Assert.assertEquals((long)i, (long)nestedRow._2$mcI$sp());
                    Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (Object)row2.getField(1));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    @Test
    public void testFunctionWithUnicodeParameters() {
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"a\u0001b", (Object)"c\"d", (Object)"e\\\"\u0004f"), new Tuple3((Object)"x\u0001y", (Object)"y\"z", (Object)"z\\\"\u0004z")}));
        SplitUDF splitUDF0 = new SplitUDF(true);
        SplitUDF splitUDF1 = new SplitUDF(false);
        Table ds = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<String, String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$26 $outer;
                    private final ExecutionConfig executionConfig$13;
                    private final TypeSerializer[] fieldSerializers$13;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$13[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$13);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$13 = executionConfig$13;
                        this.fieldSerializers$13 = fieldSerializers$13;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.string2Literal("\u0001"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as(symbol$19, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.string2Literal("\u0001"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as(symbol$20, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5), org.apache.flink.table.api.package$.MODULE$.string2Literal("\""), org.apache.flink.table.api.package$.MODULE$.int2Literal(1)}))).as(symbol$21, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5), org.apache.flink.table.api.package$.MODULE$.string2Literal("\""), org.apache.flink.table.api.package$.MODULE$.int2Literal(1)}))).as(symbol$22, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6), org.apache.flink.table.api.package$.MODULE$.string2Literal("\\\"\u0004"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as(symbol$23, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.ScalarFunctionCall((ScalarFunction)splitUDF1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6), org.apache.flink.table.api.package$.MODULE$.string2Literal("\\\"\u0004"), org.apache.flink.table.api.package$.MODULE$.int2Literal(0)}))).as(symbol$24, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        Seq<Row> results = this.executeQuery(ds);
        String expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,a,d,d,e,e", "x,x,z,z,z,z"})).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSplitFieldsOnCustomType() {
        this.tEnv().getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        Table ds = CollectionBatchExecTable$.MODULE$.getCustomTypeDataSet(this.tEnv(), "myInt, myLong, myString").filter(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$9).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%a%"))).$amp$amp(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$9).charLength()).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(12)))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$25), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$26), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$9).charLength()});
        String expected = "3,3,25\n3,5,14\n";
        Seq<Row> results = this.executeQuery(ds);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

