/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowAggregateUseDaylightTimeHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001E\u0011\u0011fV5oI><\u0018iZ4sK\u001e\fG/Z+tK\u0012\u000b\u0017\u0010\\5hQR$\u0016.\\3ICJtWm]:UKN$(BA\u0002\u0005\u0003\u001dA\u0017M\u001d8fgNT!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!a\u0004%be:,7o\u001d+fgR\u0014\u0015m]3\t\u0011]\u0001!\u0011!Q\u0001\na\tqAY1dW\u0016tG\r\u0005\u0002\u001a_9\u0011!\u0004\f\b\u00037)r!\u0001H\u0015\u000f\u0005uAcB\u0001\u0010(\u001d\tybE\u0004\u0002!K9\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005E\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0006B\u0001\u0006kRLGn]\u0005\u0003[9\n!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016T!a\u000b\u0003\n\u0005A\n$\u0001E*uCR,')Y2lK:$Wj\u001c3f\u0015\tic\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003!!\u0018.\\3[_:,\u0007CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0011)H/\u001b7\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\t)&lWMW8oK\")Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"2a\u0010!B!\t\u0019\u0002\u0001C\u0003\u0018y\u0001\u0007\u0001\u0004C\u00034y\u0001\u0007A\u0007C\u0003D\u0001\u0011\u0005C)\u0001\u0004cK\u001a|'/\u001a\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n!QK\\5uQ\t\u0011E\n\u0005\u0002N!6\taJ\u0003\u0002P\u001d\u0005)!.\u001e8ji&\u0011\u0011K\u0014\u0002\u0007\u0005\u00164wN]3\t\u000bM\u0003A\u0011\u0001#\u00021Q,7\u000f\u001e)s_\u000e,7o]5oORKW.Z,j]\u0012|w\u000f\u000b\u0002S+B\u0011QJV\u0005\u0003/:\u0013A\u0001V3ti\")\u0011\f\u0001C\u00055\u0006Q\u0011N\\4fgR$\u0015\r^1\u0015\u0005\u0015[\u0006\"\u0002/Y\u0001\u0004i\u0016a\u0003;fgRD\u0015M\u001d8fgN\u0004RA\u00182eI\u0012l\u0011a\u0018\u0006\u0003o\u0001T!!\u0019\u0006\u0002\u0013M$(/Z1nS:<\u0017BA2`\u0005\u0019ZU-_3e\u001f:,\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peR+7\u000f\u001e%be:,7o\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O\"\tA\u0001Z1uC&\u0011\u0011N\u001a\u0002\b%><H)\u0019;b\u0011\u0015Y\u0007\u0001\"\u0003m\u0003\t!8\u000f\u0006\u0002naB\u0011QM\\\u0005\u0003_\u001a\u0014Q\u0002V5nKN$\u0018-\u001c9ECR\f\u0007\"B9k\u0001\u0004\u0011\u0018A\u00013u!\t\u0019hO\u0004\u0002Gi&\u0011QoR\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002v\u000f\")!\u0010\u0001C\u0005w\u00061!/Z2pe\u0012$2\u0001`A\u0004!\u0011i\u00181\u00013\u000e\u0003yT1a`A\u0001\u00031\u0019HO]3b[J,7m\u001c:e\u0015\t)\u0001-C\u0002\u0002\u0006y\u0014Ab\u0015;sK\u0006l'+Z2pe\u0012Dq!!\u0003z\u0001\u0004\tY!\u0001\u0003be\u001e\u001c\b#\u0002$\u0002\u000e\u0005E\u0011bAA\b\u000f\nQAH]3qK\u0006$X\r\u001a \u0011\u0007\u0019\u000b\u0019\"C\u0002\u0002\u0016\u001d\u00131!\u00118zQ\u001d\u0001\u0011\u0011DA\u0013\u0003O\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?q\u0015A\u0002:v]:,'/\u0003\u0003\u0002$\u0005u!a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003S\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_q\u0015a\u0002:v]:,'o]\u0005\u0005\u0003g\tiCA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\b\u0003o\u0011\u0001\u0012AA\u001d\u0003%:\u0016N\u001c3po\u0006;wM]3hCR,Wk]3ECfd\u0017n\u001a5u)&lW\rS1s]\u0016\u001c8\u000fV3tiB\u00191#a\u000f\u0007\r\u0005\u0011\u0001\u0012AA\u001f'\u0011\tY$a\u0010\u0011\u0007\u0019\u000b\t%C\u0002\u0002D\u001d\u0013a!\u00118z%\u00164\u0007bB\u001f\u0002<\u0011\u0005\u0011q\t\u000b\u0003\u0003sA\u0001\"a\u0013\u0002<\u0011\u0005\u0011QJ\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA(!\u0015)\u0014\u0011KA+\u0013\r\t\u0019F\u000e\u0002\u000b\u0007>dG.Z2uS>t\u0007#\u0002$\u0002X\u0005m\u0013bAA-\u000f\n)\u0011I\u001d:bsB!\u0011QLA2\u001b\t\tyFC\u0002\u0002ba\nA\u0001\\1oO&!\u0011QMA0\u0005\u0019y%M[3di\"B\u0011\u0011JA5\u0003o\nI\b\u0005\u0003\u0002l\u0005Ed\u0002BA\u0016\u0003[JA!a\u001c\u0002.\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a\u001d\u0002v\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005=\u0014QF\u0001\u0005]\u0006lW-\t\u0002\u0002|\u0005q2\u000b^1uK\n\u000b7m[3oIvZ\b' \u0017!)&lWMW8oKvZ\u0018' ")
public class WindowAggregateUseDaylightTimeHarnessTest
extends HarnessTestBase {
    private final TimeZone timeZone;

    @Parameterized.Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateUseDaylightTimeHarnessTest$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().getConfig().setLocalTimeZone(this.timeZone.toZoneId());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE T1 (\n         | `ts` STRING,\n         | `int` INT,\n         | `double` DOUBLE,\n         | `float` FLOAT,\n         | `bigdec` DECIMAL(10, 2),\n         | `string` STRING,\n         | `name` STRING,\n         | proctime AS PROCTIME()\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '", "'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataId})))).stripMargin());
    }

    @Test
    public void testProcessingTimeWindow() {
        boolean bl;
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  MAX(`double`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(proctime),\n        |     INTERVAL '1' HOUR,\n        |     INTERVAL '3' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(package$.MODULE$.tableConversions(t1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)), "WindowAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        if (this.timeZone.useDaylightTime()) {
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T01:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T02:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-03-14T00:00:00"), this.ts("2021-03-14T03:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T04:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T05:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T03:00:00"), this.ts("2021-03-14T06:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T01:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T02:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)2L), this.ts("2021-11-07T00:00:00"), this.ts("2021-11-07T03:00:00")})));
            bl = expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T03:00:00"), this.ts("2021-11-07T04:00:00")})));
        } else {
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T06:00:00"), this.ts("2021-03-14T09:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T10:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T11:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-03-14T09:00:00"), this.ts("2021-03-14T12:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T13:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T14:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)0L), this.ts("2021-03-14T12:00:00"), this.ts("2021-03-14T15:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T06:00:00"), this.ts("2021-11-07T08:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T06:00:00"), this.ts("2021-11-07T09:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T10:00:00")})));
            expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T11:00:00")})));
            bl = expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.ts("2021-11-07T09:00:00"), this.ts("2021-11-07T12:00:00")})));
        }
        assertor.assertOutputEquals("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    private void ingestData(KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness) {
        testHarness.setProcessingTime(1615708800000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
        testHarness.setProcessingTime(1615712400000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(1615716000000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(1615719600000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.setProcessingTime(1615723200000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.setProcessingTime(1636268400000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Hi", null})));
        testHarness.setProcessingTime(1636272000000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), null, null})));
        testHarness.setProcessingTime(1636275600000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636279200000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636282800000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(1636286400000L);
    }

    private TimestampData ts(String dt) {
        return TimestampData.fromEpochMillis((long)LocalDateTime.parse(dt).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli());
    }

    private StreamRecord<RowData> record(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x0$1) {
                Object object;
                Object object2 = x0$1;
                if (object2 instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object2);
                    object = BoxesRunTime.boxToLong((long)l);
                } else if (object2 instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object2);
                    object = BoxesRunTime.boxToDouble((double)d);
                } else {
                    object = object2;
                }
                return object;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    public WindowAggregateUseDaylightTimeHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, TimeZone timeZone) {
        this.timeZone = timeZone;
        super(backend);
    }
}

