/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;

public class JoinJsonPlanITCase
extends JsonPlanTestBase {
    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.createTestValuesSourceTable("A", (List<Row>)JavaScalaConversionUtil.toJava(TestData.smallData3()), "a1 int", "a2 bigint", "a3 varchar");
        this.createTestValuesSourceTable("B", (List<Row>)JavaScalaConversionUtil.toJava(TestData.smallData5()), "b1 int", "b2 bigint", "b3 int", "b4 varchar", "b5 bigint");
    }

    @Test
    public void testNonWindowInnerJoin() throws Exception {
        List<String> dataT1 = Arrays.asList("1,1,Hi1", "1,2,Hi2", "1,2,Hi2", "1,5,Hi3", "2,7,Hi5", "1,9,Hi6", "1,8,Hi8", "3,8,Hi9");
        List<String> dataT2 = Arrays.asList("1,1,HiHi", "2,2,HeHe", "3,2,HeHe");
        this.createTestCsvSourceTable("T1", dataT1, "a int", "b bigint", "c varchar");
        this.createTestCsvSourceTable("T2", dataT2, "a int", "b bigint", "c varchar");
        File sinkPath = this.createTestCsvSinkTable("MySink", "a int", "c1 varchar", "c2 varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink SELECT t2.a, t2.c, t1.c\nFROM (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T1\n) as t1\nJOIN (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T2\n) as t2\nON t1.a = t2.a AND t1.b > t2.b");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> expected = Arrays.asList("1,HiHi,Hi2", "1,HiHi,Hi2", "1,HiHi,Hi3", "1,HiHi,Hi6", "1,HiHi,Hi8", "2,HeHe,Hi5");
        this.assertResult(expected, sinkPath);
    }

    @Test
    public void testIsNullInnerJoinWithNullCond() throws Exception {
        List<String> dataT1 = Arrays.asList("1,1,Hi1", "1,2,Hi2", "1,2,Hi2", "1,5,Hi3", "2,7,Hi5", "1,9,Hi6", "1,8,Hi8", "3,8,Hi9");
        List<String> dataT2 = Arrays.asList("1,1,HiHi", "2,2,HeHe", "3,2,HeHe");
        this.createTestCsvSourceTable("T1", dataT1, "a int", "b bigint", "c varchar");
        this.createTestCsvSourceTable("T2", dataT2, "a int", "b bigint", "c varchar");
        this.createTestValuesSinkTable("MySink", "a int", "c1 varchar", "c2 varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink SELECT t2.a, t2.c, t1.c\nFROM (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T1\n) as t1\nJOIN (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T2\n) as t2\nON \n  ((t1.a is null AND t2.a is null) OR\n  (t1.a = t2.a))\n  AND t1.b > t2.b");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> expected = Arrays.asList("+I[1, HiHi, Hi2]", "+I[1, HiHi, Hi2]", "+I[1, HiHi, Hi3]", "+I[1, HiHi, Hi6]", "+I[1, HiHi, Hi8]", "+I[2, HeHe, Hi5]", "+I[null, HeHe, Hi9]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testJoin() throws Exception {
        this.createTestValuesSinkTable("MySink", "a3 varchar", "b4 varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink \nSELECT a3, b4 FROM A, B WHERE a2 = b2");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> expected = Arrays.asList("+I[Hello world, Hallo Welt]", "+I[Hello, Hallo Welt]", "+I[Hi, Hallo]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testInnerJoin() throws Exception {
        this.createTestValuesSinkTable("MySink", "a1 int", "b1 int");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink \nSELECT a1, b1 FROM A JOIN B ON a1 = b1");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> expected = Arrays.asList("+I[1, 1]", "+I[2, 2]", "+I[2, 2]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testJoinWithFilter() throws Exception {
        this.createTestValuesSinkTable("MySink", "a3 varchar", "b4 varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink \nSELECT a3, b4 FROM A, B where a2 = b2 and a2 < 2");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> expected = Arrays.asList("+I[Hi, Hallo]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testInnerJoinWithDuplicateKey() throws Exception {
        this.createTestValuesSinkTable("MySink", "a1 int", "b1 int", "b3 int");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink \nSELECT a1, b1, b3 FROM A JOIN B ON a1 = b1 AND a1 = b3");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> expected = Arrays.asList("+I[2, 2, 2]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }
}

