/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class UnionJsonPlanITCase
extends JsonPlanTestBase {
    @Test
    public void testUnion() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.data1()), "a int", "b varchar", "c int");
        this.createTestValuesSourceTable("MyTable2", (List<Row>)JavaScalaConversionUtil.toJava(TestData.data1()), "a int", "b varchar", "c int");
        this.createTestNonInsertOnlyValuesSinkTable("MySink", "a int", "b varchar", "c bigint");
        String dml = "INSERT INTO MySink (SELECT * FROM MyTable where a >=3)     union all (select * from MyTable2 where a <= 3)";
        this.executeSqlWithJsonPlanVerified(dml).await();
        List<String> expected = Arrays.asList("+I[2, a, 6]", "+I[4, b, 8]", "+I[6, c, 10]", "+I[1, a, 5]", "+I[3, b, 7]", "+I[5, c, 9]", "+I[3, b, 7]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }
}

