/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.ChangelogSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t-f\u0001B\u0001\u0003\u0001M\u0011Qc\u00115b]\u001e,Gn\\4T_V\u00148-Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011ad\u0015;sK\u0006l\u0017N\\4XSRDW*\u001b8j\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u0011m\u0001!\u0011!Q\u0001\nq\t!b]8ve\u000e,Wj\u001c3f!\ti\u0002I\u0004\u0002\u001fc9\u0011q\u0004\r\b\u0003A=r!!\t\u0018\u000f\u0005\tjcBA\u0012-\u001d\t!3F\u0004\u0002&U9\u0011a%K\u0007\u0002O)\u0011\u0001FE\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119QA\r\u0002\t\u0002M\nQc\u00115b]\u001e,Gn\\4T_V\u00148-Z%U\u0007\u0006\u001cX\r\u0005\u00025k5\t!AB\u0003\u0002\u0005!\u0005ag\u0005\u00026oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001aDQAP\u001b\u0005\u0002}\na\u0001P5oSRtD#A\u001a\u0007\t\u0005+\u0004I\u0011\u0002\u000b'>,(oY3N_\u0012,7\u0003\u0002!8\u0007\u001a\u0003\"\u0001\u000f#\n\u0005\u0015K$a\u0002)s_\u0012,8\r\u001e\t\u0003q\u001dK!\u0001S\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011)\u0003%Q3A\u0005\u0002-\u000bA!\\8eKV\tA\n\u0005\u0002N!:\u0011\u0001HT\u0005\u0003\u001ff\na\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011q*\u000f\u0005\t)\u0002\u0013\t\u0012)A\u0005\u0019\u0006)Qn\u001c3fA!)a\b\u0011C\u0001-R\u0011q+\u0017\t\u00031\u0002k\u0011!\u000e\u0005\u0006\u0015V\u0003\r\u0001\u0014\u0005\u00067\u0002#\t\u0005X\u0001\ti>\u001cFO]5oOR\tA\nC\u0004_\u0001\u0006\u0005I\u0011A0\u0002\t\r|\u0007/\u001f\u000b\u0003/\u0002DqAS/\u0011\u0002\u0003\u0007A\nC\u0004c\u0001F\u0005I\u0011A2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAM\u000b\u0002MK.\na\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Wf\n!\"\u00198o_R\fG/[8o\u0013\ti\u0007NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dqa\u001c!\u0002\u0002\u0013\u0005\u0003/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005Y\u0006twMC\u0001w\u0003\u0011Q\u0017M^1\n\u0005E\u001b\bbB=A\u0003\u0003%\tA_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002wB\u0011\u0001\b`\u0005\u0003{f\u00121!\u00138u\u0011!y\b)!A\u0005\u0002\u0005\u0005\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0007\tI\u0001E\u00029\u0003\u000bI1!a\u0002:\u0005\r\te.\u001f\u0005\t\u0003\u0017q\u0018\u0011!a\u0001w\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005=\u0001)!A\u0005B\u0005E\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0001CBA\u000b\u00037\t\u0019!\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0005]!\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\u0005\u0002)!A\u0005\u0002\u0005\r\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\u00121\u0006\t\u0004q\u0005\u001d\u0012bAA\u0015s\t9!i\\8mK\u0006t\u0007BCA\u0006\u0003?\t\t\u00111\u0001\u0002\u0004!I\u0011q\u0006!\u0002\u0002\u0013\u0005\u0013\u0011G\u0001\tQ\u0006\u001c\bnQ8eKR\t1\u0010C\u0005\u00026\u0001\u000b\t\u0011\"\u0011\u00028\u00051Q-];bYN$B!!\n\u0002:!Q\u00111BA\u001a\u0003\u0003\u0005\r!a\u0001\b\u0013\u0005uR'!A\t\u0002\u0005}\u0012AC*pkJ\u001cW-T8eKB\u0019\u0001,!\u0011\u0007\u0011\u0005+\u0014\u0011!E\u0001\u0003\u0007\u001aR!!\u0011\u0002F\u0019\u0003b!a\u0012\u0002L1;VBAA%\u0015\t9\u0011(\u0003\u0003\u0002N\u0005%#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9a(!\u0011\u0005\u0002\u0005ECCAA \u0011%Y\u0016\u0011IA\u0001\n\u000b\n)\u0006F\u0001r\u0011)\tI&!\u0011\u0002\u0002\u0013\u0005\u00151L\u0001\u0006CB\u0004H.\u001f\u000b\u0004/\u0006u\u0003B\u0002&\u0002X\u0001\u0007A\n\u0003\u0006\u0002b\u0005\u0005\u0013\u0011!CA\u0003G\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002f\u0005-\u0004\u0003\u0002\u001d\u0002h1K1!!\u001b:\u0005\u0019y\u0005\u000f^5p]\"I\u0011QNA0\u0003\u0003\u0005\raV\u0001\u0004q\u0012\u0002\u0004BCA9\u0003\u0003\n\t\u0011\"\u0003\u0002t\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\bE\u0002s\u0003oJ1!!\u001ft\u0005\u0019y%M[3di\"I\u0011QP\u001bC\u0002\u0013\u0005\u0011qP\u0001\u0011\u0007\"\u000bejR#M\u001f\u001e{6kT+S\u0007\u0016+\u0012a\u0016\u0005\b\u0003\u0007+\u0004\u0015!\u0003X\u0003E\u0019\u0005*\u0011(H\u000b2{uiX*P+J\u001bU\t\t\u0005\n\u0003\u000f+$\u0019!C\u0001\u0003\u007f\nae\u0011%B\u001d\u001e+EjT$`'>+&kQ#`/&#\u0006jX#W\u000b:#6k\u0018#V!2K5)\u0011+F\u0011\u001d\tY)\u000eQ\u0001\n]\u000bqe\u0011%B\u001d\u001e+EjT$`'>+&kQ#`/&#\u0006jX#W\u000b:#6k\u0018#V!2K5)\u0011+FA!I\u0011qR\u001bC\u0002\u0013\u0005\u0011qP\u0001\u000e+B\u001bVI\u0015+`'>+&kQ#\t\u000f\u0005MU\u0007)A\u0005/\u0006qQ\u000bU*F%R{6kT+S\u0007\u0016\u0003\u0003\"CALk\t\u0007I\u0011AA@\u0003AqujX+Q\t\u0006#ViX*P+J\u001bU\tC\u0004\u0002\u001cV\u0002\u000b\u0011B,\u0002#9{u,\u0016)E\u0003R+ulU(V%\u000e+\u0005\u0005C\u0004\u0002 V\"\t!!)\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002$B1\u0011QUAV\u0003_k!!a*\u000b\u0007\u0005%V/\u0001\u0003vi&d\u0017\u0002BAW\u0003O\u0013!bQ8mY\u0016\u001cG/[8o!\u0015A\u0014\u0011WA;\u0013\r\t\u0019,\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\t\u0003;\u000b9,a4\u0002RB!\u0011\u0011XAe\u001d\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\fqA];o]\u0016\u00148OC\u0002\u0002DB\tQA[;oSRLA!a2\u0002>\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a3\u0002N\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005\u001d\u0017QX\u0001\u0005]\u0006lW-\t\u0002\u0002T\u0006Y3k\\;sG\u0016l4\u0010M?-A5Kg.\u001b\"bi\u000eDWh_\u0019~Y\u0001\u001aF/\u0019;f\u0005\u0006\u001c7.\u001a8e{m\u0014T\u0010\u0003\u0006\u0002X\u0002\u0011\t\u0011)A\u0005\u00033\f\u0011\"\\5oS\n\u000bGo\u00195\u0011\t\u0005m\u0017Q\u001d\b\u0005\u0003;\f\tOD\u0002!\u0003?L!a\u0006\u0004\n\u0007\u0005\rh#\u0001\u0010TiJ,\u0017-\\5oO^KG\u000f['j]&\u0014\u0015\r^2i)\u0016\u001cHOQ1tK&!\u0011q]Au\u00055i\u0015N\\5CCR\u001c\u0007.T8eK*\u0019\u00111\u001d\f\t\u0015\u00055\bA!A!\u0002\u0013\ty/A\u0003ti\u0006$X\r\u0005\u0003\u0002r\u0006]h\u0002BAo\u0003gL1!!>\u0017\u0003i\u0019FO]3b[&twmV5uQN#\u0018\r^3UKN$()Y:f\u0013\u0011\tI0a?\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'bAA{-!1a\b\u0001C\u0001\u0003\u007f$\u0002B!\u0001\u0003\u0004\t\u0015!q\u0001\t\u0003i\u0001AaaGA\u007f\u0001\u0004a\u0002\u0002CAl\u0003{\u0004\r!!7\t\u0011\u00055\u0018Q a\u0001\u0003_DqAa\u0003\u0001\t\u0003\u0011i!\u0001\bvg\u0016\u001cH*Z4bGf\u0014vn^:\u0016\u0005\t=\u0001\u0003\u0002B\t\u0005+i!Aa\u0005\u000b\u0005]Q\u0011\u0002\u0002B\f\u0005'\u0011\u0011\u0003T3hC\u000eL(k\\<SKN|WO]2fQ\u0011\u0011IAa\u0007\u0011\t\tu!qD\u0007\u0003\u0003\u0003LAA!\t\u0002B\n!!+\u001e7f\u0011\u001d\u0011)\u0003\u0001C!\u0005O\taAY3g_J,GC\u0001B\u0015!\rA$1F\u0005\u0004\u0005[I$\u0001B+oSRDCAa\t\u00032A!!Q\u0004B\u001a\u0013\u0011\u0011)$!1\u0003\r\t+gm\u001c:f\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005O\t1\u0003^3tiR{'+\u001a;sC\u000e$8\u000b\u001e:fC6DCAa\u000e\u0003>A!!Q\u0004B \u0013\u0011\u0011\t%!1\u0003\tQ+7\u000f\u001e\u0005\b\u0005\u000b\u0002A\u0011\u0001B\u0014\u0003A!Xm\u001d;U_V\u00038/\u001a:u'&t7\u000e\u000b\u0003\u0003D\tu\u0002b\u0002B&\u0001\u0011\u0005!qE\u0001\u000ei\u0016\u001cH/Q4he\u0016<\u0017\r^3)\t\t%#Q\b\u0005\b\u0005#\u0002A\u0011\u0001B\u0014\u0003e!Xm\u001d;BO\u001e\u0014XmZ1uKR{W\u000b]:feR\u001c\u0016N\\6)\t\t=#Q\b\u0005\b\u0005/\u0002A\u0011\u0001B\u0014\u0003a!Xm\u001d;He>,\bOQ=O_:\u0004&/[7bef\\U-\u001f\u0015\u0005\u0005+\u0012i\u0004C\u0004\u0003^\u0001!\tAa\n\u0002\u0015Q,7\u000f\u001e$jYR,'\u000f\u000b\u0003\u0003\\\tu\u0002b\u0002B2\u0001\u0011\u0005!qE\u0001\u0010i\u0016\u001cHOU3hk2\f'OS8j]\"\"!\u0011\rB\u001f\u0011\u001d\u0011I\u0007\u0001C\u0005\u0005O\tqC]3hSN$XM]\"iC:<W\r\\8h'>,(oY3\t\u000f\t5\u0004\u0001\"\u0003\u0003(\u0005Q#/Z4jgR,'o\u00115b]\u001e,Gn\\4T_V\u00148-Z,ji\",e/\u001a8ug\u0012+\b\u000f\\5dCR,\u0007b\u0002B9\u0001\u0011%!qE\u0001\u0015e\u0016<\u0017n\u001d;feV\u00038/\u001a:u'>,(oY3\t\u000f\tU\u0004\u0001\"\u0003\u0003(\u00051\"/Z4jgR,'OT8Va\u0012\fG/Z*pkJ\u001cW\rC\u0004\u0003z\u0001!IAa\u001f\u0002+\r|gN^3siR{gj\\+qI\u0006$X\rR1uCR!!Q\u0010BH!\u0019\t)Ba \u0003\u0004&!!\u0011QA\f\u0005\r\u0019V-\u001d\t\u0005\u0005\u000b\u0013Y)\u0004\u0002\u0003\b*\u0019!\u0011\u0012\u0007\u0002\u000bQL\b/Z:\n\t\t5%q\u0011\u0002\u0004%><\b\u0002\u0003BI\u0005o\u0002\rA! \u0002\t\u0011\fG/\u0019\u0015\b\u0001\tU%\u0011\u0015BR!\u0011\u00119J!(\u000e\u0005\te%\u0002\u0002BN\u0003\u0003\faA];o]\u0016\u0014\u0018\u0002\u0002BP\u00053\u0013qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0003&B!\u00111\u0018BT\u0013\u0011\u0011I+!0\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class ChangelogSourceITCase
extends StreamingWithMiniBatchTestBase {
    private final SourceMode sourceMode;

    @Parameterized.Parameters(name="Source={0}, MiniBatch={1}, StateBackend={2}")
    public static Collection<Object[]> parameters() {
        return ChangelogSourceITCase$.MODULE$.parameters();
    }

    public static SourceMode NO_UPDATE_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.NO_UPDATE_SOURCE();
    }

    public static SourceMode UPSERT_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.UPSERT_SOURCE();
    }

    public static SourceMode CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE() {
        return ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
    }

    public static SourceMode CHANGELOG_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE();
    }

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Override
    @Before
    public void before() {
        SourceMode sourceMode;
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            super.before();
                            String orderDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ordersData());
                            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE orders (\n         |  amount BIGINT,\n         |  currency STRING\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '", "',\n         | 'changelog-mode' = 'I'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{orderDataId})))).stripMargin());
                            sourceMode = this.sourceMode;
                            SourceMode sourceMode2 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE();
                            SourceMode sourceMode3 = sourceMode;
                            if (sourceMode2 != null ? !((Object)sourceMode2).equals(sourceMode3) : sourceMode3 != null) break block2;
                            this.registerChangelogSource();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        SourceMode sourceMode4 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
                        SourceMode sourceMode5 = sourceMode;
                        if (sourceMode4 != null ? !((Object)sourceMode4).equals(sourceMode5) : sourceMode5 != null) break block4;
                        this.registerChangelogSourceWithEventsDuplicate();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    SourceMode sourceMode6 = ChangelogSourceITCase$.MODULE$.UPSERT_SOURCE();
                    SourceMode sourceMode7 = sourceMode;
                    if (sourceMode6 != null ? !((Object)sourceMode6).equals(sourceMode7) : sourceMode7 != null) break block5;
                    this.registerUpsertSource();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                SourceMode sourceMode8 = ChangelogSourceITCase$.MODULE$.NO_UPDATE_SOURCE();
                SourceMode sourceMode9 = sourceMode;
                if (sourceMode8 != null ? !((Object)sourceMode8).equals(sourceMode9) : sourceMode9 != null) break block6;
                this.registerNoUpdateSource();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)sourceMode);
    }

    @Test
    public void testToRetractStream() {
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM users"})).s((Seq)Nil$.MODULE$))).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        TestingRetractSink sink = new TestingRetractSink();
        result.addSink((SinkFunction)sink).setParallelism(result.parallelism());
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user1,Tom,tom123@gmail.com,8.10,16.20", "user3,Bailey,bailey@qq.com,9.99,19.98", "user4,Tina,tina@gmail.com,11.30,22.60"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testToUpsertSink() {
        boolean bl;
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE user_sink (\n         |  user_id STRING PRIMARY KEY NOT ENFORCED,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 DECIMAL(18,2)\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |INSERT INTO user_sink\n         |SELECT * FROM users\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user1,Tom,tom123@gmail.com,8.10,16.20", "user3,Bailey,bailey@qq.com,9.99,19.98", "user4,Tina,tina@gmail.com,11.30,22.60"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaBuffer(TestValuesTableFactory.getResults("user_sink")).sorted((Ordering)Ordering.String$.MODULE$));
        SourceMode sourceMode = this.sourceMode;
        SourceMode sourceMode2 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE();
        SourceMode sourceMode3 = sourceMode;
        if (!(sourceMode2 != null ? !((Object)sourceMode2).equals(sourceMode3) : sourceMode3 != null)) {
            bl = true;
        } else {
            SourceMode sourceMode4 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
            SourceMode sourceMode5 = sourceMode;
            bl = !(sourceMode4 != null ? !((Object)sourceMode4).equals(sourceMode5) : sourceMode5 != null);
        }
        if (bl) {
            List<String> rawResult = TestValuesTableFactory.getRawResults("user_sink");
            boolean hasUB = JavaConversions$.MODULE$.asScalaBuffer(rawResult).exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String r) {
                    return r.startsWith("-U");
                }
            });
            Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sink result shouldn't contain UPDATE_BEFORE, but is:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConversions$.MODULE$.asScalaBuffer(rawResult).mkString("\n")})), (boolean)hasUB);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Test
    public void testAggregate() {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT count(*), sum(balance), max(email)\n         |FROM users\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        TestingRetractSink sink = new TestingRetractSink();
        result.addSink((SinkFunction)sink).setParallelism(result.parallelism());
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,29.39,tom123@gmail.com"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAggregateToUpsertSink() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE user_sink (\n         |  `scope` STRING,\n         |  cnt BIGINT,\n         |  sum_balance DECIMAL(18,2),\n         |  max_email STRING,\n         |  PRIMARY KEY (`scope`) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |INSERT INTO user_sink\n         |SELECT 'ALL', count(*), sum(balance), max(email)\n         |FROM users\n         |GROUP BY 'ALL'\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALL,3,29.39,tom123@gmail.com"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaBuffer(TestValuesTableFactory.getResults("user_sink")).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGroupByNonPrimaryKey() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE user_sink (\n         |  balance DECIMAL(18,2),\n         |  cnt BIGINT,\n         |  max_email STRING,\n         |  PRIMARY KEY (balance) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |INSERT INTO user_sink\n         |SELECT balance2, count(*), max(email)\n         |FROM users\n         |GROUP BY balance2\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"16.20,1,tom123@gmail.com", "19.98,1,bailey@qq.com", "22.60,1,tina@gmail.com"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaBuffer(TestValuesTableFactory.getResults("user_sink")).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFilter() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE user_sink (\n         |  user_id STRING PRIMARY KEY NOT ENFORCED,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 DECIMAL(18,2)\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |INSERT INTO user_sink\n         |SELECT * FROM users WHERE balance > 9\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user3,Bailey,bailey@qq.com,9.99,19.98", "user4,Tina,tina@gmail.com,11.30,22.60"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaBuffer(TestValuesTableFactory.getResults("user_sink")).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRegularJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |SELECT o.currency, o.amount, r.rate, o.amount * r.rate\n        |FROM orders AS o JOIN rates AS r\n        |ON o.currency = r.currency\n        |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        TestingRetractSink sink = new TestingRetractSink();
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink).setParallelism(result.parallelism());
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Euro,2,119,238", "Euro,3,119,357", "US Dollar,1,102,102", "US Dollar,5,102,510"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void registerChangelogSource() {
        String userDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.userChangelog());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE users (\n         |  user_id STRING,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 AS balance * 2\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '", "',\n         | 'changelog-mode' = 'I,UA,UB,D',\n         | 'disable-lookup' = 'true'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userDataId})))).stripMargin());
        String ratesDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ratesHistoryData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE rates (\n         |  currency STRING,\n         |  rate BIGINT\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'changelog-mode' = 'I,UB,UA,D',\n         |  'disable-lookup' = 'true'\n         |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ratesDataId})))).stripMargin());
    }

    private void registerChangelogSourceWithEventsDuplicate() {
        this.tEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_SOURCE_CDC_EVENTS_DUPLICATE, true);
        Seq userChangelog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+I", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+I", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("+I", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("-U", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+U", "user1", "Tom", "tom123@gmail.com", new BigDecimal("8.1")), TestValuesTableFactory.changelogRow("-U", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+U", "user1", "Tom", "tom123@gmail.com", new BigDecimal("8.1")), TestValuesTableFactory.changelogRow("+I", "user3", "Bailey", "bailey@gmail.com", new BigDecimal("9.99")), TestValuesTableFactory.changelogRow("-D", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("-D", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("+I", "user4", "Tina", "tina@gmail.com", new BigDecimal("11.3")), TestValuesTableFactory.changelogRow("-U", "user3", "Bailey", "bailey@gmail.com", new BigDecimal("9.99")), TestValuesTableFactory.changelogRow("+U", "user3", "Bailey", "bailey@qq.com", new BigDecimal("9.99"))}));
        String userDataId = TestValuesTableFactory.registerData((Seq<Row>)userChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE users (\n         |  user_id STRING,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 AS balance * 2,\n         |  PRIMARY KEY (user_name, user_id) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '", "',\n         | 'changelog-mode' = 'UA,D',\n         | 'disable-lookup' = 'true'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userDataId})))).stripMargin());
        Seq ratesChangelog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+I", "US Dollar", 102L), TestValuesTableFactory.changelogRow("+I", "Euro", 114L), TestValuesTableFactory.changelogRow("+I", "Euro", 114L), TestValuesTableFactory.changelogRow("+I", "Yen", 1L), TestValuesTableFactory.changelogRow("-U", "Euro", 114L), TestValuesTableFactory.changelogRow("+U", "Euro", 116L), TestValuesTableFactory.changelogRow("-U", "Euro", 116L), TestValuesTableFactory.changelogRow("+U", "Euro", 119L), TestValuesTableFactory.changelogRow("-U", "Euro", 116L), TestValuesTableFactory.changelogRow("+U", "Euro", 119L), TestValuesTableFactory.changelogRow("-D", "Yen", 1L), TestValuesTableFactory.changelogRow("-D", "Yen", 1L)}));
        String ratesDataId = TestValuesTableFactory.registerData((Seq<Row>)ratesChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE rates (\n         |  currency STRING,\n         |  rate BIGINT,\n         |  PRIMARY KEY (currency) NOT ENFORCED\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'changelog-mode' = 'UA,D',\n         |  'disable-lookup' = 'true'\n         |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ratesDataId})))).stripMargin());
    }

    private void registerUpsertSource() {
        String userDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.userUpsertlog());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE users (\n         |  user_id STRING,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 AS balance * 2,\n         |  PRIMARY KEY (user_name, user_id) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '", "',\n         | 'changelog-mode' = 'UA,D',\n         | 'disable-lookup' = 'true'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userDataId})))).stripMargin());
        String ratesDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ratesUpsertData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE rates (\n         |  currency STRING,\n         |  rate BIGINT,\n         |  PRIMARY KEY (currency) NOT ENFORCED\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'changelog-mode' = 'UA,D',\n         |  'disable-lookup' = 'true'\n         |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ratesDataId})))).stripMargin());
    }

    private void registerNoUpdateSource() {
        Seq<Row> userChangelog = this.convertToNoUpdateData(TestData$.MODULE$.userChangelog());
        String userDataId = TestValuesTableFactory.registerData(userChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE users (\n         |  user_id STRING,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 AS balance * 2\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '", "',\n         | 'changelog-mode' = 'I,D',\n         | 'disable-lookup' = 'true'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userDataId})))).stripMargin());
        Seq<Row> ratesChangelog = this.convertToNoUpdateData(TestData$.MODULE$.ratesHistoryData());
        String ratesDataId = TestValuesTableFactory.registerData(ratesChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE rates (\n         |  currency STRING,\n         |  rate BIGINT\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'changelog-mode' = 'I,D',\n         |  'disable-lookup' = 'true'\n         |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ratesDataId})))).stripMargin());
    }

    private Seq<Row> convertToNoUpdateData(Seq<Row> data) {
        return (Seq)data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Row row2) {
                RowKind rowKind;
                block5: {
                    Row row3;
                    block3: {
                        block4: {
                            block2: {
                                rowKind = row2.getKind();
                                boolean bl = RowKind.INSERT.equals(rowKind) ? true : RowKind.DELETE.equals(rowKind);
                                if (!bl) break block2;
                                row3 = row2;
                                break block3;
                            }
                            if (!RowKind.UPDATE_BEFORE.equals(rowKind)) break block4;
                            Row ret = Row.copy((Row)row2);
                            ret.setKind(RowKind.DELETE);
                            row3 = ret;
                            break block3;
                        }
                        if (!RowKind.UPDATE_AFTER.equals(rowKind)) break block5;
                        Row ret = Row.copy((Row)row2);
                        ret.setKind(RowKind.INSERT);
                        row3 = ret;
                    }
                    return row3;
                }
                throw new MatchError((Object)rowKind);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ChangelogSourceITCase(SourceMode sourceMode, StreamingWithMiniBatchTestBase.MiniBatchMode miniBatch, StreamingWithStateTestBase.StateBackendMode state) {
        this.sourceMode = sourceMode;
        super(miniBatch, state);
    }

    public static class SourceMode
    implements Product,
    Serializable {
        private final String mode;

        public String mode() {
            return this.mode;
        }

        public String toString() {
            return this.mode();
        }

        public SourceMode copy(String mode) {
            return new SourceMode(mode);
        }

        public String copy$default$1() {
            return this.mode();
        }

        public String productPrefix() {
            return "SourceMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.mode();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SourceMode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SourceMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            SourceMode sourceMode = (SourceMode)x$1;
            String string = this.mode();
            String string2 = sourceMode.mode();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!sourceMode.canEqual(this)) return false;
            return true;
        }

        public SourceMode(String mode) {
            this.mode = mode;
            Product.class.$init$((Product)this);
        }
    }
}

