/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.LocalDateTime;
import java.util.Collection;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestAddWithOpen$;
import org.apache.flink.types.Row;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001M\u0011\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbCA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0015:\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001\"B\u000e#\u0001\u0004a\u0002bB\u0015\u0001\u0005\u0004%\tAK\u0001\u0005I\u0006$\u0018-F\u0001,!\ra\u0013gM\u0007\u0002[)\u0011afL\u0001\nS6lW\u000f^1cY\u0016T!\u0001\r\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00023[\t!A*[:u!\t!t'D\u00016\u0015\t1D\"A\u0003usB,7/\u0003\u00029k\t\u0019!k\\<\t\ri\u0002\u0001\u0015!\u0003,\u0003\u0015!\u0017\r^1!\u0011\u001da\u0004A1A\u0005\u0002)\nA\u0002Z1uC^KG\u000f\u001b(vY2DaA\u0010\u0001!\u0002\u0013Y\u0013!\u00043bi\u0006<\u0016\u000e\u001e5Ok2d\u0007\u0005C\u0004A\u0001\t\u0007I\u0011\u0001\u0016\u0002\u0011U\u001cXM\u001d#bi\u0006DaA\u0011\u0001!\u0002\u0013Y\u0013!C;tKJ$\u0015\r^1!\u0011\u001d!\u0005A1A\u0005\u0002)\n\u0001#^:fe\u0012\u000bG/Y,ji\"tU\u000f\u001c7\t\r\u0019\u0003\u0001\u0015!\u0003,\u0003E)8/\u001a:ECR\fw+\u001b;i\u001dVdG\u000e\t\u0005\u0006\u0011\u0002!\t%S\u0001\u0007E\u00164wN]3\u0015\u0003)\u0003\"!H&\n\u00051s\"\u0001B+oSRD#a\u0012(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0003\u0012!\u00026v]&$\u0018BA*Q\u0005\u0019\u0011UMZ8sK\")Q\u000b\u0001C!\u0013\u0006)\u0011M\u001a;fe\"\u0012Ak\u0016\t\u0003\u001fbK!!\u0017)\u0003\u000b\u00053G/\u001a:\t\u000bm\u0003A\u0011\u0002/\u0002#\r\u0014X-\u0019;f\u0019>|7.\u001e9UC\ndW\rF\u0002K;\u001aDQA\u0018.A\u0002}\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u0005\u0001\u001cgBA\u000fb\u0013\t\u0011g$\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012\u001f\u0011\u0015I#\f1\u0001h!\rA\u0007o\r\b\u0003S:t!A[7\u000e\u0003-T!\u0001\u001c\n\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012BA8\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!AM9\u000b\u0005=t\u0002\"B:\u0001\t\u0013!\u0018aI2sK\u0006$X\rT8pWV\u0004H+\u00192mK^KG\u000f[\"p[B,H/\u001a3D_2,XN\u001c\u000b\u0004\u0015V4\b\"\u00020s\u0001\u0004y\u0006\"B\u0015s\u0001\u00049\u0007\"\u0002=\u0001\t\u0013I\u0018aD2sK\u0006$XmU2b]R\u000b'\r\\3\u0015\u0007)S8\u0010C\u0003_o\u0002\u0007q\fC\u0003*o\u0002\u0007q\rC\u0003~\u0001\u0011\u0005\u0011*A\u000buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0005q|\bcA(\u0002\u0002%\u0019\u00111\u0001)\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003\u000f\u0001A\u0011A%\u0002EQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f[+eM\u001aKG\u000e^3sQ\r\t)a \u0005\u0007\u0003\u001b\u0001A\u0011A%\u0002OQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f[+eM\u0016\u000bX/\u00197GS2$XM\u001d\u0015\u0004\u0003\u0017y\bBBA\n\u0001\u0011\u0005\u0011*\u0001\u0012uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0004\u0003#y\bBBA\r\u0001\u0011\u0005\u0011*\u0001\u0012uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]:+H\u000e\\1cY\u0016\\U-\u001f\u0015\u0004\u0003/y\bBBA\u0010\u0001\u0011\u0005\u0011*A\u0011uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD\u0007+^:i\t><h\u000eK\u0002\u0002\u001e}Da!!\n\u0001\t\u0003I\u0015a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"tuN\\#rk\u0006dg)\u001b7uKJD3!a\t\u0000\u0011\u0019\tY\u0003\u0001C\u0001\u0013\u0006\u0011C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRLg)[3mIND3!!\u000b\u0000\u0011\u0019\t\t\u0004\u0001C\u0001\u0013\u0006)C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm\u001d\u0015\u0004\u0003_y\bBBA\u001c\u0001\u0011\u0005\u0011*\u0001\u0014uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7egJB3!!\u000e\u0000\u0011\u0019\ti\u0004\u0001C\u0001\u0013\u0006!D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm],ji\"\u001cuN\\:uC:$8*Z=)\u0007\u0005mr\u0010\u0003\u0004\u0002D\u0001!\t!S\u0001;i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\u0017\u0016Lh)[3mIN<\u0016\u000e\u001e5TiJLgnZ\"p]N$\u0018M\u001c;LKfD3!!\u0011\u0000\u0011\u0019\tI\u0005\u0001C\u0001\u0013\u00069C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7i\u001c8ti\u0006tGoS3zQ\r\t9e \u0005\u0007\u0003\u001f\u0002A\u0011A%\u00023Q,7\u000f\u001e'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0004\u0003\u001bz\bBBA+\u0001\u0011\u0005\u0011*\u0001\u0014uKN$H*\u001a4u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\u001c(vY2\f'\r\\3LKfD3!a\u0015\u0000\u0011\u0019\tY\u0006\u0001C\u0001\u0013\u0006AC/Z:u\u0019\u00164GOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;LKf4\u0015.\u001a7eg\"\u001a\u0011\u0011L@\t\r\u0005\u0005\u0004\u0001\"\u0001J\u0003E\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016|e.T;mi&\\U-\u001f$jK2$7oV5uQ:+H\u000e\u001c#bi\u0006D3!a\u0018\u0000\u0011\u0019\t9\u0007\u0001C\u0001\u0013\u0006)D/Z:u\u0019\u00164GOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\u0017\u0016Lh)[3mIN<\u0016\u000e\u001e5Ok2dG)\u0019;bQ\r\t)g \u0005\u0007\u0003[\u0002A\u0011A%\u0002MQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sg*\u001e7m\u0007>t7\u000f^1oi.+\u0017\u0010K\u0002\u0002l}Da!a\u001d\u0001\t\u0003I\u0015\u0001\u000f;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\bNT;mY\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0004\u0003cz\bBBA=\u0001\u0011\u0005\u0011*\u0001\u0017uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f[+E\r\"\u001a\u0011qO@\t\r\u0005}\u0004\u0001\"\u0001J\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5D_6\u0004X\u000f^3e\u0007>dW/\u001c8)\u0007\u0005ut\u0010\u0003\u0004\u0002\u0006\u0002!\t!S\u00013i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bnQ8naV$X\rZ\"pYVlg.\u00118e!V\u001c\b\u000eR8x]\"\u001a\u00111Q@\t\r\u0005-\u0005\u0001\"\u0001J\u0003y!Xm\u001d;DkJ\u0014XM\u001c;ECR,\u0017J\u001c&pS:\u001cuN\u001c3ji&|g\u000eK\u0002\u0002\n~Ds\u0001AAI\u0003;\u000by\n\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9\nU\u0001\u0007eVtg.\u001a:\n\t\u0005m\u0015Q\u0013\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9\u000bU\u0001\beVtg.\u001a:t\u0013\u0011\tY+!*\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u000f\u001d\tyK\u0001E\u0001\u0003c\u000b\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u0011\u0007\u0019\n\u0019L\u0002\u0004\u0002\u0005!\u0005\u0011QW\n\u0005\u0003g\u000b9\fE\u0002\u001e\u0003sK1!a/\u001f\u0005\u0019\te.\u001f*fM\"91%a-\u0005\u0002\u0005}FCAAY\u0011!\t\u0019-a-\u0005\u0002\u0005\u0015\u0017A\u00039be\u0006lW\r^3sgR\u0011\u0011q\u0019\t\u0007\u0003\u0013\f\u0019.a6\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fA!\u001e;jY*\u0011\u0011\u0011[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002V\u0006-'AC\"pY2,7\r^5p]B)Q$!7\u0002^&\u0019\u00111\u001c\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005}\u0017Q]\u0007\u0003\u0003CTA!a9\u0002P\u0006!A.\u00198h\u0013\u0011\t9/!9\u0003\r=\u0013'.Z2uQ!\t\t-a;\u0002z\u0006m\b\u0003BAw\u0003gtA!a)\u0002p&!\u0011\u0011_AS\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011Q_A|\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0003c\f)+\u0001\u0003oC6,\u0017EAA\u007f\u0003UaUmZ1dsR\u000b'\r\\3T_V\u00148-Z\u001f|au\u0004")
public class LookupJoinITCase
extends StreamingTestBase {
    private final boolean legacyTableSource;
    private final List<Row> data;
    private final List<Row> dataWithNull;
    private final List<Row> userData;
    private final List<Row> userDataWithNull;

    @Parameterized.Parameters(name="LegacyTableSource={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.createScanTable("src", this.data());
        this.createScanTable("nullable_src", this.dataWithNull());
        this.createLookupTable("user_table", this.userData());
        this.createLookupTable("nullable_user_table", this.userDataWithNull());
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
    }

    @Override
    @After
    public void after() {
        if (this.legacyTableSource) {
            Assert.assertEquals((long)0L, (long)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get());
        } else {
            Assert.assertEquals((long)0L, (long)TestValuesTableFactory.RESOURCE_COUNTER.get());
        }
    }

    private void createLookupTable(String tableName, List<Row> data) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), false, data, userSchema, tableName, InMemoryLookupableTableSource$.MODULE$.createTemporaryTable$default$6());
        } else {
            String dataId = TestValuesTableFactory.registerData(data);
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |CREATE TABLE ", " (\n           |  `age` INT,\n           |  `id` BIGINT,\n           |  `name` STRING\n           |) WITH (\n           |  'connector' = 'values',\n           |  'data-id' = '", "'\n           |)\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dataId})))).stripMargin());
        }
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        if (!this.legacyTableSource) {
            String dataId = TestValuesTableFactory.registerData(data);
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |CREATE TABLE ", " (\n           |  `age` INT,\n           |  `id` BIGINT,\n           |  `name` STRING,\n           |  `nominal_age` as age + 1\n           |) WITH (\n           |  'connector' = 'values',\n           |  'data-id' = '", "'\n           |)\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dataId})))).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE ", " (\n         |  `id` BIGINT,\n         |  `len` INT,\n         |  `content` STRING,\n         |  `proctime` AS PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dataId})))).stripMargin());
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithUdfFilter() {
        this.tEnv().registerFunction("add", (ScalarFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE add(T.id, D.id) > 3 AND add(T.id, 2) > 3 AND add (D.id, 2) > 3";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        Assert.assertEquals((long)0L, (long)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter().get());
    }

    @Test
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.id, T.len, T.content, D.name\n        |FROM\n        |  src AS T JOIN user_table for system_time as of T.proctime AS D\n        |ON T.id = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnConstantKey() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.id = 1";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Julian", "3,15,Fabian,Julian", "8,11,Hello world,Julian", "9,12,Hello world!,Julian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithPushDown() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22", "3,15,Fabian,Fabian,33"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFields2() {
        String sql = "SELECT t1.id, t1.len, D.name FROM (select proctime, content, id, len FROM src) t1 JOIN user_table for system_time as of t1.proctime AS D ON t1.content = D.name AND t1.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithStringConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Fabian", "2,15,Fabian", "3,15,Fabian", "8,11,Fabian", "9,12,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,Jark,22", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T LEFT OUTER JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,15,null", "3,15,Fabian", "null,11,null", "9,12,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTableOnMultKeyFields() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id and T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,null,null", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT D.id, T.len, D.name FROM nullable_src AS T LEFT JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,15,null", "3,15,Fabian", "null,11,null", "null,12,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = "SELECT T.id, T.len, T.content FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON D.id = null";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertTrue((boolean)sink.getAppendResults().isEmpty());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertTrue((boolean)sink.getAppendResults().isEmpty());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithUDF() {
        String sql = "SELECT T.id, T.content, D.age, D.id FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id + 4 AND T.content = concat(D.name, '!') AND D.age = 11";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"9,Hello world!,11,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        if (this.legacyTableSource) {
            return;
        }
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age "})).s((Seq)Nil$.MODULE$)).append((Object)"FROM src AS T JOIN userTableWithComputedColumn ").append((Object)"for system_time as of T.proctime AS D ON T.id = D.id").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian,11,12", "2,15,Hello,Jark,22,23", "3,15,Fabian,Fabian,33,34"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        if (this.legacyTableSource) {
            return;
        }
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age "})).s((Seq)Nil$.MODULE$)).append((Object)"FROM src AS T JOIN userTableWithComputedColumn ").append((Object)"for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22,23", "3,15,Fabian,Fabian,33,34"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentDateInJoinCondition() {
        String id1 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 1, 0, 0)})}))));
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE Ta (\n         |  id VARCHAR,\n         |  ts TIMESTAMP,\n         |  proc AS PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'bounded' = 'true'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id1})))).stripMargin();
        this.tEnv().executeSql(ddl1);
        String id2 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 2, 0, 0)})}))));
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE Tb (\n         |  id VARCHAR,\n         |  ts TIMESTAMP\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'bounded' = 'true'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id2})))).stripMargin();
        this.tEnv().executeSql(ddl2);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Ta AS t1\n        |INNER JOIN Tb FOR SYSTEM_TIME AS OF t1.proc AS t2\n        |ON t1.id = t2.id\n        |WHERE\n        |  CAST(coalesce(t1.ts, t2.ts) AS VARCHAR)\n        |  >=\n        |  CONCAT(CAST(CURRENT_DATE AS VARCHAR), ' 00:00:00')\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), sink.getAppendResults());
    }

    public LookupJoinITCase(boolean legacyTableSource) {
        this.legacyTableSource = legacyTableSource;
        this.data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)12), "Julian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"}))}));
        this.dataWithNull = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), "Hello"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), "Hello world"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"}))}));
        this.userData = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)4L), "Hello world"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)5L), "Hello world"}))}));
        this.userDataWithNull = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"}))}));
    }
}

