/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithAggTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0001\u0003\u0001M\u0011Ac\u00159mSR\fum\u001a:fO\u0006$X-\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\tA2\u000b\u001e:fC6LgnZ,ji\"\fum\u001a+fgR\u0014\u0015m]3\t\u0011m\u0001!\u0011!Q\u0001\nq\ta\u0002]1si&\fG.Q4h\u001b>$W\r\u0005\u0002\u001e\u0001:\u0011a$\r\b\u0003?Ar!\u0001I\u0018\u000f\u0005\u0005rcB\u0001\u0012.\u001d\t\u0019CF\u0004\u0002%W9\u0011QE\u000b\b\u0003M%j\u0011a\n\u0006\u0003QI\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000bI\u0012\u0001\u0012A\u001a\u0002)M\u0003H.\u001b;BO\u001e\u0014XmZ1uK&#6)Y:f!\t!T'D\u0001\u0003\r\u0015\t!\u0001#\u00017'\t)t\u0007\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VM\u001a\u0005\u0006}U\"\taP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M2A!Q\u001bA\u0005\nq\u0001+\u0019:uS\u0006d\u0017iZ4N_\u0012,7\u0003\u0002!8\u0007\u001a\u0003\"\u0001\u000f#\n\u0005\u0015K$a\u0002)s_\u0012,8\r\u001e\t\u0003q\u001dK!\u0001S\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011)\u0003%Q3A\u0005\u0002-\u000b1#[:QCJ$\u0018.\u00197BO\u001e,e.\u00192mK\u0012,\u0012\u0001\u0014\t\u0003q5K!AT\u001d\u0003\u000f\t{w\u000e\\3b]\"A\u0001\u000b\u0011B\tB\u0003%A*\u0001\u000bjgB\u000b'\u000f^5bY\u0006;w-\u00128bE2,G\r\t\u0005\u0006}\u0001#\tA\u0015\u000b\u0003'V\u0003\"\u0001\u0016!\u000e\u0003UBQAS)A\u00021CQa\u0016!\u0005Ba\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u00023B\u0011!,\u0018\b\u0003qmK!\u0001X\u001d\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039fBq!\u0019!\u0002\u0002\u0013\u0005!-\u0001\u0003d_BLHCA*d\u0011\u001dQ\u0005\r%AA\u00021Cq!\u001a!\u0012\u0002\u0013\u0005a-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003\u001dT#\u0001\u00145,\u0003%\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\u0013Ut7\r[3dW\u0016$'B\u00018:\u0003)\tgN\\8uCRLwN\\\u0005\u0003a.\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d\u0011\b)!A\u0005BM\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001;\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018\u0001\u00027b]\u001eT\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002_m\"9A\u0010QA\u0001\n\u0003i\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001@\u0011\u0005az\u0018bAA\u0001s\t\u0019\u0011J\u001c;\t\u0013\u0005\u0015\u0001)!A\u0005\u0002\u0005\u001d\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\ty\u0001E\u00029\u0003\u0017I1!!\u0004:\u0005\r\te.\u001f\u0005\n\u0003#\t\u0019!!AA\u0002y\f1\u0001\u001f\u00132\u0011%\t)\u0002QA\u0001\n\u0003\n9\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0002\u0005\u0004\u0002\u001c\u0005\u0005\u0012\u0011B\u0007\u0003\u0003;Q1!a\b:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tiB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t9\u0003QA\u0001\n\u0003\tI#\u0001\u0005dC:,\u0015/^1m)\ra\u00151\u0006\u0005\u000b\u0003#\t)#!AA\u0002\u0005%\u0001\"CA\u0018\u0001\u0006\u0005I\u0011IA\u0019\u0003!A\u0017m\u001d5D_\u0012,G#\u0001@\t\u0013\u0005U\u0002)!A\u0005B\u0005]\u0012AB3rk\u0006d7\u000fF\u0002M\u0003sA!\"!\u0005\u00024\u0005\u0005\t\u0019AA\u0005\u000f%\ti$NA\u0001\u0012\u0003\ty$\u0001\bQCJ$\u0018.\u00197BO\u001elu\u000eZ3\u0011\u0007Q\u000b\tE\u0002\u0005Bk\u0005\u0005\t\u0012AA\"'\u0015\t\t%!\u0012G!\u0019\t9%a\u0013M'6\u0011\u0011\u0011\n\u0006\u0003\u000feJA!!\u0014\u0002J\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000fy\n\t\u0005\"\u0001\u0002RQ\u0011\u0011q\b\u0005\n/\u0006\u0005\u0013\u0011!C#\u0003+\"\u0012\u0001\u001e\u0005\u000b\u00033\n\t%!A\u0005\u0002\u0006m\u0013!B1qa2LHcA*\u0002^!1!*a\u0016A\u00021C!\"!\u0019\u0002B\u0005\u0005I\u0011QA2\u0003\u001d)h.\u00199qYf$B!!\u001a\u0002lA!\u0001(a\u001aM\u0013\r\tI'\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u00055\u0014qLA\u0001\u0002\u0004\u0019\u0016a\u0001=%a!Q\u0011\u0011OA!\u0003\u0003%I!a\u001d\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003k\u00022!^A<\u0013\r\tIH\u001e\u0002\u0007\u001f\nTWm\u0019;\t\u0013\u0005uTG1A\u0005\u0002\u0005}\u0014\u0001\u0004)beRL\u0017\r\\!hO>sW#A*\t\u000f\u0005\rU\u0007)A\u0005'\u0006i\u0001+\u0019:uS\u0006d\u0017iZ4P]\u0002B\u0011\"a\"6\u0005\u0004%\t!a \u0002\u001bA\u000b'\u000f^5bY\u0006;wm\u00144g\u0011\u001d\tY)\u000eQ\u0001\nM\u000ba\u0002U1si&\fG.Q4h\u001f\u001a4\u0007\u0005C\u0004\u0002\u0010V\"\t!!%\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002\u0014B1\u0011QSAN\u0003?k!!a&\u000b\u0007\u0005e\u00050\u0001\u0003vi&d\u0017\u0002BAO\u0003/\u0013!bQ8mY\u0016\u001cG/[8o!\u0015A\u0014\u0011UA;\u0013\r\t\u0019+\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\t\u0003\u001b\u000b9+a0\u0002BB!\u0011\u0011VA]\u001d\u0011\tY+!.\u000e\u0005\u00055&\u0002BAX\u0003c\u000bqA];o]\u0016\u00148OC\u0002\u00024B\tQA[;oSRLA!a.\u0002.\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a/\u0002>\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005]\u0016QV\u0001\u0005]\u0006lW-\t\u0002\u0002D\u0006\t\u0004+\u0019:uS\u0006d\u0017iZ4>wBjH\u0006\t'pG\u0006dw\t\\8cC2l40M?-AM#\u0018\r^3CC\u000e\\WM\u001c3>wJj\bBCAd\u0001\t\u0005\t\u0015!\u0003\u0002J\u00069\u0011mZ4N_\u0012,\u0007\u0003BAf\u0003+tA!!4\u0002R:\u0019\u0001%a4\n\u0005]1\u0011bAAj-\u0005A2\u000b\u001e:fC6LgnZ,ji\"\fum\u001a+fgR\u0014\u0015m]3\n\t\u0005]\u0017\u0011\u001c\u0002\b\u0003\u001e<Wj\u001c3f\u0015\r\t\u0019N\u0006\u0005\u000b\u0003;\u0004!\u0011!Q\u0001\n\u0005}\u0017a\u00022bG.,g\u000e\u001a\t\u0005\u0003C\f9O\u0004\u0003\u0002N\u0006\r\u0018bAAs-\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK&!\u0011\u0011^Av\u0005A\u0019F/\u0019;f\u0005\u0006\u001c7.\u001a8e\u001b>$WMC\u0002\u0002fZAaA\u0010\u0001\u0005\u0002\u0005=H\u0003CAy\u0003g\f)0a>\u0011\u0005Q\u0002\u0001BB\u000e\u0002n\u0002\u0007A\u0004\u0003\u0005\u0002H\u00065\b\u0019AAe\u0011!\ti.!<A\u0002\u0005}\u0007bBA~\u0001\u0011\u0005\u0013Q`\u0001\u0007E\u00164wN]3\u0015\u0005\u0005}\bc\u0001\u001d\u0003\u0002%\u0019!1A\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0003s\u00149\u0001\u0005\u0003\u0003\n\t-QBAAY\u0013\u0011\u0011i!!-\u0003\r\t+gm\u001c:f\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003{\f\u0011\u0003^3ti\u000e{WO\u001c;ESN$\u0018N\\2uQ\u0011\u0011yA!\u0006\u0011\t\t%!qC\u0005\u0005\u00053\t\tL\u0001\u0003UKN$\bb\u0002B\u000f\u0001\u0011\u0005\u0011Q`\u0001\u0016i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4hQ\u0011\u0011YB!\u0006\t\u000f\t\r\u0002\u0001\"\u0001\u0002~\u0006IB/Z:u\u001bVdG/[\"pk:$H)[:uS:\u001cG/Q4hQ\u0011\u0011\tC!\u0006\t\u000f\t%\u0002\u0001\"\u0001\u0002~\u0006\u0001D/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<\u0017I\u001c3P]\u0016|%/T;mi&tuN\u001c#jgRLgn\u0019;BO\u001eDCAa\n\u0003\u0016!9!q\u0006\u0001\u0005\u0002\u0005u\u0018\u0001\t;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"<%o\\;q\u0005fDCA!\f\u0003\u0016!9!Q\u0007\u0001\u0005\u0002\u0005u\u0018A\u000e;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"\fe\u000e\u001a(p]\u0012K7\u000f^5oGR\fumZ(o'\u0006lWmQ8mk6t\u0007\u0006\u0002B\u001a\u0005+AqAa\u000f\u0001\t\u0003\ti0\u0001\u0016uKN$8k\\7f\u0007>dW/\u001c8t\u0005>$\b.\u00138ESN$\u0018N\\2u\u0003\u001e<\u0017I\u001c3He>,\bOQ=)\t\te\"Q\u0003\u0005\b\u0005\u0003\u0002A\u0011AA\u007f\u0003]!Xm\u001d;BO\u001e<\u0016\u000e\u001e5GS2$XM]\"mCV\u001cX\r\u000b\u0003\u0003@\tU\u0001b\u0002B$\u0001\u0011\u0005\u0011Q`\u0001\u0019i\u0016\u001cH/T5o\u001b\u0006Dx+\u001b;i%\u0016$(/Y2uS>t\u0007\u0006\u0002B#\u0005+AqA!\u0014\u0001\t\u0003\ti0\u0001\u0015uKN$8i\\;oi^KG\u000f[*j]\u001edW\rR5ti&t7\r^!oIJ+GO]1di&|g\u000e\u000b\u0003\u0003L\tU\u0001b\u0002B*\u0001\u0011\u0005\u0011Q`\u0001,i\u0016\u001cHoU;n\u0007>,h\u000e^,ji\"\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fe\u000e\u001a*fiJ\f7\r^5p]\"\"!\u0011\u000bB\u000b\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003{\fq\u0002^3ti\u0006;wmV5uQ*{\u0017N\u001c\u0015\u0005\u0005/\u0012)\u0002C\u0004\u0003`\u0001!\t!!@\u0002)Q,7\u000f^+w/&$\bNU3ue\u0006\u001cG/[8oQ\u0011\u0011iF!\u0006\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002~\u0006!C/Z:u\u0007>,h\u000e\u001e#jgRLgn\u0019;XSRD')\u001b8bef\u0014vn^*pkJ\u001cW\r\u000b\u0003\u0003d\tU\u0001b\u0002B6\u0001\u0011\u0005\u0011Q`\u0001$i\u0016\u001cH/T;mi&\u0004H.\u001a#jgRLgn\u0019;BO\u001e|enU1nK\u000e{G.^7oQ\u0011\u0011IG!\u0006\t\u000f\tE\u0004\u0001\"\u0001\u0002~\u00061C/Z:u\u0003\u001e<g)\u001b7uKJ\u001cE.Y;tK\n{G\u000f[,ji\"\feoZ!oI\u000e{WO\u001c;)\t\t=$Q\u0003\u0015\b\u0001\t]$1\u0011BC!\u0011\u0011IHa \u000e\u0005\tm$\u0002\u0002B?\u0003c\u000baA];o]\u0016\u0014\u0018\u0002\u0002BA\u0005w\u0012qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0003\bB!\u00111\u0016BE\u0013\u0011\u0011Y)!,\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class SplitAggregateITCase
extends StreamingWithAggTestBase {
    private final PartialAggMode partialAggMode;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("id");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("e");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("f");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("g");

    @Parameterized.Parameters(name="PartialAgg={0}, LocalGlobal={1}, StateBackend={2}")
    public static Collection<Object[]> parameters() {
        return SplitAggregateITCase$.MODULE$.parameters();
    }

    public static PartialAggMode PartialAggOff() {
        return SplitAggregateITCase$.MODULE$.PartialAggOff();
    }

    public static PartialAggMode PartialAggOn() {
        return SplitAggregateITCase$.MODULE$.PartialAggOn();
    }

    @Override
    @Before
    public void before() {
        super.before();
        if (this.partialAggMode.isPartialAggEnabled()) {
            this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, true);
        } else {
            this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, false);
        }
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello 2"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), null), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 4"), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 2"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), null), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)6), (Object)"Hello 1")}));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$4 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("T", t);
    }

    @Test
    public void testCountDistinct() {
        List ids = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5}));
        List dateTimes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:01", "1970-01-01 00:00:02", null, "1970-01-01 00:00:04", "1970-01-01 00:00:05", "1970-01-01 00:00:06", "1970-01-01 00:00:07", null, null, "1970-01-01 00:00:10", "1970-01-01 00:00:11", "1970-01-01 00:00:11", "1970-01-01 00:00:13", "1970-01-01 00:00:14", "1970-01-01 00:00:15"}));
        List dates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01", "1970-01-02", null, "1970-01-04", "1970-01-05", "1970-01-06", "1970-01-07", null, null, "1970-01-10", "1970-01-11", "1970-01-11", "1970-01-13", "1970-01-14", "1970-01-15"}));
        List times = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"00:00:01", "00:00:02", null, "00:00:04", "00:00:05", "00:00:06", "00:00:07", null, null, "00:00:10", "00:00:11", "00:00:11", "00:00:13", "00:00:14", "00:00:15"}));
        List integers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", null, "4", "5", "6", "7", null, null, "10", "11", "11", "13", "14", "15"}));
        List chars = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", null, "D", "E", "F", "H", null, null, "K", "L", "L", "N", "O", "P"}));
        MutableList data = new MutableList();
        ids.indices().foreach((Function1)new Serializable(this, ids, dateTimes, dates, times, integers, chars, data){
            public static final long serialVersionUID = 0L;
            private final List ids$1;
            private final List dateTimes$1;
            private final List dates$1;
            private final List times$1;
            private final List integers$1;
            private final List chars$1;
            private final MutableList data$1;

            public final MutableList<Row> apply(int i) {
                String v = (String)this.integers$1.apply(i);
                BigDecimal decimal = v == null ? null : new BigDecimal(v);
                Integer n = v == null ? null : Integer.valueOf(v);
                Long l = v == null ? null : Long.valueOf(v);
                return this.data$1.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.ids$1.apply(i))), DateTimeTestUtil$.MODULE$.localDateTime((String)this.dateTimes$1.apply(i)), DateTimeTestUtil$.MODULE$.localDate((String)this.dates$1.apply(i)), DateTimeTestUtil$.MODULE$.localTime((String)this.times$1.apply(i)), decimal, n, l, this.chars$1.apply(i)}));
            }
            {
                this.ids$1 = ids$1;
                this.dateTimes$1 = dateTimes$1;
                this.dates$1 = dates$1;
                this.times$1 = times$1;
                this.integers$1 = integers$1;
                this.chars$1 = chars$1;
                this.data$1 = data$1;
            }
        });
        MutableList inputs = (MutableList)Random$.MODULE$.shuffle((TraversableOnce)data, MutableList$.MODULE$.canBuildFrom());
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LOCAL_DATE(), Types.LOCAL_TIME(), Types.DECIMAL(), Types.INT(), Types.LONG(), Types.STRING()});
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(inputs, rowType)).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$8)}));
        this.tEnv().createTemporaryView("MyTable", t);
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         | id,\n         | count(distinct a),\n         | count(distinct b),\n         | count(distinct c),\n         | count(distinct d),\n         | count(distinct e),\n         | count(distinct f),\n         | count(distinct g)\n         |FROM MyTable\n         |GROUP BY id\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1,1,1,1,1,1", "2,1,1,1,1,1,1,1", "3,3,3,3,3,3,3,3", "4,2,2,2,2,2,2,2", "5,4,4,4,4,4,4,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSingleDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT COUNT(DISTINCT c) FROM T");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultiCountDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT COUNT(DISTINCT b), COUNT(DISTINCT c) FROM T");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"6,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, SUM(b), COUNT(DISTINCT c), avg(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,3,2,1", "2,29,5,3", "3,10,2,5", "4,21,3,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSingleDistinctAggWithGroupBy() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT c) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2", "2,5", "3,2", "4,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT b), MAX(b), MIN(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,2,1", "2,4,5,2", "3,1,5,5", "4,2,6,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,2", "2,1,8", "3,1,2", "4,1,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAggWithFilterClause() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) filter (where not b = 2),\n         |  MAX(b) filter (where not b = 5),\n         |  MIN(b) filter (where not b = 2)\n         |FROM T\n         |GROUP BY a\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,2,1", "2,3,4,3", "3,1,null,5", "4,2,6,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMinMaxWithRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  c, MIN(b), MAX(b), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, COUNT(DISTINCT b) as b, MAX(b) as c\n         |  FROM T\n         |  GROUP BY a\n         |) GROUP BY c\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,2,2,1", "5,1,4,2", "6,2,2,1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCountWithSingleDistinctAndRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  b, COUNT(DISTINCT b1), COUNT(1)\n         |FROM(\n         |   SELECT\n         |     a, COUNT(b) as b, MAX(b) as b1\n         |   FROM T\n         |   GROUP BY a\n         |) GROUP BY b\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,2,2", "4,1,1", "8,1,1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSumCountWithSingleDistinctAndRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  b, SUM(b1), COUNT(DISTINCT b1), COUNT(1)\n         |FROM(\n         |   SELECT\n         |     a, COUNT(b) as b, MAX(b) as b1\n         |   FROM T\n         |   GROUP BY a\n         |) GROUP BY b\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,7,2,2", "4,6,1,1", "8,5,1,1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAggWithJoin() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT *\n         |FROM(\n         |  SELECT\n         |    c, MIN(b) as b, MAX(b) as d, COUNT(DISTINCT a) as a\n         |  FROM(\n         |    SELECT\n         |      a, COUNT(DISTINCT b) as b, MAX(b) as c\n         |    FROM T\n         |    GROUP BY a\n         |  ) GROUP BY c\n         |) as T1 JOIN T ON T1.b + 2 = T.a\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,2,2,1,4,5,Hello 2", "2,2,2,1,4,5,Hello 3", "2,2,2,1,4,5,null", "2,2,2,1,4,6,Hello 1", "5,1,4,2,3,5,Hello 0", "5,1,4,2,3,5,Hello 1", "6,2,2,1,4,5,Hello 2", "6,2,2,1,4,5,Hello 3", "6,2,2,1,4,5,null", "6,2,2,1,4,6,Hello 1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUvWithRetraction() {
        List data = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, String, String> apply(int i) {
                return new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i % 10))})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i % 100))})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple3<String, String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("src", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  a,\n         |  COUNT(distinct b) as uv\n         |FROM (\n         |  SELECT a, b, last_value(c)\n         |  FROM src\n         |  GROUP BY a, b\n         |) t\n         |GROUP BY a\n     "})).s((Seq)Nil$.MODULE$))).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,10", "1,10", "2,10", "3,10", "4,10", "5,10", "6,10", "7,10", "8,10", "9,10"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCountDistinctWithBinaryRowSource() {
        List data = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<String, String, String, String> apply(int i) {
                return new Tuple4((Object)"1", (Object)"1", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i % 50))})), (Object)"1");
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingBinaryRowSource(data, new CaseClassTypeInfo<Tuple4<String, String, String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<String, String, String, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, String, String, String>>(this, fieldSerializers){

                    public Tuple4<String, String, String, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$5)}));
        this.tEnv().registerTable("src", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  a,\n         |  b,\n         |  COUNT(distinct c) as uv\n         |FROM (\n         |  SELECT\n         |    a, b, c, d\n         |  FROM\n         |    src where b <> ''\n         |  UNION ALL\n         |  SELECT\n         |    a, 'ALL' as b, c, d\n         |  FROM\n         |    src where b <> ''\n         |) t\n         |GROUP BY\n         |  a, b\n     "})).s((Seq)Nil$.MODULE$))).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,50", "1,ALL,50"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultipleDistinctAggOnSameColumn() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b),\n         |  COUNT(DISTINCT b) filter (where not b = 2),\n         |  MAX(b) filter (where not b = 5),\n         |  MIN(b) filter (where not b = 2)\n         |FROM T\n         |GROUP BY a\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,1,2,1", "2,4,3,4,3", "3,1,1,null,5", "4,2,2,6,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAggFilterClauseBothWithAvgAndCount() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  COUNT(b),\n         |  SUM(b),\n         |  AVG(b)\n         |FROM T\n         |GROUP BY a\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,3,2,3,1", "2,3,24,8,29,3", "3,1,null,2,10,5", "4,2,6,4,21,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public SplitAggregateITCase(PartialAggMode partialAggMode, StreamingWithAggTestBase.AggMode aggMode, StreamingWithStateTestBase.StateBackendMode backend) {
        this.partialAggMode = partialAggMode;
        super(aggMode, StreamingWithMiniBatchTestBase$.MODULE$.MiniBatchOn(), backend);
    }

    public static class PartialAggMode
    implements Product,
    Serializable {
        private final boolean isPartialAggEnabled;

        public boolean isPartialAggEnabled() {
            return this.isPartialAggEnabled;
        }

        public String toString() {
            return this.isPartialAggEnabled() ? "ON" : "OFF";
        }

        public PartialAggMode copy(boolean isPartialAggEnabled) {
            return new PartialAggMode(isPartialAggEnabled);
        }

        public boolean copy$default$1() {
            return this.isPartialAggEnabled();
        }

        public String productPrefix() {
            return "PartialAggMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return BoxesRunTime.boxToBoolean((boolean)this.isPartialAggEnabled());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartialAggMode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)(this.isPartialAggEnabled() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartialAggMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            PartialAggMode partialAggMode = (PartialAggMode)x$1;
            if (this.isPartialAggEnabled() != partialAggMode.isPartialAggEnabled()) return false;
            if (!partialAggMode.canEqual(this)) return false;
            return true;
        }

        public PartialAggMode(boolean isPartialAggEnabled) {
            this.isPartialAggEnabled = isPartialAggEnabled;
            Product.class.$init$((Product)this);
        }
    }
}

