/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001'\t\u0019B+[7f\u0003R$(/\u001b2vi\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003#M#(/Z1nS:<G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0013\u0001\u00023bi\u0006,\u0012A\t\t\u0004G)bS\"\u0001\u0013\u000b\u0005\u00152\u0013!C5n[V$\u0018M\u00197f\u0015\t9\u0003&\u0001\u0006d_2dWm\u0019;j_:T\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W\u0011\u0012A\u0001T5tiB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006D\u0001\u0006if\u0004Xm]\u0005\u0003c9\u00121AU8x\u0011\u0019\u0019\u0004\u0001)A\u0005E\u0005)A-\u0019;bA!9Q\u0007\u0001b\u0001\n\u00031\u0014A\u00023bi\u0006LE-F\u00018!\tADH\u0004\u0002:u5\t\u0001&\u0003\u0002<Q\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\rM#(/\u001b8h\u0015\tY\u0004\u0006\u0003\u0004A\u0001\u0001\u0006IaN\u0001\bI\u0006$\u0018-\u00133!\u0011\u001d\u0011\u0005A1A\u0005\u0002\u0005\nq\u0001\u001c;{\t\u0006$\u0018\r\u0003\u0004E\u0001\u0001\u0006IAI\u0001\tYRTH)\u0019;bA!9a\t\u0001b\u0001\n\u00031\u0014!\u00037uu\u0012\u000bG/Y%e\u0011\u0019A\u0005\u0001)A\u0005o\u0005QA\u000e\u001e>ECR\f\u0017\n\u001a\u0011\t\u000b)\u0003A\u0011A&\u0002=Q,7\u000f^,j]\u0012|w/Q4he\u0016<\u0017\r^3P]^\u000bG/\u001a:nCJ\\G#\u0001'\u0011\u0005ej\u0015B\u0001()\u0005\u0011)f.\u001b;)\u0005%\u0003\u0006CA)U\u001b\u0005\u0011&BA*\u0011\u0003\u0015QWO\\5u\u0013\t)&K\u0001\u0003UKN$\b\"B,\u0001\t\u0003Y\u0015A\u000b;fgR<\u0016N\u001c3po\u0006;wM]3hCR,wJ\u001c+j[\u0016\u001cH/Y7q\u0019RTx+\u0019;fe6\f'o\u001b\u0015\u0003-BCQA\u0017\u0001\u0005\u0002-\u000b\u0001\u0006^3ti^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016|enQ;ti>l\u0017N_3e/\u0006$XM]7be.D#!\u0017)\t\u000bu\u0003A\u0011A&\u0002IQ,7\u000f^,j]\u0012|w/Q4he\u0016<\u0017\r^3P]\u000e{W\u000e];uK\u0012\u0014vn\u001e;j[\u0016D#\u0001\u0018)\t\u000b\u0001\u0004A\u0011B1\u0002\u001b1|7-\u00197ECR,G+[7f)\t\u0011'\u000e\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!A/[7f\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u0015Yw\f1\u0001m\u0003\t!8\u000f\u0005\u0002:[&\u0011a\u000e\u000b\u0002\u0005\u0019>tw\r")
public class TimeAttributeITCase
extends StreamingTestBase {
    private final List<Row> data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.001", this.localDateTime(1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.002", this.localDateTime(2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.003", this.localDateTime(3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.004", this.localDateTime(4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.007", this.localDateTime(7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.008", this.localDateTime(8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.016", this.localDateTime(16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)}))}));
    private final String dataId = TestValuesTableFactory.registerData(this.data());
    private final List<Row> ltzData = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.001", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.002", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.003", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.004", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.007", BoxesRunTime.boxToLong((long)7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.008", BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.016", BoxesRunTime.boxToLong((long)16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)}))}));
    private final String ltzDataId = TestValuesTableFactory.registerData(this.ltzData());

    public List<Row> data() {
        return this.data;
    }

    public String dataId() {
        return this.dataId;
    }

    public List<Row> ltzData() {
        return this.ltzData;
    }

    public String ltzDataId() {
        return this.ltzDataId;
    }

    @Test
    public void testWindowAggregateOnWatermark() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE src (\n        |  log_ts STRING,\n        |  ts TIMESTAMP(3),\n        |  a INT,\n        |  b DOUBLE,\n        |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n        |) WITH (\n        |  'connector' = 'values',\n        |  'data-id' = '", "'\n        |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataId()})))).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.003,2,3.0", "1970-01-01T00:00:00.006,2,7.0", "1970-01-01T00:00:00.009,2,6.0", "1970-01-01T00:00:00.018,1,4.0"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWindowAggregateOnTimestampLtzWatermark() {
        String zoneId = "Asia/Shanghai";
        this.tEnv().getConfig().setLocalTimeZone(ZoneId.of(zoneId));
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE src1 (\n         |  log_ts STRING,\n         |  ts BIGINT,\n         |  a INT,\n         |  b DOUBLE,\n         |  ltz_ts AS TO_TIMESTAMP_LTZ(ts, 3),\n         |  WATERMARK FOR ltz_ts AS ltz_ts - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "'\n         |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ltzDataId()})))).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ltz_ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src1\n        |GROUP BY TUMBLE(ltz_ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink(TimeZone.getTimeZone(zoneId));
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T08:00:00.003,2,3.0", "1970-01-01T08:00:00.006,2,7.0", "1970-01-01T08:00:00.009,2,6.0", "1970-01-01T08:00:00.018,1,4.0"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWindowAggregateOnCustomizedWatermark() {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        this.tEnv().createTemporaryFunction("myFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE src (\n        |  log_ts STRING,\n        |  ts TIMESTAMP(3),\n        |  a INT,\n        |  b DOUBLE,\n        |  WATERMARK FOR ts AS myFunc(ts, a)\n        |) WITH (\n        |  'connector' = 'values',\n        |  'data-id' = '", "'\n        |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataId()})))).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.003,2,3.0", "1970-01-01T00:00:00.006,2,7.0", "1970-01-01T00:00:00.009,2,6.0", "1970-01-01T00:00:00.018,1,4.0"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled);
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled);
    }

    @Test
    public void testWindowAggregateOnComputedRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE src (\n        |  log_ts STRING,\n        |  ts TIMESTAMP(3),\n        |  a INT,\n        |  b DOUBLE,\n        |  rowtime AS CAST(log_ts AS TIMESTAMP(3)),\n        |  WATERMARK FOR rowtime AS rowtime - INTERVAL '0.001' SECOND\n        |) WITH (\n        |  'connector' = 'values',\n        |  'data-id' = '", "'\n        |)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataId()})))).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(rowtime, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.003,2,3.0", "1970-01-01T00:00:00.006,2,7.0", "1970-01-01T00:00:00.009,2,6.0", "1970-01-01T00:00:00.018,1,4.0"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    private LocalDateTime localDateTime(long ts) {
        return new Timestamp(ts - (long)TimeZone.getDefault().getOffset(ts)).toLocalDateTime();
    }
}

