/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.ZoneId;
import java.util.Collection;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.stream.sql.WindowAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.FailingCollectionSource;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u0001M\u0011QcV5oI><\u0018iZ4sK\u001e\fG/Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\tC\u001e<\u0007\u000b[1tKB\u0011QdH\u0007\u0002=)\u0011q\u0003C\u0005\u0003Ay\u0011a#Q4he\u0016<\u0017\r^3QQ\u0006\u001cXm\u0015;sCR,w-\u001f\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005)1\u000f^1uKB\u0011A\u0005\u000f\b\u0003KYr!AJ\u001b\u000f\u0005\u001d\"dB\u0001\u00154\u001d\tI#G\u0004\u0002+c9\u00111\u0006\r\b\u0003Y=j\u0011!\f\u0006\u0003]I\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003/\u0019I!a\u000e\f\u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\n\u0005eR$\u0001E*uCR,')Y2lK:$Wj\u001c3f\u0015\t9d\u0003\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003=)8/\u001a+j[\u0016\u001cH/Y7q\u0019RT\bC\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019C\u0015J\u0013\t\u0003\u000f\u0002i\u0011A\u0001\u0005\u00067\r\u0003\r\u0001\b\u0005\u0006E\r\u0003\ra\t\u0005\u0006y\r\u0003\r!\u0010\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0003\u0001\"V/\u001c2mK^Kg\u000eZ8x\u000fJ|W\u000f]*fi\u0016C\b/Z2uK\u0012$\u0015\r^1\u0016\u00039\u00032a\u0014*U\u001b\u0005\u0001&BA)@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003'B\u00131aU3r!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u0015;sS:<\u0007BB/\u0001A\u0003%a*A\u0011Uk6\u0014G.Z,j]\u0012|wo\u0012:pkB\u001cV\r^#ya\u0016\u001cG/\u001a3ECR\f\u0007\u0005C\u0004`\u0001\t\u0007I\u0011A'\u00029Q+XN\u00197f/&tGm\\<Dk\n,W\t\u001f9fGR,G\rR1uC\"1\u0011\r\u0001Q\u0001\n9\u000bQ\u0004V;nE2,w+\u001b8e_^\u001cUOY3FqB,7\r^3e\t\u0006$\u0018\r\t\u0005\bG\u0002\u0011\r\u0011\"\u0001N\u0003y!V/\u001c2mK^Kg\u000eZ8x%>dG.\u001e9FqB,7\r^3e\t\u0006$\u0018\r\u0003\u0004f\u0001\u0001\u0006IAT\u0001 )Vl'\r\\3XS:$wn\u001e*pY2,\b/\u0012=qK\u000e$X\r\u001a#bi\u0006\u0004\u0003bB4\u0001\u0005\u0004%\t!T\u0001\u001e\u0011>\u0004x+\u001b8e_^<%o\\;q'\u0016$X\t\u001f9fGR,G\rR1uC\"1\u0011\u000e\u0001Q\u0001\n9\u000ba\u0004S8q/&tGm\\<He>,\boU3u\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u000f-\u0004!\u0019!C\u0001\u001b\u0006I\u0002j\u001c9XS:$wn^\"vE\u0016,\u0005\u0010]3di\u0016$G)\u0019;b\u0011\u0019i\u0007\u0001)A\u0005\u001d\u0006Q\u0002j\u001c9XS:$wn^\"vE\u0016,\u0005\u0010]3di\u0016$G)\u0019;bA!9q\u000e\u0001b\u0001\n\u0003i\u0015a\u0007%pa^Kg\u000eZ8x%>dG.\u001e9FqB,7\r^3e\t\u0006$\u0018\r\u0003\u0004r\u0001\u0001\u0006IAT\u0001\u001d\u0011>\u0004x+\u001b8e_^\u0014v\u000e\u001c7va\u0016C\b/Z2uK\u0012$\u0015\r^1!\u0011\u001d\u0019\bA1A\u0005\u00025\u000b!eQ;nk2\fG/Z,j]\u0012|wo\u0012:pkB\u001cV\r^#ya\u0016\u001cG/\u001a3ECR\f\u0007BB;\u0001A\u0003%a*A\u0012Dk6,H.\u0019;f/&tGm\\<He>,\boU3u\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u000f]\u0004!\u0019!C\u0001\u001b\u0006q2)^7vY\u0006$XmV5oI><8)\u001e2f\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0005\u0007s\u0002\u0001\u000b\u0011\u0002(\u0002?\r+X.\u001e7bi\u0016<\u0016N\u001c3po\u000e+(-Z#ya\u0016\u001cG/\u001a3ECR\f\u0007\u0005C\u0004|\u0001\t\u0007I\u0011A'\u0002A\r+X.\u001e7bi\u0016<\u0016N\u001c3poJ{G\u000e\\;q\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0005\u0007{\u0002\u0001\u000b\u0011\u0002(\u0002C\r+X.\u001e7bi\u0016<\u0016N\u001c3poJ{G\u000e\\;q\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003\tQb\u0015%B\u001d\u001eC\u0015)S0[\u001f:+UCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u00051\u0006!A/[7f\u0013\u0011\ti!a\u0002\u0003\ri{g.Z%e\u0011!\t\t\u0002\u0001Q\u0001\n\u0005\r\u0011AD*I\u0003:;\u0005*Q%`5>sU\t\t\u0005\b\u0003+\u0001A\u0011IA\f\u0003\u0019\u0011WMZ8sKR\u0011\u0011\u0011\u0004\t\u0004}\u0005m\u0011bAA\u000f\u007f\t!QK\\5uQ\u0011\t\u0019\"!\t\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n\u0011\u0003\u0015QWO\\5u\u0013\u0011\tY#!\n\u0003\r\t+gm\u001c:f\u0011\u001d\ty\u0003\u0001C\u0001\u0003/\t\u0011\u0004^3ti\u00163XM\u001c;US6,G+^7cY\u0016<\u0016N\u001c3po\"\"\u0011QFA\u001a!\u0011\t\u0019#!\u000e\n\t\u0005]\u0012Q\u0005\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002<\u0001!\t!a\u0006\u0002MQ,7\u000f^#wK:$H+[7f)Vl'\r\\3XS:$wn^0He>,\b/\u001b8h'\u0016$8\u000f\u000b\u0003\u0002:\u0005M\u0002bBA!\u0001\u0011\u0005\u0011qC\u0001\u001fi\u0016\u001cH/\u0012<f]R$\u0016.\\3Uk6\u0014G.Z,j]\u0012|woX\"vE\u0016DC!a\u0010\u00024!9\u0011q\t\u0001\u0005\u0002\u0005]\u0011\u0001\t;fgR,e/\u001a8u)&lW\rV;nE2,w+\u001b8e_^|&k\u001c7mkBDC!!\u0012\u00024!9\u0011Q\n\u0001\u0005\u0002\u0005]\u0011\u0001\t;fgR$V/\u001c2mK^Kg\u000eZ8x\u001fV$\b/\u001e;XS:$wn\u001e+j[\u0016DC!a\u0013\u00024!9\u00111\u000b\u0001\u0005\u0002\u0005]\u0011!\t;fgR$V/\u001c2mK^Kg\u000eZ8x\u000fJ|W\u000f](o/&tGm\\<P]2L\b\u0006BA)\u0003gAq!!\u0017\u0001\t\u0003\t9\"\u0001\u0016uKN$H+^7cY\u0016<\u0016N\u001c3po^KG\u000f[8vi>+H\u000f];u/&tGm\\<D_2,XN\\:)\t\u0005]\u00131\u0007\u0005\b\u0003?\u0002A\u0011AA\f\u0003Y!Xm\u001d;Fm\u0016tG\u000fV5nK\"{\u0007oV5oI><\b\u0006BA/\u0003gAq!!\u001a\u0001\t\u0003\t9\"A\u0012uKN$XI^3oiRKW.\u001a%pa^Kg\u000eZ8x?\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:)\t\u0005\r\u00141\u0007\u0005\b\u0003W\u0002A\u0011AA\f\u0003m!Xm\u001d;Fm\u0016tG\u000fV5nK\"{\u0007oV5oI><xlQ;cK\"\"\u0011\u0011NA\u001a\u0011\u001d\t\t\b\u0001C\u0001\u0003/\tQ\u0004^3ti\u00163XM\u001c;US6,\u0007j\u001c9XS:$wn^0S_2dW\u000f\u001d\u0015\u0005\u0003_\n\u0019\u0004C\u0004\u0002x\u0001!\t!a\u0006\u00027Q,7\u000f^#wK:$H+[7f\u0007VlW\u000f\\1uK^Kg\u000eZ8xQ\u0011\t)(a\r\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0018\u0005AC/Z:u\u000bZ,g\u000e\u001e+j[\u0016\u001cU/\\;mCR,w+\u001b8e_^|vI]8va&twmU3ug\"\"\u00111PA\u001a\u0011\u001d\t\u0019\t\u0001C\u0001\u0003/\t\u0001\u0005^3ti\u00163XM\u001c;US6,7)^7vY\u0006$XmV5oI><xlQ;cK\"\"\u0011\u0011QA\u001a\u0011\u001d\tI\t\u0001C\u0001\u0003/\t!\u0005^3ti\u00163XM\u001c;US6,7)^7vY\u0006$XmV5oI><xLU8mYV\u0004\b\u0006BAD\u0003gAs\u0001AAH\u00037\u000bi\n\u0005\u0003\u0002\u0012\u0006]UBAAJ\u0015\u0011\t)*!\n\u0002\rI,hN\\3s\u0013\u0011\tI*a%\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011q\u0014\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*!\u0011QUA\u0013\u0003\u001d\u0011XO\u001c8feNLA!!+\u0002$\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012<q!!,\u0003\u0011\u0003\ty+A\u000bXS:$wn^!hOJ,w-\u0019;f\u0013R\u001b\u0015m]3\u0011\u0007\u001d\u000b\tL\u0002\u0004\u0002\u0005!\u0005\u00111W\n\u0005\u0003c\u000b)\fE\u0002?\u0003oK1!!/@\u0005\u0019\te.\u001f*fM\"9A)!-\u0005\u0002\u0005uFCAAX\u0011!\t\t-!-\u0005\u0002\u0005\r\u0017A\u00039be\u0006lW\r^3sgR\u0011\u0011Q\u0019\t\u0007\u0003\u000f\fi-!5\u000e\u0005\u0005%'bAAf1\u0006!Q\u000f^5m\u0013\u0011\ty-!3\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003?\u0003'\f9.C\u0002\u0002V~\u0012Q!\u0011:sCf\u00042!VAm\u0013\r\tYN\u0016\u0002\u0007\u001f\nTWm\u0019;)\u0011\u0005}\u0016q\\Aw\u0003_\u0004B!!9\u0002h:!\u0011\u0011UAr\u0013\u0011\t)/a)\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\tI/a;\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0002f\u0006\r\u0016\u0001\u00028b[\u0016\f#!!=\u0002k\u0005;w\r\u00155bg\u0016l4\u0010M?-AM#\u0018\r^3CC\u000e\\WM\u001c3>wFjH\u0006I+tKRKW.Z:uC6\u0004H\n\u001e>!{\u0001Z(' ")
public class WindowAggregateITCase
extends StreamingWithStateTestBase {
    private final AggregatePhaseStrategy aggPhase;
    private final boolean useTimestampLtz;
    private final Seq<String> TumbleWindowGroupSetExpectedData;
    private final Seq<String> TumbleWindowCubeExpectedData;
    private final Seq<String> TumbleWindowRollupExpectedData;
    private final Seq<String> HopWindowGroupSetExpectedData;
    private final Seq<String> HopWindowCubeExpectedData;
    private final Seq<String> HopWindowRollupExpectedData;
    private final Seq<String> CumulateWindowGroupSetExpectedData;
    private final Seq<String> CumulateWindowCubeExpectedData;
    private final Seq<String> CumulateWindowRollupExpectedData;
    private final ZoneId SHANGHAI_ZONE;

    @Parameterized.Parameters(name="AggPhase={0}, StateBackend={1}, UseTimestampLtz = {2}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateITCase$.MODULE$.parameters();
    }

    public Seq<String> TumbleWindowGroupSetExpectedData() {
        return this.TumbleWindowGroupSetExpectedData;
    }

    public Seq<String> TumbleWindowCubeExpectedData() {
        return this.TumbleWindowCubeExpectedData;
    }

    public Seq<String> TumbleWindowRollupExpectedData() {
        return this.TumbleWindowRollupExpectedData;
    }

    public Seq<String> HopWindowGroupSetExpectedData() {
        return this.HopWindowGroupSetExpectedData;
    }

    public Seq<String> HopWindowCubeExpectedData() {
        return this.HopWindowCubeExpectedData;
    }

    public Seq<String> HopWindowRollupExpectedData() {
        return this.HopWindowRollupExpectedData;
    }

    public Seq<String> CumulateWindowGroupSetExpectedData() {
        return this.CumulateWindowGroupSetExpectedData;
    }

    public Seq<String> CumulateWindowCubeExpectedData() {
        return this.CumulateWindowCubeExpectedData;
    }

    public Seq<String> CumulateWindowRollupExpectedData() {
        return this.CumulateWindowRollupExpectedData;
    }

    public ZoneId SHANGHAI_ZONE() {
        return this.SHANGHAI_ZONE;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().enableCheckpointing(100L, CheckpointingMode.EXACTLY_ONCE);
        this.env().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)1, (long)0L));
        FailingCollectionSource.reset();
        String timestampDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        String timestampLtzDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithLtzInShanghai());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE T1 (\n        | `ts` ", ",\n        | `int` INT,\n        | `double` DOUBLE,\n        | `float` FLOAT,\n        | `bigdec` DECIMAL(10, 2),\n        | `string` STRING,\n        | `name` STRING,\n        | `rowtime` AS\n        | ", ",\n        | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values',\n        | 'data-id' = '", "',\n        | 'failing-source' = 'true'\n        |)\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.useTimestampLtz ? "BIGINT" : "STRING", this.useTimestampLtz ? "TO_TIMESTAMP_LTZ(`ts`, 3)" : "TO_TIMESTAMP(`ts`)", this.useTimestampLtz ? timestampLtzDataId : timestampDataId})))).stripMargin());
        this.tEnv().createFunction("concat_distinct_agg", JavaUserDefinedAggFunctions.ConcatDistinctAggFunction.class);
        this.tEnv().getConfig().setLocalTimeZone(this.SHANGHAI_ZONE());
        this.tEnv().getConfig().getConfiguration().setString(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, this.aggPhase.toString());
    }

    @Test
    public void testEventTimeTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "a,2020-10-10T00:00:05,2020-10-10T00:00:10,1,3.33,null,3.0,1,Comment#2", "b,2020-10-10T00:00:05,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null"}));
        Assert.assertEquals((Object)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeTumbleWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.TumbleWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeTumbleWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.TumbleWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeTumbleWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.TumbleWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testTumbleWindowOutputWindowTime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  window_time,\n        |  COUNT(*)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end, window_time\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = this.useTimestampLtz ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,2020-10-09T16:00:04.999Z,4", "a,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-09T16:00:09.999Z,1", "b,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-09T16:00:09.999Z,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,2020-10-09T16:00:19.999Z,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-09T16:00:34.999Z,1", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-09T16:00:34.999Z,1"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,2020-10-10T00:00:04.999,4", "a,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-10T00:00:09.999,1", "b,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-10T00:00:09.999,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,2020-10-10T00:00:19.999,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-10T00:00:34.999,1", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-10T00:00:34.999,1"}));
        Assert.assertEquals((Object)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testTumbleWindowGroupOnWindowOnly() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3"}));
        Assert.assertEquals((Object)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testTumbleWindowWithoutOutputWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4,11.10,5.0,1.0,2,Hi|Comment#1", "3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "1,4.44,4.0,4.0,1,Hi", "2,11.10,7.0,3.0,1,Comment#3"}));
        Assert.assertEquals((Object)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Comment#2|Hi|Comment#1", "a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1,Comment#2", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null"}));
        Assert.assertEquals((Object)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeHopWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.HopWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeHopWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.HopWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeHopWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.HopWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null", "null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0,null"}));
        Assert.assertEquals((Object)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeCumulateWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.CumulateWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeCumulateWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY Cube(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.CumulateWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @Test
    public void testEventTimeCumulateWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)((TraversableOnce)this.CumulateWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), (Object)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    public WindowAggregateITCase(AggregatePhaseStrategy aggPhase, StreamingWithStateTestBase.StateBackendMode state, boolean useTimestampLtz) {
        this.aggPhase = aggPhase;
        this.useTimestampLtz = useTimestampLtz;
        super(state);
        this.TumbleWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:10,1,3.33,null,3.0,1,Comment#2", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3"}));
        this.TumbleWindowCubeExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.TumbleWindowRollupExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.HopWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Comment#2|Hi|Comment#1", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1,Comment#2", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "0,null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null", "1,null,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4,Hello|Hi|Comment#2|Comment#1", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:15,3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "1,null,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:25,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1,Comment#3"}));
        this.HopWindowCubeExpectedData = this.HopWindowGroupSetExpectedData();
        this.HopWindowRollupExpectedData = this.HopWindowGroupSetExpectedData();
        this.CumulateWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "0,a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1,Comment#3", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0,null", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4,Hi|Comment#1|Hello|Comment#2", "1,null,2020-10-10T00:00,2020-10-10T00:00:15,8,26.64,6.0,1.0,4,Hi|Comment#1|Hello|Comment#2", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1,Comment#3", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:45,2,11.10,7.0,3.0,1,Comment#3"}));
        this.CumulateWindowCubeExpectedData = this.CumulateWindowGroupSetExpectedData();
        this.CumulateWindowRollupExpectedData = this.CumulateWindowGroupSetExpectedData();
        this.SHANGHAI_ZONE = ZoneId.of("Asia/Shanghai");
    }
}

