/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.RangeInputFormat;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.planner.utils.TestingTableEnvironment$;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00115d\u0001B\u0001\u0003\u0001E\u0011QBQ1uG\"$Vm\u001d;CCN,'BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t)\")\u0019;dQ\u0006\u00137\u000f\u001e:bGR$Vm\u001d;CCN,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0004\u001c\u0001\t\u0007I\u0011\u0002\u000f\u0002\u0011M,G\u000f^5oON,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A!\t1!\u00199j\u0013\t\u0011sDA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000f\u0003\u0004%\u0001\u0001\u0006I!H\u0001\ng\u0016$H/\u001b8hg\u0002BqA\n\u0001C\u0002\u0013%q%A\buKN$\u0018N\\4UC\ndW-\u00128w+\u0005A\u0003CA\u0015,\u001b\u0005Q#BA\u0002\u0007\u0013\ta#FA\fUKN$\u0018N\\4UC\ndW-\u00128wSJ|g.\\3oi\"1a\u0006\u0001Q\u0001\n!\n\u0001\u0003^3ti&tw\rV1cY\u0016,eN\u001e\u0011\t\u000fA\u0002!\u0019!C\u0001c\u0005!A/\u00128w+\u0005\u0011\u0004C\u0001\u00104\u0013\t!tD\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"1a\u0007\u0001Q\u0001\nI\nQ\u0001^#om\u0002Bqa\u0002\u0001C\u0002\u0013%\u0001(F\u0001:!\tQT(D\u0001<\u0015\tad!\u0001\u0006eK2,w-\u0019;j_:L!AP\u001e\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001d\u0002\u0011Ad\u0017M\u001c8fe\u0002BqA\u0011\u0001C\u0002\u0013\u00051)A\u0002f]Z,\u0012\u0001\u0012\t\u0003\u000b.k\u0011A\u0012\u0006\u0003\u000f\"\u000b1\"\u001a8wSJ|g.\\3oi*\u0011\u0001%\u0013\u0006\u0003\u0015*\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u000513%AG*ue\u0016\fW.\u0012=fGV$\u0018n\u001c8F]ZL'o\u001c8nK:$\bB\u0002(\u0001A\u0003%A)\u0001\u0003f]Z\u0004\u0003b\u0002)\u0001\u0005\u0004%\t!U\u0001\u0005G>tg-F\u0001S!\tq2+\u0003\u0002U?\tYA+\u00192mK\u000e{gNZ5h\u0011\u00191\u0006\u0001)A\u0005%\u0006)1m\u001c8gA!9\u0001\f\u0001b\u0001\n\u0003I\u0016\u0001\u0005'J\u001d\u0016{6i\u0014'`!\u0006#F+\u0012*O+\u0005Q\u0006CA.c\u001b\u0005a&BA/_\u0003\u0015\u0011XmZ3y\u0015\ty\u0006-\u0001\u0003vi&d'\"A1\u0002\t)\fg/Y\u0005\u0003Gr\u0013q\u0001U1ui\u0016\u0014h\u000e\u0003\u0004f\u0001\u0001\u0006IAW\u0001\u0012\u0019&sUiX\"P\u0019~\u0003\u0016\t\u0016+F%:\u0003\u0003bB4\u0001\u0005\u0004%\t!W\u0001\u0017\u0019&sUiX\"P\u0019~#v+S\"F?B\u000bE\u000bV#S\u001d\"1\u0011\u000e\u0001Q\u0001\ni\u000bq\u0003T%O\u000b~\u001bu\nT0U/&\u001bUi\u0018)B)R+%K\u0014\u0011\t\u000b-\u0004A\u0011\u00017\u0002\r\t,gm\u001c:f)\u0005i\u0007C\u00018r\u001b\u0005y'\"\u00019\u0002\u000bM\u001c\u0017\r\\1\n\u0005I|'\u0001B+oSRD#A\u001b;\u0011\u0005UDX\"\u0001<\u000b\u0005]t\u0011!\u00026v]&$\u0018BA=w\u0005\u0019\u0011UMZ8sK\")1\u0010\u0001C\u0001Y\u0006)\u0011M\u001a;fe\"\u0012!0 \t\u0003kzL!a <\u0003\u000b\u00053G/\u001a:\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005qQ\r\u001f9mC&tGj\\4jG\u0006dG\u0003BA\u0004\u0003+\u0001B!!\u0003\u0002\u00109\u0019a.a\u0003\n\u0007\u00055q.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\t\u0019B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001by\u0007bB\u0005\u0002\u0002\u0001\u0007\u0011q\u0003\t\u0004=\u0005e\u0011bAA\u000e?\t)A+\u00192mK\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012aC2iK\u000e\\'+Z:vYR$r!\\A\u0012\u0003O\t\u0019\u0005\u0003\u0005\u0002&\u0005u\u0001\u0019AA\u0004\u0003!\u0019\u0018\u000f\\)vKJL\b\u0002CA\u0015\u0003;\u0001\r!a\u000b\u0002\u001d\u0015D\b/Z2uK\u0012\u0014Vm];miB1\u0011QFA\u001a\u0003oi!!a\f\u000b\u0007\u0005Er.\u0001\u0006d_2dWm\u0019;j_:LA!!\u000e\u00020\t\u00191+Z9\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u000b\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t%a\u000f\u0003\u0007I{w\u000f\u0003\u0006\u0002F\u0005u\u0001\u0013!a\u0001\u0003\u000f\n\u0001\"[:T_J$X\r\u001a\t\u0004]\u0006%\u0013bAA&_\n9!i\\8mK\u0006t\u0007bBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u0011G\",7m\u001b+bE2,'+Z:vYR$r!\\A*\u0003+\n9\u0006C\u0004\n\u0003\u001b\u0002\r!a\u0006\t\u0011\u0005%\u0012Q\na\u0001\u0003WA!\"!\u0012\u0002NA\u0005\t\u0019AA$\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n\u0011b\u00195fG.\u001c\u0016N_3\u0015\u000b5\fy&!\u0019\t\u0011\u0005\u0015\u0012\u0011\fa\u0001\u0003\u000fA\u0001\"a\u0019\u0002Z\u0001\u0007\u0011QM\u0001\rKb\u0004Xm\u0019;fINK'0\u001a\t\u0004]\u0006\u001d\u0014bAA5_\n\u0019\u0011J\u001c;\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u00059q-\u001a;QY\u0006tG\u0003BA\u0004\u0003cB\u0001\"a\u001d\u0002l\u0001\u0007\u0011QO\u0001\be\u0016dgj\u001c3f!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\n1A]3m\u0015\r\ty\bD\u0001\bG\u0006d7-\u001b;f\u0013\u0011\t\u0019)!\u001f\u0003\u000fI+GNT8eK\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0015!B2iK\u000e\\G#B7\u0002\f\u00065\u0005\u0002CA\u0013\u0003\u000b\u0003\r!a\u0002\t\u0011\u0005=\u0015Q\u0011a\u0001\u0003#\u000b\u0011b\u00195fG.4UO\\2\u0011\u000f9\f\u0019*a\u000b\u0002\u0018&\u0019\u0011QS8\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#\u00028\u0002\u001a\u0006\u001d\u0011bAAN_\n1q\n\u001d;j_:Dq!a(\u0001\t\u0003\t\t+\u0001\u0006dQ\u0016\u001c7\u000eV1cY\u0016$R!\\AR\u0003KCq!CAO\u0001\u0004\t9\u0002\u0003\u0005\u0002\u0010\u0006u\u0005\u0019AAI\u0011\u001d\tI\u000b\u0001C\u0001\u0003W\u000b1b\u00195fG.4\u0015-\u001b7fIR)Q.!,\u00020\"A\u0011QEAT\u0001\u0004\t9\u0001\u0003\u0005\u00022\u0006\u001d\u0006\u0019AA\u0004\u0003I)\u0007\u0010]3di\u0016$Wj]4QCR$XM\u001d8\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\u0006\u00012\r[3dW\u0016k\u0007\u000f^=SKN,H\u000e\u001e\u000b\u0004[\u0006e\u0006\u0002CA\u0013\u0003g\u0003\r!a\u0002\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u0006Q\u0001/\u0019:tKF+XM]=\u0015\t\u0005]\u0011\u0011\u0019\u0005\t\u0003K\tY\f1\u0001\u0002\b!9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0017\u0001D3yK\u000e,H/Z)vKJLH\u0003BA\u0016\u0003\u0013Dq!CAb\u0001\u0004\t9\u0002C\u0004\u0002F\u0002!\t!!4\u0015\t\u0005-\u0012q\u001a\u0005\t\u0003K\tY\r1\u0001\u0002\b!9\u00111\u001b\u0001\u0005\n\u0005U\u0017!\u00049sKB\f'/\u001a*fgVdG\u000f\u0006\u0004\u0002X\u0006e\u0017Q\u001c\t\u0007\u0003[\t\u0019$a\u0002\t\u0011\u0005m\u0017\u0011\u001ba\u0001\u0003W\t1a]3r\u0011!\t)%!5A\u0002\u0005\u001d\u0003bBAq\u0001\u0011\u0005\u00111]\u0001\nG\",7m[*b[\u0016$\u0002\"a&\u0002f\u0006\u001d\u00181\u001e\u0005\t\u0003S\ty\u000e1\u0001\u0002,!A\u0011\u0011^Ap\u0001\u0004\tY#\u0001\u0004sKN,H\u000e\u001e\u0005\u000b\u0003\u000b\ny\u000e%AA\u0002\u0005\u001d\u0003bBAx\u0001\u0011%\u0011\u0011_\u0001\u000bG\",7m[#naRLH\u0003BAL\u0003gD\u0001\"!;\u0002n\u0002\u0007\u00111\u0006\u0005\b\u0003o\u0004A\u0011BA}\u0003)\u0019\u0018\u000eZ3CsNKG-\u001a\u000b\u0007\u0003w\u00149Aa\u0003\u0011\r\u00055\u00121GA\u007f!\u0011\tyP!\u0002\u000e\u0005\t\u0005!b\u0001B\u0002A\u0006!A.\u00198h\u0013\u0011\t\tB!\u0001\t\u0011\t%\u0011Q\u001fa\u0001\u0003/\fA\u0001\\3gi\"A!QBA{\u0001\u0004\t9.A\u0003sS\u001eDG\u000fC\u0004\u0003\u0012\u0001!\u0019Aa\u0005\u0002%I,w-[:uKJ\u001cu\u000e\u001c7fGRLwN\u001c\u000b\n[\nU!\u0011\u0004B\u001b\u0005\u0017B\u0001Ba\u0006\u0003\u0010\u0001\u0007\u0011qA\u0001\ni\u0006\u0014G.\u001a(b[\u0016D\u0001Ba\u0007\u0003\u0010\u0001\u0007!QD\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0003 \t=\u0012q\u0007\b\u0005\u0005C\u0011YC\u0004\u0003\u0003$\t%RB\u0001B\u0013\u0015\r\u00119\u0003E\u0001\u0007yI|w\u000e\u001e \n\u0003AL1A!\fp\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\r\u00034\tA\u0011\n^3sC\ndWMC\u0002\u0003.=D\u0001Ba\u000e\u0003\u0010\u0001\u0007!\u0011H\u0001\tif\u0004X-\u00138g_B1!1\bB$\u0003oi!A!\u0010\u000b\t\t}\"\u0011I\u0001\tif\u0004X-\u001b8g_*!!1\tB#\u0003\u0019\u0019w.\\7p]*\u0011\u0001EC\u0005\u0005\u0005\u0013\u0012iDA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011!\u0011iEa\u0004A\u0002\u0005\u001d\u0011A\u00024jK2$7\u000fC\u0004\u0003R\u0001!\tAa\u0015\u0002-I,w-[:uKJT\u0015M^1D_2dWm\u0019;j_:,BA!\u0016\u0003dQIQNa\u0016\u0003Z\tU$\u0011\u0010\u0005\t\u0005/\u0011y\u00051\u0001\u0002\b!A!1\u0004B(\u0001\u0004\u0011Y\u0006\u0005\u0004\u0002\u0000\nu#qL\u0005\u0005\u0005c\u0011\t\u0001\u0005\u0003\u0003b\t\rD\u0002\u0001\u0003\t\u0005K\u0012yE1\u0001\u0003h\t\tA+\u0005\u0003\u0003j\t=\u0004c\u00018\u0003l%\u0019!QN8\u0003\u000f9{G\u000f[5oOB\u0019aN!\u001d\n\u0007\tMtNA\u0002B]fD\u0001Ba\u000e\u0003P\u0001\u0007!q\u000f\t\u0007\u0005w\u00119Ea\u0018\t\u0011\t5#q\na\u0001\u0003\u000fAqA!\u0005\u0001\t\u0003\u0011i(\u0006\u0003\u0003\u0000\t%EcC7\u0003\u0002\n\r%1\u0012BH\u0005#C\u0001Ba\u0006\u0003|\u0001\u0007\u0011q\u0001\u0005\t\u00057\u0011Y\b1\u0001\u0003\u0006B1!q\u0004B\u0018\u0005\u000f\u0003BA!\u0019\u0003\n\u0012A!Q\rB>\u0005\u0004\u00119\u0007\u0003\u0005\u00038\tm\u0004\u0019\u0001BG!\u0019\u0011YDa\u0012\u0003\b\"A!Q\nB>\u0001\u0004\t9\u0001\u0003\u0005\u0003\u0014\nm\u0004\u0019\u0001BK\u000391\u0017.\u001a7e\u001dVdG.\u00192mKN\u0004RA\u001cBL\u0003\u000fJ1A!'p\u0005\u0015\t%O]1z\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005;+BAa(\u0003*RiQN!)\u0003$\n-&q\u0016BY\u0005gC\u0001Ba\u0006\u0003\u001c\u0002\u0007\u0011q\u0001\u0005\t\u00057\u0011Y\n1\u0001\u0003&B1!q\u0004B\u0018\u0005O\u0003BA!\u0019\u0003*\u0012A!Q\rBN\u0005\u0004\u00119\u0007\u0003\u0005\u00038\tm\u0005\u0019\u0001BW!\u0019\u0011YDa\u0012\u0003(\"A!Q\nBN\u0001\u0004\t9\u0001\u0003\u0005\u0003\u0014\nm\u0005\u0019\u0001BK\u0011!\u0011)La'A\u0002\t]\u0016!C:uCRL7\u000f^5d!\u0011\u0011ILa1\u000e\u0005\tm&\u0002\u0002B_\u0005\u007f\u000bQa\u001d;biNT1A!1\u0007\u0003\u0011\u0001H.\u00198\n\t\t\u0015'1\u0018\u0002\u000f\r2Lgn[*uCRL7\u000f^5d\u0011\u001d\u0011I\r\u0001C\u0001\u0005\u0017\fqD]3hSN$XM\u001d+f[B|'/\u0019:z'f\u001cH/Z7Gk:\u001cG/[8o)\u0015i'Q\u001aBi\u0011!\u0011yMa2A\u0002\u0005\u001d\u0011\u0001\u00028b[\u0016D\u0001Ba5\u0003H\u0002\u0007!Q[\u0001\u000eMVt7\r^5p]\u000ec\u0017m]:1\t\t]'q\u001c\t\u0007\u0003\u0013\u0011IN!8\n\t\tm\u00171\u0003\u0002\u0006\u00072\f7o\u001d\t\u0005\u0005C\u0012y\u000e\u0002\u0007\u0003b\nE\u0017\u0011!A\u0001\u0006\u0003\u0011\u0019OA\u0002`IE\nBA!\u001b\u0003fB!!q\u001dBw\u001b\t\u0011IOC\u0002\u0003l\"\t\u0011BZ;oGRLwN\\:\n\t\t=(\u0011\u001e\u0002\u0014+N,'\u000fR3gS:,GMR;oGRLwN\u001c\u0005\b\u0005g\u0004A\u0011\u0001B{\u0003A\u0011XmZ5ti\u0016\u0014h)\u001e8di&|g\u000eF\u0003n\u0005o\u0014I\u0010\u0003\u0005\u0003P\nE\b\u0019AA\u0004\u0011!\u0011YP!=A\u0002\tu\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\u0011\t\t\u001d(q`\u0005\u0005\u0007\u0003\u0011IO\u0001\bTG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8)\u0011\tE8QAB\u0006\u0007?\u00012A\\B\u0004\u0013\r\u0019Ia\u001c\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u0002\b\r51QCB\b\u0013\u0011\u0019ya!\u0005\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\u0019\u0019b\\\u0001\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u0004\u0018\re11DB\n\u001d\rq7\u0011D\u0005\u0004\u0007'y\u0017'\u0002\u0012o_\u000eu!!B:dC2\f\u0017'C\u0012\u0002\b\r\u00052QEB\u0012\u0013\u0011\u0019\u0019c!\u0005\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133c%\u00193qCB\r\u0007O\u0019\u0019\"M\u0003#]>\u001ci\u0002C\u0004\u0003t\u0002!\taa\u000b\u0016\r\r52\u0011HB\")\u0019\u0019yca\u0012\u0004JQ)Qn!\r\u0004<!Q11GB\u0015\u0003\u0003\u0005\u001da!\u000e\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0003<\t\u001d3q\u0007\t\u0005\u0005C\u001aI\u0004\u0002\u0005\u0003f\r%\"\u0019\u0001B4\u0011)\u0019id!\u000b\u0002\u0002\u0003\u000f1qH\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004C\u0002B\u001e\u0005\u000f\u001a\t\u0005\u0005\u0003\u0003b\r\rC\u0001CB#\u0007S\u0011\rAa\u001a\u0003\u0007\u0005\u001b5\t\u0003\u0005\u0003P\u000e%\u0002\u0019AA\u0004\u0011!\u0019Ye!\u000bA\u0002\r5\u0013!\u00014\u0011\u0011\t\u001d8qJB\u001c\u0007\u0003JAa!\u0015\u0003j\n\t\u0012iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8)\u0011\r%2QAB+\u00077\n\u0014bIA\u0004\u0007\u001b\u00199fa\u00042\u0013\r\u001a9b!\u0007\u0004Z\rM\u0011'\u0002\u0012o_\u000eu\u0011'C\u0012\u0002\b\r\u00052QLB\u0012c%\u00193qCB\r\u0007?\u001a\u0019\"M\u0003#]>\u001ci\u0002C\u0004\u0003t\u0002!\taa\u0019\u0016\t\r\u00154\u0011\u000f\u000b\u0007\u0007O\u001a\u0019h!\u001e\u0015\u00075\u001cI\u0007\u0003\u0006\u0004l\r\u0005\u0014\u0011!a\u0002\u0007[\n!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\u0011YDa\u0012\u0004pA!!\u0011MB9\t!\u0011)g!\u0019C\u0002\t\u001d\u0004\u0002\u0003Bh\u0007C\u0002\r!a\u0002\t\u0011\r]4\u0011\ra\u0001\u0007s\n!\u0001\u001e4\u0011\r\t\u001d81PB8\u0013\u0011\u0019iH!;\u0003\u001bQ\u000b'\r\\3Gk:\u001cG/[8oQ!\u0019\tg!\u0002\u0004\u0002\u000e\u001d\u0015'C\u0012\u0002\b\r511QB\bc%\u00193qCB\r\u0007\u000b\u001b\u0019\"M\u0003#]>\u001ci\"M\u0005$\u0003\u000f\u0019\tc!#\u0004$EJ1ea\u0006\u0004\u001a\r-51C\u0019\u0006E9|7Q\u0004\u0005\b\u0007\u001f\u0003A\u0011ABI\u00035\u0011XmZ5ti\u0016\u0014(+\u00198hKR)Qna%\u0004\u0016\"A!qZBG\u0001\u0004\t9\u0001\u0003\u0005\u0004\u0018\u000e5\u0005\u0019ABM\u0003\r)g\u000e\u001a\t\u0004]\u000em\u0015bABO_\n!Aj\u001c8h\u0011\u001d\u0019y\t\u0001C\u0001\u0007C#r!\\BR\u0007K\u001bI\u000b\u0003\u0005\u0003P\u000e}\u0005\u0019AA\u0004\u0011!\u00199ka(A\u0002\re\u0015!B:uCJ$\b\u0002CBL\u0007?\u0003\ra!'\t\u000f\r5\u0006\u0001\"\u0001\u00040\u0006qa.Z<SC:<WmU8ve\u000e,GCBBY\u0007\u000f\u001cI\r\u0005\u0004\u00044\u000ee6QX\u0007\u0003\u0007kS1aa.I\u0003)!\u0017\r^1tiJ,\u0017-\\\u0005\u0005\u0007w\u001b)L\u0001\u0006ECR\f7\u000b\u001e:fC6\u0004Baa0\u0004D6\u00111\u0011\u0019\u0006\u0004\u00057A\u0011\u0002BBc\u0007\u0003\u0014qAU8x\t\u0006$\u0018\r\u0003\u0005\u0004(\u000e-\u0006\u0019ABM\u0011!\u00199ja+A\u0002\re\u0005bBBg\u0001\u0011E1qZ\u0001\u0006e><xJ\u001a\u000b\u0005\u0003o\u0019\t\u000e\u0003\u0005\u0004T\u000e-\u0007\u0019ABk\u0003\u0011\t'oZ:\u0011\u000b9\u001c9Na\u001c\n\u0007\rewN\u0001\u0006=e\u0016\u0004X-\u0019;fIzB\u0011b!8\u0001#\u0003%\taa8\u0002+\rDWmY6SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u001d\u0016\u0005\u0003\u000f\u001a\u0019o\u000b\u0002\u0004fB!1q]By\u001b\t\u0019IO\u0003\u0003\u0004l\u000e5\u0018!C;oG\",7m[3e\u0015\r\u0019yo\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBz\u0007S\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00199\u0010AI\u0001\n\u0003\u0019y.\u0001\u000edQ\u0016\u001c7\u000eV1cY\u0016\u0014Vm];mi\u0012\"WMZ1vYR$3\u0007C\u0005\u0004|\u0002\t\n\u0011\"\u0001\u0004`\u0006\u00192\r[3dWN\u000bW.\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u001d91q \u0002\t\u0002\u0011\u0005\u0011!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX\rE\u0002\u0014\t\u00071a!\u0001\u0002\t\u0002\u0011\u00151\u0003\u0002C\u0002\t\u000f\u00012A\u001cC\u0005\u0013\r!Ya\u001c\u0002\u0007\u0003:L(+\u001a4\t\u000f]!\u0019\u0001\"\u0001\u0005\u0010Q\u0011A\u0011\u0001\u0005\t\t'!\u0019\u0001\"\u0001\u0005\u0016\u0005\u0019!o\\<\u0015\t\u0005]Bq\u0003\u0005\t\u0007'$\t\u00021\u0001\u0004V\"AA1\u0004C\u0002\t\u0003!i\"A\u0005cS:\f'/\u001f*poR1Aq\u0004C\u0016\t{\u0001B\u0001\"\t\u0005(5\u0011A1\u0005\u0006\u0005\tK\u0019\t-\u0001\u0004cS:\f'/_\u0005\u0005\tS!\u0019CA\u0007CS:\f'/\u001f*po\u0012\u000bG/\u0019\u0005\t\u0003{!I\u00021\u0001\u0005.A)aNa&\u00050A!A\u0011\u0007C\u001d\u001b\t!\u0019D\u0003\u0003\u00056\u0011]\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0004\u0003{A\u0011\u0002\u0002C\u001e\tg\u00111\u0002T8hS\u000e\fG\u000eV=qK\"A!Q\nC\r\u0001\u0004\u0019)\u000e\u0003\u0005\u0005B\u0011\rA\u0011\u0001C\"\u00035\u0019w.\u001c9be\u0016\u0014Vm];miV!AQ\tC*)%iGq\tC'\t+\"I\u0006\u0003\u0005\u0005J\u0011}\u0002\u0019\u0001C&\u0003=)\u0007\u0010]3di\u0016$7\u000b\u001e:j]\u001e\u001c\b#\u00028\u0003\u0018\u0006\u001d\u0001\u0002CAu\t\u007f\u0001\r\u0001b\u0014\u0011\u000b9\u00149\n\"\u0015\u0011\t\t\u0005D1\u000b\u0003\t\u0005K\"yD1\u0001\u0003h!AAq\u000bC \u0001\u0004\t9%\u0001\u0003t_J$\bB\u0003C.\t\u007f\u0001\n\u00111\u0001\u0002H\u0005A\u0011m\u001d+va2,7\u000f\u0003\u0005\u0005`\u0011\rA\u0011\u0001C1\u0003Q\u0019wN\u001c4jO\u001a{'/T5oS\u000ecWo\u001d;feR\u0019Q\u000eb\u0019\t\rA#i\u00061\u0001S\u0011)!9\u0007b\u0001\u0012\u0002\u0013\u0005A\u0011N\u0001\u0018G>l\u0007/\u0019:f%\u0016\u001cX\u000f\u001c;%I\u00164\u0017-\u001e7uIQ*Baa8\u0005l\u0011A!Q\rC3\u0005\u0004\u00119\u0007")
public class BatchTestBase
extends BatchAbstractTestBase {
    private final EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
    private final TestingTableEnvironment testingTableEnv = TestingTableEnvironment$.MODULE$.create(this.settings(), (Option<CatalogManager>)None$.MODULE$, new TableConfig());
    private final TableEnvironment tEnv = this.testingTableEnv();
    private final PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner();
    private final StreamExecutionEnvironment env = this.planner().getExecEnv();
    private final TableConfig conf;
    private final Pattern LINE_COL_PATTERN;
    private final Pattern LINE_COL_TWICE_PATTERN;

    public static <T> boolean compareResult$default$4() {
        return BatchTestBase$.MODULE$.compareResult$default$4();
    }

    public static void configForMiniCluster(TableConfig tableConfig) {
        BatchTestBase$.MODULE$.configForMiniCluster(tableConfig);
    }

    public static <T> void compareResult(String[] stringArray, Object object, boolean bl, boolean bl2) {
        BatchTestBase$.MODULE$.compareResult(stringArray, object, bl, bl2);
    }

    public static BinaryRowData binaryRow(LogicalType[] logicalTypeArray, Seq<Object> seq2) {
        return BatchTestBase$.MODULE$.binaryRow(logicalTypeArray, seq2);
    }

    public static Row row(Seq<Object> seq2) {
        return BatchTestBase$.MODULE$.row(seq2);
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TestingTableEnvironment testingTableEnv() {
        return this.testingTableEnv;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    private PlannerBase planner() {
        return this.planner;
    }

    public StreamExecutionEnvironment env() {
        return this.env;
    }

    public TableConfig conf() {
        return this.conf;
    }

    public Pattern LINE_COL_PATTERN() {
        return this.LINE_COL_PATTERN;
    }

    public Pattern LINE_COL_TWICE_PATTERN() {
        return this.LINE_COL_TWICE_PATTERN;
    }

    @Before
    public void before() {
        BatchTestBase$.MODULE$.configForMiniCluster(this.conf());
    }

    @After
    public void after() {
        TestValuesTableFactory.clearAllData();
    }

    public String explainLogical(Table table) {
        RelNode ast = TableTestUtil$.MODULE$.toRelNode(table);
        String logicalPlan = this.getPlan(ast);
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Abstract Syntax Tree =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FlinkRelOptUtil$.MODULE$.toString(ast, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5())}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Optimized Logical Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalPlan}))).toString();
    }

    public void checkResult(String sqlQuery, Seq<Row> expectedResult, boolean isSorted) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)new Serializable(this, expectedResult, isSorted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTestBase $outer;
            private final Seq expectedResult$1;
            private final boolean isSorted$1;

            public final Option<String> apply(Seq<Row> result) {
                return this.$outer.checkSame((Seq<Row>)this.expectedResult$1, result, this.isSorted$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedResult$1 = expectedResult$1;
                this.isSorted$1 = isSorted$1;
            }
        });
    }

    public void checkTableResult(Table table, Seq<Row> expectedResult, boolean isSorted) {
        this.checkTable(table, (Function1<Seq<Row>, Option<String>>)new Serializable(this, expectedResult, isSorted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTestBase $outer;
            private final Seq expectedResult$2;
            private final boolean isSorted$2;

            public final Option<String> apply(Seq<Row> result) {
                return this.$outer.checkSame((Seq<Row>)this.expectedResult$2, result, this.isSorted$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedResult$2 = expectedResult$2;
                this.isSorted$2 = isSorted$2;
            }
        });
    }

    public void checkSize(String sqlQuery, int expectedSize) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)new Serializable(this, expectedSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTestBase $outer;
            private final int expectedSize$1;

            public final Option<String> apply(Seq<Row> result) {
                None$ none$;
                if (result.size() != this.expectedSize$1) {
                    Object[] objectArray = new Object[1];
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Correct Result - ", " =="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.expectedSize$1)}));
                    String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Actual Result - ", " =="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)result.size())}));
                    objectArray[0] = this.$outer.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$sideBySide((Seq<String>)((Seq)this.$outer.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$prepareResult((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), false).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.$outer.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$prepareResult(result, false).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n");
                    String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |Results\n             |", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))).stripMargin();
                    none$ = new Some((Object)errorMessage);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedSize$1 = expectedSize$1;
            }
        });
    }

    private String getPlan(RelNode relNode) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner();
        RelNode optimized = planner.optimize(relNode);
        return FlinkRelOptUtil$.MODULE$.toString(optimized, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5());
    }

    public void check(String sqlQuery, Function1<Seq<Row>, Option<String>> checkFunc) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1)new Serializable(this, sqlQuery, table){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTestBase $outer;
            private final String sqlQuery$1;
            private final Table table$2;

            public final void apply(String results) {
                String plan = this.$outer.explainLogical(this.table$2);
                Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |Results do not match for query:\n           |  ", "\n           |", "\n           |Plan:\n           |  ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sqlQuery$1, results, plan})))).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sqlQuery$1 = sqlQuery$1;
                this.table$2 = table$2;
            }
        });
    }

    public boolean checkResult$default$3() {
        return false;
    }

    public void checkTable(Table table, Function1<Seq<Row>, Option<String>> checkFunc) {
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1)new Serializable(this, table){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTestBase $outer;
            private final Table table$1;

            public final void apply(String results) {
                String plan = this.$outer.explainLogical(this.table$1);
                Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |Results do not match:\n           |", "\n           |Plan:\n           |  ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{results, plan})))).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$1 = table$1;
            }
        });
    }

    public boolean checkTableResult$default$3() {
        return false;
    }

    public void checkFailed(String sqlQuery, String expectedMsgPattern) {
        SqlParserException sqlParserException2;
        block27: {
            try {
                Table table = this.parseQuery(sqlQuery);
                Seq<Row> _ = this.executeQuery(table);
                if (expectedMsgPattern != null) {
                    throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected query to throw exception, but it did not;"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" query [", " ];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlQuery}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedMsgPattern}))).toString());
                }
            }
            catch (Throwable throwable) {
                Throwable actualExp = throwable;
                String actualMsg = actualExp.getMessage();
                int actualLine = -1;
                int actualColumn = -1;
                int actualEndLine = 100;
                int actualEndColumn = 99;
                CalciteContextException ece = null;
                SqlParseException spe = null;
                Throwable ex = actualExp;
                boolean found = false;
                while (true) {
                    BoxedUnit boxedUnit;
                    if (ex == null || found) {
                        ex = actualExp;
                        found = false;
                        while (true) {
                            BoxedUnit boxedUnit2;
                            SqlParseException sqlParseException;
                            if (ex == null || found) {
                                if (ece == null) {
                                    if (spe == null) {
                                        String message = actualMsg;
                                        if (message != null) {
                                            Matcher matcher = this.LINE_COL_TWICE_PATTERN().matcher(message);
                                            if (matcher.matches()) {
                                                actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                                                actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                                                actualEndLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt();
                                                actualEndColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(4))).toInt();
                                                actualMsg = matcher.group(5);
                                            } else {
                                                matcher = this.LINE_COL_PATTERN().matcher(message);
                                                if (matcher.matches()) {
                                                    actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                                                    actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                                                }
                                            }
                                        }
                                    } else {
                                        actualLine = spe.getPos().getLineNum();
                                        actualColumn = spe.getPos().getColumnNum();
                                        actualEndLine = spe.getPos().getEndLineNum();
                                        actualEndColumn = spe.getPos().getEndColumnNum();
                                        if (spe.getCause() != null) {
                                            actualExp = spe.getCause();
                                            actualMsg = actualExp.getMessage();
                                        }
                                    }
                                } else {
                                    actualLine = ece.getPosLine();
                                    actualColumn = ece.getPosColumn();
                                    actualEndLine = ece.getEndPosLine();
                                    actualEndColumn = ece.getEndPosColumn();
                                    if (ece.getCause() != null) {
                                        actualExp = ece.getCause();
                                        actualMsg = actualExp.getMessage();
                                    }
                                }
                                if (expectedMsgPattern == null) {
                                    actualExp.printStackTrace();
                                    Assert.fail((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validator threw unexpected exception; query [", "];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlQuery}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" exception [", "]; class [", ".getClass];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{actualMsg, actualExp}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" pos [line ", " col ", " thru line ", " col ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualLine), BoxesRunTime.boxToInteger((int)actualColumn), BoxesRunTime.boxToInteger((int)actualLine), BoxesRunTime.boxToInteger((int)actualColumn)}))).toString());
                                }
                                if (actualMsg == null || !actualMsg.matches(expectedMsgPattern)) {
                                    actualExp.printStackTrace();
                                    Assert.fail((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validator threw different "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exception than expected; query [", "];\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlQuery}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected pattern [", "];\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedMsgPattern}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" actual [", "];\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{actualMsg}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" pos [", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualLine)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" col ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualColumn)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" thru line ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualEndLine)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" col ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualEndColumn)}))).toString());
                                }
                            }
                            Throwable throwable2 = ex;
                            if (throwable2 instanceof SqlParseException && (sqlParseException = (SqlParseException)throwable2).getPos() != null) {
                                spe = sqlParseException;
                                found = true;
                                boxedUnit2 = BoxedUnit.UNIT;
                                continue;
                            }
                            if (throwable2 != null) {
                                Throwable throwable3 = throwable2;
                                Throwable throwable4 = throwable3.getCause();
                                Throwable throwable5 = ex;
                                if (!(throwable4 != null ? !throwable4.equals(throwable5) : throwable5 != null)) {
                                    found = true;
                                    boxedUnit2 = BoxedUnit.UNIT;
                                    continue;
                                }
                            }
                            ex = ex.getCause();
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    }
                    Throwable throwable6 = ex;
                    if (throwable6 instanceof CalciteContextException) {
                        CalciteContextException calciteContextException;
                        ece = calciteContextException = (CalciteContextException)throwable6;
                        found = true;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable6 != null) {
                        Throwable throwable7 = throwable6;
                        Throwable throwable8 = throwable7.getCause();
                        Throwable throwable9 = ex;
                        if (!(throwable8 != null ? !throwable8.equals(throwable9) : throwable9 != null)) {
                            found = true;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SqlParserException sqlParserException2) {
                String errMsg = sqlParserException2.getMessage();
                if (expectedMsgPattern == null) {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while parsing query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlQuery})), sqlParserException2);
                }
                if (errMsg == null || !errMsg.matches(expectedMsgPattern)) break block27;
            }
            return;
        }
        throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error did not match expected [", "] while "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedMsgPattern}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parsing query [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlQuery}))).toString(), sqlParserException2);
    }

    public void checkEmptyResult(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        this.checkEmpty(result).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String results) {
                Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |Results do not match for query:\n           |", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{results})))).stripMargin());
            }
        });
    }

    public Table parseQuery(String sqlQuery) {
        return this.tEnv().sqlQuery(sqlQuery);
    }

    public Seq<Row> executeQuery(Table table) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(CollectionUtil.iteratorToList((Iterator)table.execute().collect())).asScala();
    }

    public Seq<Row> executeQuery(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        return this.executeQuery(table);
    }

    public Seq<String> org$apache$flink$table$planner$runtime$utils$BatchTestBase$$prepareResult(Seq<Row> seq2, boolean isSorted) {
        return isSorted ? (Seq)seq2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$4) {
                return x$4.toString();
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)((SeqLike)seq2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$3) {
                return x$3.toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s;
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    public Option<String> checkSame(Seq<Row> expectedResult, Seq<Row> result, boolean isSorted) {
        None$ none$;
        if (expectedResult.size() == result.size() && this.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$prepareResult(expectedResult, isSorted).equals(this.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$prepareResult(result, isSorted))) {
            none$ = None$.MODULE$;
        } else {
            Object[] objectArray = new Object[1];
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Correct Result - ", " =="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedResult.size())}));
            String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Actual Result - ", " =="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)result.size())}));
            objectArray[0] = this.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$sideBySide((Seq<String>)((Seq)this.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$prepareResult(expectedResult, isSorted).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$prepareResult(result, isSorted).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n");
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |Results\n           |", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))).stripMargin();
            none$ = new Some((Object)errorMessage);
        }
        return none$;
    }

    public boolean checkSame$default$3() {
        return false;
    }

    private Option<String> checkEmpty(Seq<Row> result) {
        Nil$ expectedResult = Nil$.MODULE$;
        return this.checkSame((Seq<Row>)expectedResult, result, true);
    }

    public Seq<String> org$apache$flink$table$planner$runtime$utils$BatchTestBase$$sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)left.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$7) {
                return x$7.length();
            }
        }, Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(right.size() - left.size(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), Seq$.MODULE$.canBuildFrom());
        Seq rightPadded = (Seq)right.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(left.size() - right.size(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)leftPadded.zip((GenIterable)rightPadded, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, maxLeftSize){
            public static final long serialVersionUID = 0L;
            private final int maxLeftSize$1;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String l = (String)tuple2._1();
                    String r = (String)tuple2._2();
                    String string = l;
                    String string2 = r;
                    String string3 = new StringBuilder().append((Object)(!(string == null ? string2 != null : !string.equals(string2)) || l.startsWith("== Correct") ? " " : "!")).append((Object)l).append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.maxLeftSize$1 - l.length() + 3)).append((Object)r).toString();
                    return string3;
                }
                throw new MatchError(tuple2);
            }
            {
                this.maxLeftSize$1 = maxLeftSize$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void registerCollection(String tableName, Iterable<Row> data, TypeInformation<Row> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields);
    }

    public <T> void registerJavaCollection(String tableName, java.lang.Iterable<T> data, TypeInformation<T> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala(), typeInfo, fields);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables, FlinkStatistic statistic) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)new Some((Object)statistic));
    }

    public void registerTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        this.testingTableEnv().createTemporarySystemFunction(name, functionClass);
    }

    public void registerFunction(String name, ScalarFunction function) {
        this.testingTableEnv().registerFunction(name, function);
    }

    public <T, ACC> void registerFunction(String name, AggregateFunction<T, ACC> f, TypeInformation<T> evidence$1, TypeInformation<ACC> evidence$2) {
        this.testingTableEnv().registerFunction(name, f, evidence$1, evidence$2);
    }

    public <T> void registerFunction(String name, TableFunction<T> tf, TypeInformation<T> evidence$3) {
        this.testingTableEnv().registerFunction(name, tf, evidence$3);
    }

    public void registerRange(String name, long end) {
        this.registerRange(name, 0L, end);
    }

    public void registerRange(String name, long start, long end) {
        BatchTableEnvUtil$.MODULE$.registerBoundedStreamInternal(this.tEnv(), name, this.newRangeSource(start, end), (Option<String[]>)new Some((Object)new String[]{"id"}), (Option<boolean[]>)None$.MODULE$, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public DataStream<RowData> newRangeSource(long start, long end) {
        InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new BigIntType()});
        DataStreamSource boundedStream = this.env().createInput((InputFormat)new RangeInputFormat(start, end), (TypeInformation)typeInfo);
        boundedStream.setParallelism(1);
        return boundedStream;
    }

    /*
     * WARNING - void declaration
     */
    public Row rowOf(Seq<Object> args) {
        void var2_2;
        Row row2 = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)new Serializable(this, args, row2){
            public static final long serialVersionUID = 0L;
            private final Seq args$1;
            private final Row row$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.row$1.setField(i, this.args$1.apply(i));
            }
            {
                this.args$1 = args$1;
                this.row$1 = row$1;
            }
        });
        return var2_2;
    }

    public BatchTestBase() {
        this.env().getConfig().enableObjectReuse();
        this.conf = this.tEnv().getConfig();
        this.LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
        this.LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");
    }
}

