/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.runtime.utils.JavaPojos;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingUpsertTableSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class TestSinkUtil$ {
    public static final TestSinkUtil$ MODULE$;

    static {
        new TestSinkUtil$();
    }

    public <T extends TableSink<?>> T configureSink(Table table, T sink) {
        block5: {
            Object object;
            block3: {
                T t;
                TypeInformation[] fieldTypes;
                String[] fieldNames;
                block4: {
                    block2: {
                        RelDataType rowType = TableTestUtil$.MODULE$.toRelNode(table).getRowType();
                        fieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
                        fieldTypes = (TypeInformation[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final LogicalType apply(RelDataTypeField field) {
                                return FlinkTypeFactory$.MODULE$.toLogicalType(field.getType());
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final TypeInformation<?> apply(LogicalType x$1) {
                                return TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)x$1);
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class));
                        t = sink;
                        if (!(t instanceof TestingAppendTableSink)) break block2;
                        object = new TestingAppendTableSink().configure(fieldNames, (TypeInformation<?>[])fieldTypes);
                        break block3;
                    }
                    if (!(t instanceof TestingUpsertTableSink)) break block4;
                    TestingUpsertTableSink testingUpsertTableSink = (TestingUpsertTableSink)t;
                    object = new TestingUpsertTableSink(testingUpsertTableSink.keys(), testingUpsertTableSink.tz()).configure(fieldNames, (TypeInformation<?>[])fieldTypes);
                    break block3;
                }
                if (!(t instanceof TestingRetractTableSink)) break block5;
                object = new TestingRetractTableSink().configure(fieldNames, (TypeInformation<?>[])fieldTypes);
            }
            return (T)object;
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported sink: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink})));
    }

    public String fieldToString(Object field, TimeZone tz) {
        Object object = field;
        boolean bl = object instanceof Date ? true : (object instanceof Time ? true : object instanceof Timestamp);
        String string = bl ? this.unixDateTimeToString(field, tz) : StringUtils.arrayAwareToString((Object)field);
        return string;
    }

    public String rowToString(Row row2, TimeZone tz) {
        StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row2.getArity()).foreach((Function1)new Serializable(row2, tz, sb){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final TimeZone tz$1;
            private final StringBuilder sb$1;

            public final StringBuilder apply(int i) {
                Object object = i > 0 ? this.sb$1.append(",") : BoxedUnit.UNIT;
                return this.sb$1.append(TestSinkUtil$.MODULE$.fieldToString(this.row$1.getField(i), this.tz$1));
            }
            {
                this.row$1 = row$1;
                this.tz$1 = tz$1;
                this.sb$1 = sb$1;
            }
        });
        return sb.toString();
    }

    public TimeZone rowToString$default$2() {
        return TimeZone.getTimeZone("UTC");
    }

    public String genericRowToString(GenericRowData row2, TimeZone tz) {
        StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        sb.append(row2.getRowKind().shortString()).append("(");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row2.getArity()).foreach((Function1)new Serializable(row2, tz, sb){
            public static final long serialVersionUID = 0L;
            private final GenericRowData row$2;
            private final TimeZone tz$2;
            private final StringBuilder sb$2;

            public final StringBuilder apply(int i) {
                Object object = i > 0 ? this.sb$2.append(",") : BoxedUnit.UNIT;
                return this.sb$2.append(TestSinkUtil$.MODULE$.fieldToString(this.row$2.getField(i), this.tz$2));
            }
            {
                this.row$2 = row$2;
                this.tz$2 = tz$2;
                this.sb$2 = sb$2;
            }
        });
        sb.append(")");
        return sb.toString();
    }

    public String pojoToString(JavaPojos.Pojo1 pojo, TimeZone tz) {
        return new StringBuilder().append((Object)"Pojo1{ts=").append((Object)this.fieldToString(pojo.ts, tz)).append((Object)", msg='").append((Object)pojo.msg).append((Object)"'}").toString();
    }

    public String unixDateTimeToString(Object value, TimeZone tz) {
        int offset = tz.useDaylightTime() ? tz.getOffset(((java.util.Date)value).getTime()) : tz.getOffset(15L);
        Object object = value;
        if (object instanceof java.util.Date) {
            long l;
            long origin = ((java.util.Date)value).getTime();
            long time = l = origin + (long)DateTimeUtils.UTC_ZONE.getOffset(origin);
            Object object2 = value;
            String string = object2 instanceof Date ? DateTimeUtils.unixDateToString((int)((int)(time / 86400000L) + offset)) : (object2 instanceof Time ? DateTimeUtils.unixTimeToString((int)(((int)(time % 86400000L) + offset) % (int)86400000L)) : (object2 instanceof Timestamp ? DateTimeUtils.unixTimestampToString((long)(time + (long)offset), (int)3) : value.toString()));
            return string;
        }
        throw new MatchError(object);
    }

    private TestSinkUtil$() {
        MODULE$ = this;
    }
}

