/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.utils.DecimalAvgAccumulator;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001f\t)B)Z2j[\u0006d\u0017I^4BO\u001e4UO\\2uS>t'BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!A\u0004qY\u0006tg.\u001a:\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0005#Q1b$D\u0001\u0013\u0015\t\u0019b!A\u0005gk:\u001cG/[8og&\u0011QC\u0005\u0002\u0012\u0003\u001e<'/Z4bi\u00164UO\\2uS>t\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011i\u0017\r\u001e5\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u000b\u0005&<G)Z2j[\u0006d\u0007CA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u0005U!UmY5nC2\feoZ!dGVlW\u000f\\1u_JD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\bCJ<G+\u001f9f!\t)#&D\u0001'\u0015\t9\u0003&A\u0004m_\u001eL7-\u00197\u000b\u0005%2\u0011!\u0002;za\u0016\u001c\u0018BA\u0016'\u0005-!UmY5nC2$\u0016\u0010]3\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0002 \u0001!)1\u0005\fa\u0001I!)!\u0007\u0001C!g\u0005\t2M]3bi\u0016\f5mY;nk2\fGo\u001c:\u0015\u0003yAQ!\u000e\u0001\u0005\u0002Y\n!\"Y2dk6,H.\u0019;f)\r9Th\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0005+:LG\u000fC\u0003?i\u0001\u0007a$A\u0002bG\u000eDQ\u0001\u0011\u001bA\u0002\u0005\u000bQA^1mk\u0016\u0004\"\u0001\u000f\"\n\u0005\rK$aA!os\")Q\t\u0001C\u0001\r\u00069!/\u001a;sC\u000e$HcA\u001cH\u0011\")a\b\u0012a\u0001=!)\u0001\t\u0012a\u0001\u0003\")!\n\u0001C!\u0017\u0006Aq-\u001a;WC2,X\r\u0006\u0002\u0017\u0019\")a(\u0013a\u0001=!)a\n\u0001C\u0001\u001f\u0006)Q.\u001a:hKR\u0019q\u0007U)\t\u000byj\u0005\u0019\u0001\u0010\t\u000bIk\u0005\u0019A*\u0002\u0007%$8\u000fE\u0002U/zi\u0011!\u0016\u0006\u0003-j\tA\u0001\\1oO&\u0011\u0001,\u0016\u0002\t\u0013R,'/\u00192mK\")!\f\u0001C!7\u0006\u0011r-\u001a;BG\u000e,X.\u001e7bi>\u0014H+\u001f9f)\u0005a\u0006cA/e=5\taL\u0003\u0002`A\u0006AA/\u001f9fS:4wN\u0003\u0002bE\u000611m\\7n_:T!a\u0019\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002f=\nyA+\u001f9f\u0013:4wN]7bi&|g\u000eC\u0003h\u0001\u0011\u0005\u0001.\u0001\u0006hKR\u001cV/\u001c+za\u0016,\u0012\u0001\n\u0005\u0006U\u0002!\te[\u0001\u000eO\u0016$(+Z:vYR$\u0016\u0010]3\u0015\u00031\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u0013QL\b/Z;uS2\u001c(BA9\u0007\u0003\u001d\u0011XO\u001c;j[\u0016L!a\u001d8\u0003%\tKw\rR3dS6\fG\u000eV=qK&sgm\u001c")
public class DecimalAvgAggFunction
extends AggregateFunction<BigDecimal, DecimalAvgAccumulator> {
    private final DecimalType argType;

    public DecimalAvgAccumulator createAccumulator() {
        return new DecimalAvgAccumulator();
    }

    public void accumulate(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).add(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
        }
    }

    public void retract(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).subtract(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
        }
    }

    public BigDecimal getValue(DecimalAvgAccumulator acc) {
        return BoxesRunTime.unboxToLong((Object)acc.f1) == 0L ? null : ((BigDecimal)acc.f0).divide(BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)acc.f1)), MathContext.DECIMAL128);
    }

    public void merge(DecimalAvgAccumulator acc, Iterable<DecimalAvgAccumulator> its) {
        for (DecimalAvgAccumulator a : its) {
            acc.f0 = ((BigDecimal)acc.f0).add((BigDecimal)a.f0);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
        }
    }

    public TypeInformation<DecimalAvgAccumulator> getAccumulatorType() {
        DecimalType decimalType = this.getSumType();
        return new TupleTypeInfo(DecimalAvgAccumulator.class, new TypeInformation[]{new BigDecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()), Types.LONG()});
    }

    public DecimalType getSumType() {
        return (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)this.argType);
    }

    public BigDecimalTypeInfo getResultType() {
        DecimalType t = (DecimalType)LogicalTypeMerging.findAvgAggType((LogicalType)this.argType);
        return new BigDecimalTypeInfo(t.getPrecision(), t.getScale());
    }

    public DecimalAvgAggFunction(DecimalType argType) {
        this.argType = argType;
    }
}

