/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.ConnectTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.FileSystem;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.table.descriptors.OldCsv;
import org.apache.flink.table.descriptors.Schema;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class TestTableSourceSinks$ {
    public static final TestTableSourceSinks$ MODULE$;
    private String getPersonCsvPath;
    private String getOrdersCsvPath;
    private String getRatesCsvPath;
    private volatile byte bitmap$0;

    static {
        new TestTableSourceSinks$();
    }

    private String getPersonCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First#Id#Score#Last", "Mike#1#12.3#Smith", "Bob#2#45.6#Taylor", "Sam#3#7.89#Miller", "Peter#4#0.12#Smith", "% Just a comment", "Liz#5#34.5#Williams", "Sally#6#6.78#Miller", "Alice#7#90.1#Smith", "Kelly#8#2.34#Williams"}));
                this.getPersonCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.getPersonCsvPath;
        }
    }

    private String getOrdersCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,Euro,2", "1,US Dollar,3", "50,Yen,4", "3,Euro,5", "5,US Dollar,6"}));
                this.getOrdersCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-order-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.getOrdersCsvPath;
        }
    }

    private String getRatesCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"US Dollar,102", "Yen,1", "Euro,119", "RMB,702"}));
                this.getRatesCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-rate-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.getRatesCsvPath;
        }
    }

    public void createPersonCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        ((ConnectTableDescriptor)tEnv.connect((ConnectorDescriptor)new FileSystem().path(this.getPersonCsvPath())).withFormat((FormatDescriptor)new OldCsv().fieldDelimiter("#").lineDelimiter("$").ignoreFirstLine().commentPrefix("%"))).withSchema(new Schema().field("first", DataTypes.STRING()).field("id", DataTypes.INT()).field("score", DataTypes.DOUBLE()).field("last", DataTypes.STRING())).createTemporaryTable(tableName);
    }

    public void createOrdersCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        ((ConnectTableDescriptor)tEnv.connect((ConnectorDescriptor)new FileSystem().path(this.getOrdersCsvPath())).withFormat((FormatDescriptor)new OldCsv().fieldDelimiter(",").lineDelimiter("$"))).withSchema(new Schema().field("amount", DataTypes.BIGINT()).field("currency", DataTypes.STRING()).field("ts", DataTypes.BIGINT())).createTemporaryTable(tableName);
    }

    public void createRatesCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        ((ConnectTableDescriptor)tEnv.connect((ConnectorDescriptor)new FileSystem().path(this.getRatesCsvPath())).withFormat((FormatDescriptor)new OldCsv().fieldDelimiter(",").lineDelimiter("$"))).withSchema(new Schema().field("currency", DataTypes.STRING()).field("rate", DataTypes.BIGINT())).createTemporaryTable(tableName);
    }

    public String createCsvTemporarySinkTable(TableEnvironment tEnv, TableSchema schema, String tableName, int numFiles) {
        File tempFile = File.createTempFile("csv-test", null);
        tempFile.deleteOnExit();
        String path = tempFile.getAbsolutePath();
        ((ConnectTableDescriptor)tEnv.connect((ConnectorDescriptor)new FileSystem().path(path)).withFormat((FormatDescriptor)new OldCsv().writeMode("OVERWRITE").numFiles(numFiles))).withSchema(new Schema().schema(schema)).createTemporaryTable(tableName);
        return path;
    }

    public int createCsvTemporarySinkTable$default$4() {
        return 1;
    }

    public String getPersonCsvPath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.getPersonCsvPath$lzycompute() : this.getPersonCsvPath;
    }

    public String getOrdersCsvPath() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.getOrdersCsvPath$lzycompute() : this.getOrdersCsvPath;
    }

    public String getRatesCsvPath() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.getRatesCsvPath$lzycompute() : this.getRatesCsvPath;
    }

    private String writeToTempFile(String contents, String filePrefix, String fileSuffix, String charset) {
        File tempFile = File.createTempFile(filePrefix, fileSuffix);
        tempFile.deleteOnExit();
        OutputStreamWriter tmpWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), charset);
        tmpWriter.write(contents);
        tmpWriter.close();
        return tempFile.getAbsolutePath();
    }

    private String writeToTempFile$default$4() {
        return "UTF-8";
    }

    private TestTableSourceSinks$() {
        MODULE$ = this;
    }
}

