/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class SumWithRetractAggFunction
extends DeclarativeAggregateFunction {
    private UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef((String)"sum");
    private UnresolvedReferenceExpression count = ApiExpressionUtils.unresolvedRef((String)"count");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum, this.count};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType(), DataTypes.BIGINT()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType()), ExpressionBuilder.literal(0L)};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.operand(0), (Expression)ExpressionBuilder.plus((Expression)this.sum, (Expression)this.operand(0)))), ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.count, (Expression)ExpressionBuilder.plus((Expression)this.count, (Expression)ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)ExpressionBuilder.minus(this.zeroLiteral(), (Expression)this.operand(0)), (Expression)ExpressionBuilder.minus((Expression)this.sum, (Expression)this.operand(0)))), ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.count, (Expression)ExpressionBuilder.minus((Expression)this.count, (Expression)ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.mergeOperand(this.sum)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.mergeOperand(this.sum), (Expression)ExpressionBuilder.plus((Expression)this.sum, (Expression)this.mergeOperand(this.sum)))), ExpressionBuilder.plus((Expression)this.count, (Expression)this.mergeOperand(this.count))};
    }

    @Override
    public Expression getValueExpression() {
        return ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.equalTo((Expression)this.count, (Expression)ExpressionBuilder.literal(0L)), (Expression)ExpressionBuilder.nullOf(this.getResultType()), (Expression)this.sum);
    }

    protected abstract Expression zeroLiteral();

    public static class DecimalSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        private DecimalType decimalType;

        public DecimalSumWithRetractAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getResultType() {
            DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)this.decimalType);
            return DataTypes.DECIMAL((int)sumType.getPrecision(), (int)sumType.getScale());
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }
    }

    public static class DoubleSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0.0);
        }
    }

    public static class FloatSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(Float.valueOf(0.0f));
        }
    }

    public static class LongSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0L);
        }
    }

    public static class ShortSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((short)0);
        }
    }

    public static class ByteSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((byte)0);
        }
    }

    public static class IntSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }
    }
}

