/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.parse.ClearOperationParseStrategy;
import org.apache.flink.table.planner.parse.ExtendedParseStrategy;
import org.apache.flink.table.planner.parse.HelpOperationParseStrategy;
import org.apache.flink.table.planner.parse.QuitOperationParseStrategy;
import org.apache.flink.table.planner.parse.ResetOperationParseStrategy;
import org.apache.flink.table.planner.parse.SetOperationParseStrategy;

public class ExtendedParser {
    public static final ExtendedParser INSTANCE = new ExtendedParser();
    private static final List<ExtendedParseStrategy> PARSE_STRATEGIES = Arrays.asList(ClearOperationParseStrategy.INSTANCE, HelpOperationParseStrategy.INSTANCE, QuitOperationParseStrategy.INSTANCE, ResetOperationParseStrategy.INSTANCE, SetOperationParseStrategy.INSTANCE);

    public Optional<Operation> parse(String statement) {
        for (ExtendedParseStrategy strategy : PARSE_STRATEGIES) {
            if (!strategy.match(statement)) continue;
            return Optional.of(strategy.convert(statement));
        }
        return Optional.empty();
    }

    public String[] getCompletionHints(String statement, int cursor) {
        String normalizedStatement = statement.trim().toUpperCase();
        ArrayList<String> hints = new ArrayList<String>();
        for (ExtendedParseStrategy strategy : PARSE_STRATEGIES) {
            for (String hint : strategy.getHints()) {
                if (!hint.startsWith(normalizedStatement) || cursor >= hint.length()) continue;
                hints.add(this.getCompletionHint(normalizedStatement, hint));
            }
        }
        return hints.toArray(new String[0]);
    }

    private String getCompletionHint(String statement, String commandHint) {
        int returnStartPos;
        if (statement.length() == 0) {
            return commandHint;
        }
        int cursorPos = statement.length() - 1;
        if (Character.isWhitespace(commandHint.charAt(cursorPos + 1))) {
            returnStartPos = Math.min(commandHint.length() - 1, cursorPos + 2);
        } else {
            for (returnStartPos = cursorPos; returnStartPos > 0 && !Character.isWhitespace(commandHint.charAt(returnStartPos - 1)); --returnStartPos) {
            }
        }
        return commandHint.substring(returnStartPos);
    }
}

