/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.ExecNodeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ExecNodeBase<T>
implements ExecNode<T> {
    @JsonIgnore
    private final int id;
    @JsonIgnore
    private final String description;
    @JsonIgnore
    private final LogicalType outputType;
    @JsonIgnore
    private final List<InputProperty> inputProperties;
    @JsonIgnore
    private List<ExecEdge> inputEdges;
    @JsonIgnore
    private transient Transformation<T> transformation;
    private static Integer idCounter = 0;

    public static int getNewNodeId() {
        Integer n = idCounter;
        Integer n2 = idCounter = Integer.valueOf(idCounter + 1);
        return idCounter;
    }

    @VisibleForTesting
    public static void resetIdCounter() {
        idCounter = 0;
    }

    protected ExecNodeBase(int id, List<InputProperty> inputProperties, LogicalType outputType, String description) {
        this.id = id;
        this.inputProperties = (List)Preconditions.checkNotNull(inputProperties);
        this.outputType = (LogicalType)Preconditions.checkNotNull((Object)outputType);
        this.description = (String)Preconditions.checkNotNull((Object)description);
    }

    protected ExecNodeBase(List<InputProperty> inputProperties, LogicalType outputType, String description) {
        this(ExecNodeBase.getNewNodeId(), inputProperties, outputType, description);
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LogicalType getOutputType() {
        return this.outputType;
    }

    @Override
    public List<InputProperty> getInputProperties() {
        return this.inputProperties;
    }

    @Override
    public List<ExecEdge> getInputEdges() {
        return (List)Preconditions.checkNotNull(this.inputEdges, (String)"inputEdges should not null, please call `setInputEdges(List<ExecEdge>)` first.");
    }

    @Override
    public void setInputEdges(List<ExecEdge> inputEdges) {
        Preconditions.checkNotNull(inputEdges, (String)"inputEdges should not be null.");
        this.inputEdges = new ArrayList<ExecEdge>(inputEdges);
    }

    @Override
    public void replaceInputEdge(int index, ExecEdge newInputEdge) {
        List<ExecEdge> edges = this.getInputEdges();
        Preconditions.checkArgument((index >= 0 && index < edges.size() ? 1 : 0) != 0);
        edges.set(index, newInputEdge);
    }

    @Override
    public Transformation<T> translateToPlan(Planner planner) {
        if (this.transformation == null) {
            this.transformation = this.translateToPlanInternal((PlannerBase)planner);
            if (this instanceof SingleTransformationTranslator && this.inputsContainSingleton()) {
                this.transformation.setParallelism(1);
                this.transformation.setMaxParallelism(1);
            }
        }
        return this.transformation;
    }

    protected abstract Transformation<T> translateToPlanInternal(PlannerBase var1);

    @Override
    public void accept(ExecNodeVisitor visitor) {
        visitor.visit(this);
    }

    protected boolean inputsContainSingleton() {
        return this.getInputEdges().stream().map(ExecEdge::getSource).anyMatch(i -> i instanceof CommonExecExchange && i.getInputProperties().get(0).getRequiredDistribution().getType() == InputProperty.DistributionType.SINGLETON);
    }
}

