/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;

@Internal
public class JoinedRowData
implements RowData {
    private RowKind rowKind = RowKind.INSERT;
    private RowData row1;
    private RowData row2;

    public JoinedRowData() {
    }

    public JoinedRowData(RowData row1, RowData row2) {
        this.row1 = row1;
        this.row2 = row2;
    }

    public JoinedRowData replace(RowData row1, RowData row2) {
        this.row1 = row1;
        this.row2 = row2;
        return this;
    }

    public int getArity() {
        return this.row1.getArity() + this.row2.getArity();
    }

    public RowKind getRowKind() {
        return this.rowKind;
    }

    public void setRowKind(RowKind kind) {
        this.rowKind = kind;
    }

    public boolean isNullAt(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.isNullAt(pos);
        }
        return this.row2.isNullAt(pos - this.row1.getArity());
    }

    public boolean getBoolean(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getBoolean(pos);
        }
        return this.row2.getBoolean(pos - this.row1.getArity());
    }

    public byte getByte(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getByte(pos);
        }
        return this.row2.getByte(pos - this.row1.getArity());
    }

    public short getShort(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getShort(pos);
        }
        return this.row2.getShort(pos - this.row1.getArity());
    }

    public int getInt(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getInt(pos);
        }
        return this.row2.getInt(pos - this.row1.getArity());
    }

    public long getLong(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getLong(pos);
        }
        return this.row2.getLong(pos - this.row1.getArity());
    }

    public float getFloat(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getFloat(pos);
        }
        return this.row2.getFloat(pos - this.row1.getArity());
    }

    public double getDouble(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getDouble(pos);
        }
        return this.row2.getDouble(pos - this.row1.getArity());
    }

    public StringData getString(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getString(pos);
        }
        return this.row2.getString(pos - this.row1.getArity());
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        if (pos < this.row1.getArity()) {
            return this.row1.getDecimal(pos, precision, scale);
        }
        return this.row2.getDecimal(pos - this.row1.getArity(), precision, scale);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        if (pos < this.row1.getArity()) {
            return this.row1.getTimestamp(pos, precision);
        }
        return this.row2.getTimestamp(pos - this.row1.getArity(), precision);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getRawValue(pos);
        }
        return this.row2.getRawValue(pos - this.row1.getArity());
    }

    public byte[] getBinary(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getBinary(pos);
        }
        return this.row2.getBinary(pos - this.row1.getArity());
    }

    public ArrayData getArray(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getArray(pos);
        }
        return this.row2.getArray(pos - this.row1.getArity());
    }

    public MapData getMap(int pos) {
        if (pos < this.row1.getArity()) {
            return this.row1.getMap(pos);
        }
        return this.row2.getMap(pos - this.row1.getArity());
    }

    public RowData getRow(int pos, int numFields) {
        if (pos < this.row1.getArity()) {
            return this.row1.getRow(pos, numFields);
        }
        return this.row2.getRow(pos - this.row1.getArity(), numFields);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("JoinedRowData do not support equals, please compare fields one by one!");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("JoinedRowData do not support hashCode, please hash fields one by one!");
    }

    public String toString() {
        return this.rowKind.shortString() + "{row1=" + this.row1 + ", row2=" + this.row2 + '}';
    }
}

