/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.util;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;

public final class RowDataUtil {
    public static boolean isAccumulateMsg(RowData row) {
        RowKind kind = row.getRowKind();
        return kind == RowKind.INSERT || kind == RowKind.UPDATE_AFTER;
    }

    public static boolean isRetractMsg(RowData row) {
        RowKind kind = row.getRowKind();
        return kind == RowKind.UPDATE_BEFORE || kind == RowKind.DELETE;
    }

    public static GenericRowData toGenericRow(RowData row, LogicalType[] types) {
        if (row instanceof GenericRowData) {
            return (GenericRowData)row;
        }
        GenericRowData newRow = new GenericRowData(row.getArity());
        newRow.setRowKind(row.getRowKind());
        for (int i = 0; i < row.getArity(); ++i) {
            if (row.isNullAt(i)) {
                newRow.setField(i, null);
                continue;
            }
            newRow.setField(i, RowData.get((RowData)row, (int)i, (LogicalType)types[i]));
        }
        return newRow;
    }
}

