/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.connector.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.connector.sink.DataStructureConverterWrapper;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class SinkRuntimeProviderContext
implements DynamicTableSink.Context {
    private final boolean isBounded;

    public SinkRuntimeProviderContext(boolean isBounded) {
        this.isBounded = isBounded;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public TypeInformation<?> createTypeInformation(DataType consumedDataType) {
        DataType internalDataType = DataTypeUtils.transform((DataType)consumedDataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.TO_INTERNAL_CLASS});
        return TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(internalDataType);
    }

    public DynamicTableSink.DataStructureConverter createDataStructureConverter(DataType consumedDataType) {
        return new DataStructureConverterWrapper(DataStructureConverters.getConverter(consumedDataType));
    }
}

