/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.table.dataview.ListViewTypeInfo;
import org.apache.flink.table.dataview.MapViewTypeInfo;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.dataview.StateListView;
import org.apache.flink.table.runtime.dataview.StateMapView;

public class PerWindowStateDataViewStore
implements StateDataViewStore {
    private static final String NULL_STATE_POSTFIX = "_null_state";
    private final KeyedStateBackend<?> keyedStateBackend;
    private final TypeSerializer<?> windowSerializer;
    private final RuntimeContext ctx;

    public PerWindowStateDataViewStore(KeyedStateBackend<?> keyedStateBackend, TypeSerializer<?> windowSerializer, RuntimeContext runtimeContext) {
        this.keyedStateBackend = keyedStateBackend;
        this.windowSerializer = windowSerializer;
        this.ctx = runtimeContext;
    }

    @Override
    public <N, UK, UV> StateMapView<N, UK, UV> getStateMapView(String stateName, MapViewTypeInfo<UK, UV> mapViewTypeInfo) throws Exception {
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor(stateName, mapViewTypeInfo.getKeyType(), mapViewTypeInfo.getValueType());
        MapState mapState = (MapState)this.keyedStateBackend.getOrCreateKeyedState(this.windowSerializer, (StateDescriptor)mapStateDescriptor);
        InternalMapState internalMapState = (InternalMapState)mapState;
        if (mapViewTypeInfo.isNullAware()) {
            ValueStateDescriptor nullStateDescriptor = new ValueStateDescriptor(stateName + NULL_STATE_POSTFIX, mapViewTypeInfo.getValueType());
            ValueState nullState = (ValueState)this.keyedStateBackend.getOrCreateKeyedState(this.windowSerializer, (StateDescriptor)nullStateDescriptor);
            InternalValueState internalNullState = (InternalValueState)nullState;
            return new StateMapView.NamespacedStateMapViewWithKeysNullable(internalMapState, internalNullState);
        }
        return new StateMapView.NamespacedStateMapViewWithKeysNotNull(internalMapState);
    }

    @Override
    public <N, V> StateListView<N, V> getStateListView(String stateName, ListViewTypeInfo<V> listViewTypeInfo) throws Exception {
        ListStateDescriptor listStateDesc = new ListStateDescriptor(stateName, listViewTypeInfo.getElementType());
        ListState listState = (ListState)this.keyedStateBackend.getOrCreateKeyedState(this.windowSerializer, (StateDescriptor)listStateDesc);
        InternalListState internalListState = (InternalListState)listState;
        return new StateListView.NamespacedStateListView(internalListState);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.ctx;
    }
}

