/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.util.StateTtlConfigUtil;
import org.apache.flink.util.Collector;

public class DeduplicateKeepFirstRowFunction
extends KeyedProcessFunction<RowData, RowData, RowData> {
    private static final long serialVersionUID = 5865777137707602549L;
    private final long minRetentionTime;
    private ValueState<Boolean> state;

    public DeduplicateKeepFirstRowFunction(long minRetentionTime) {
        this.minRetentionTime = minRetentionTime;
    }

    public void open(Configuration configure) throws Exception {
        super.open(configure);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("existsState", Types.BOOLEAN);
        StateTtlConfig ttlConfig = StateTtlConfigUtil.createTtlConfig(this.minRetentionTime);
        if (ttlConfig.isEnabled()) {
            stateDesc.enableTimeToLive(ttlConfig);
        }
        this.state = this.getRuntimeContext().getState(stateDesc);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        DeduplicateFunctionHelper.processFirstRow(input, this.state, out);
    }
}

