/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.state;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.util.Preconditions;

public class JoinInputSideSpec
implements Serializable {
    private static final long serialVersionUID = 3178408082297179959L;
    private final boolean inputSideHasUniqueKey;
    private final boolean joinKeyContainsUniqueKey;
    @Nullable
    private final RowDataTypeInfo uniqueKeyType;
    @Nullable
    private final KeySelector<RowData, RowData> uniqueKeySelector;

    private JoinInputSideSpec(boolean joinKeyContainsUniqueKey, @Nullable RowDataTypeInfo uniqueKeyType, @Nullable KeySelector<RowData, RowData> uniqueKeySelector) {
        this.inputSideHasUniqueKey = uniqueKeyType != null && uniqueKeySelector != null;
        this.joinKeyContainsUniqueKey = joinKeyContainsUniqueKey;
        this.uniqueKeyType = uniqueKeyType;
        this.uniqueKeySelector = uniqueKeySelector;
    }

    public boolean hasUniqueKey() {
        return this.inputSideHasUniqueKey;
    }

    public boolean joinKeyContainsUniqueKey() {
        return this.joinKeyContainsUniqueKey;
    }

    @Nullable
    public RowDataTypeInfo getUniqueKeyType() {
        return this.uniqueKeyType;
    }

    @Nullable
    public KeySelector<RowData, RowData> getUniqueKeySelector() {
        return this.uniqueKeySelector;
    }

    public static JoinInputSideSpec withUniqueKey(RowDataTypeInfo uniqueKeyType, KeySelector<RowData, RowData> uniqueKeySelector) {
        Preconditions.checkNotNull((Object)((Object)uniqueKeyType));
        Preconditions.checkNotNull(uniqueKeySelector);
        return new JoinInputSideSpec(false, uniqueKeyType, uniqueKeySelector);
    }

    public static JoinInputSideSpec withUniqueKeyContainedByJoinKey(RowDataTypeInfo uniqueKeyType, KeySelector<RowData, RowData> uniqueKeySelector) {
        Preconditions.checkNotNull((Object)((Object)uniqueKeyType));
        Preconditions.checkNotNull(uniqueKeySelector);
        return new JoinInputSideSpec(true, uniqueKeyType, uniqueKeySelector);
    }

    public static JoinInputSideSpec withoutUniqueKey() {
        return new JoinInputSideSpec(false, null, null);
    }

    public String toString() {
        if (this.inputSideHasUniqueKey) {
            if (this.joinKeyContainsUniqueKey) {
                return "JoinKeyContainsUniqueKey";
            }
            return "HasUniqueKey";
        }
        return "NoUniqueKey";
    }
}

