/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.triggers;

import java.io.Serializable;
import org.apache.flink.api.common.state.MergingState;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.runtime.operators.window.Window;

public abstract class Trigger<W extends Window>
implements Serializable {
    private static final long serialVersionUID = -4104633972991191369L;

    public abstract void open(TriggerContext var1) throws Exception;

    public abstract boolean onElement(Object var1, long var2, W var4) throws Exception;

    public abstract boolean onProcessingTime(long var1, W var3) throws Exception;

    public abstract boolean onEventTime(long var1, W var3) throws Exception;

    public boolean canMerge() {
        return false;
    }

    public void onMerge(W window, OnMergeContext mergeContext) throws Exception {
        throw new UnsupportedOperationException("This trigger does not support merging.");
    }

    public abstract void clear(W var1) throws Exception;

    public static interface OnMergeContext
    extends TriggerContext {
        public <S extends MergingState<?, ?>> void mergePartitionedState(StateDescriptor<S, ?> var1);
    }

    public static interface TriggerContext {
        public long getCurrentProcessingTime();

        public MetricGroup getMetricGroup();

        public long getCurrentWatermark();

        public void registerProcessingTimeTimer(long var1);

        public void registerEventTimeTimer(long var1);

        public void deleteProcessingTimeTimer(long var1);

        public void deleteEventTimeTimer(long var1);

        public <S extends State> S getPartitionedState(StateDescriptor<S, ?> var1);
    }
}

