/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;

public class Strong {
    private static final Map<SqlKind, Policy> MAP = Strong.createPolicyMap();

    public static Strong of(final ImmutableBitSet nullColumns) {
        return new Strong(){

            @Override
            public boolean isNull(RexInputRef ref) {
                return nullColumns.get(ref.getIndex());
            }
        };
    }

    public static boolean isNull(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).isNull(node);
    }

    public static boolean isNotTrue(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).isNotTrue(node);
    }

    public static Policy policy(SqlKind kind) {
        return Objects.requireNonNull(MAP.get((Object)kind), kind.toString());
    }

    public boolean isNotTrue(RexNode node) {
        switch (node.getKind()) {
            case IS_NOT_NULL: {
                return this.anyNull(((RexCall)node).getOperands());
            }
        }
        return this.isNull(node);
    }

    public boolean isNull(RexNode node) {
        Policy policy = MAP.get((Object)node.getKind());
        switch (policy) {
            case NOT_NULL: {
                return false;
            }
            case ANY: {
                return this.anyNull(((RexCall)node).getOperands());
            }
        }
        switch (node.getKind()) {
            case LITERAL: {
                return ((RexLiteral)node).isNull();
            }
            case AND: 
            case OR: 
            case COALESCE: {
                return this.allNull(((RexCall)node).getOperands());
            }
            case NULLIF: {
                return this.allNull(ImmutableList.of(((RexCall)node).getOperands().get(0)));
            }
            case INPUT_REF: {
                return this.isNull((RexInputRef)node);
            }
            case CASE: {
                RexCall caseCall = (RexCall)node;
                ArrayList<RexNode> caseValues = new ArrayList<RexNode>();
                for (int i = 0; i < caseCall.getOperands().size(); ++i) {
                    if (RexUtil.isCasePredicate(caseCall, i)) continue;
                    caseValues.add(caseCall.getOperands().get(i));
                }
                return this.allNull(caseValues);
            }
        }
        return false;
    }

    public boolean isNull(RexInputRef ref) {
        return false;
    }

    private boolean allNull(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (this.isNull(operand)) continue;
            return false;
        }
        return true;
    }

    private boolean anyNull(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (!this.isNull(operand)) continue;
            return true;
        }
        return false;
    }

    private static Map<SqlKind, Policy> createPolicyMap() {
        EnumMap<SqlKind, Policy> map2 = new EnumMap<SqlKind, Policy>(SqlKind.class);
        map2.put(SqlKind.INPUT_REF, Policy.AS_IS);
        map2.put(SqlKind.LOCAL_REF, Policy.AS_IS);
        map2.put(SqlKind.DYNAMIC_PARAM, Policy.AS_IS);
        map2.put(SqlKind.OTHER_FUNCTION, Policy.AS_IS);
        map2.put(SqlKind.CASE, Policy.AS_IS);
        map2.put(SqlKind.DECODE, Policy.AS_IS);
        map2.put(SqlKind.NULLIF, Policy.AS_IS);
        map2.put(SqlKind.COALESCE, Policy.AS_IS);
        map2.put(SqlKind.NVL, Policy.AS_IS);
        map2.put(SqlKind.AND, Policy.AS_IS);
        map2.put(SqlKind.OR, Policy.AS_IS);
        map2.put(SqlKind.LITERAL, Policy.CUSTOM);
        map2.put(SqlKind.EXISTS, Policy.NOT_NULL);
        map2.put(SqlKind.IS_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NULL, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_NULL, Policy.NOT_NULL);
        map2.put(SqlKind.IS_TRUE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_TRUE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_FALSE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_FALSE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.NOT, Policy.ANY);
        map2.put(SqlKind.EQUALS, Policy.ANY);
        map2.put(SqlKind.NOT_EQUALS, Policy.ANY);
        map2.put(SqlKind.LESS_THAN, Policy.ANY);
        map2.put(SqlKind.LESS_THAN_OR_EQUAL, Policy.ANY);
        map2.put(SqlKind.GREATER_THAN, Policy.ANY);
        map2.put(SqlKind.GREATER_THAN_OR_EQUAL, Policy.ANY);
        map2.put(SqlKind.LIKE, Policy.ANY);
        map2.put(SqlKind.SIMILAR, Policy.ANY);
        map2.put(SqlKind.PLUS_PREFIX, Policy.ANY);
        map2.put(SqlKind.MINUS_PREFIX, Policy.ANY);
        map2.put(SqlKind.PLUS, Policy.ANY);
        map2.put(SqlKind.PLUS_PREFIX, Policy.ANY);
        map2.put(SqlKind.MINUS, Policy.ANY);
        map2.put(SqlKind.MINUS_PREFIX, Policy.ANY);
        map2.put(SqlKind.TIMES, Policy.ANY);
        map2.put(SqlKind.DIVIDE, Policy.ANY);
        map2.put(SqlKind.CAST, Policy.ANY);
        map2.put(SqlKind.REINTERPRET, Policy.ANY);
        map2.put(SqlKind.TRIM, Policy.ANY);
        map2.put(SqlKind.LTRIM, Policy.ANY);
        map2.put(SqlKind.RTRIM, Policy.ANY);
        map2.put(SqlKind.CEIL, Policy.ANY);
        map2.put(SqlKind.FLOOR, Policy.ANY);
        map2.put(SqlKind.EXTRACT, Policy.ANY);
        map2.put(SqlKind.GREATEST, Policy.ANY);
        map2.put(SqlKind.LEAST, Policy.ANY);
        map2.put(SqlKind.TIMESTAMP_ADD, Policy.ANY);
        map2.put(SqlKind.TIMESTAMP_DIFF, Policy.ANY);
        for (SqlKind k : Iterables.concat(SqlKind.EXPRESSION, SqlKind.AGGREGATE)) {
            if (map2.containsKey((Object)k)) continue;
            map2.put(k, Policy.AS_IS);
        }
        return map2;
    }

    public static enum Policy {
        NOT_NULL,
        CUSTOM,
        ANY,
        AS_IS;

    }
}

