/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSetMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.SetMultimap;

public class SqlCastFunction
extends SqlFunction {
    private final SetMultimap<SqlTypeFamily, SqlTypeFamily> nonMonotonicCasts = ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().put(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.APPROXIMATE_NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.EXACT_NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.APPROXIMATE_NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.DATETIME_INTERVAL)).put(SqlTypeFamily.DATETIME, SqlTypeFamily.TIME)).put(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIME)).put(SqlTypeFamily.TIME, SqlTypeFamily.DATETIME)).put(SqlTypeFamily.TIME, SqlTypeFamily.TIMESTAMP)).build();

    public SqlCastFunction() {
        super("CAST", SqlKind.CAST, null, InferTypes.FIRST_KNOWN, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        SqlCallBinding callBinding;
        SqlNode operand0;
        assert (opBinding.getOperandCount() == 2);
        RelDataType ret = opBinding.getOperandType(1);
        RelDataType firstType = opBinding.getOperandType(0);
        ret = opBinding.getTypeFactory().createTypeWithNullability(ret, firstType.isNullable());
        if (opBinding instanceof SqlCallBinding && ((operand0 = (callBinding = (SqlCallBinding)opBinding).operand(0)) instanceof SqlLiteral && ((SqlLiteral)operand0).getValue() == null || operand0 instanceof SqlDynamicParam)) {
            SqlValidatorImpl validator = (SqlValidatorImpl)callBinding.getValidator();
            validator.setValidatedNodeType(operand0, ret);
        }
        return ret;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 2);
        return "{0}({1} AS {2})";
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (SqlUtil.isNullLiteral(left, false) || left instanceof SqlDynamicParam) {
            return true;
        }
        RelDataType validatedNodeType = callBinding.getValidator().getValidatedNodeType(left);
        RelDataType returnType = callBinding.getValidator().deriveType(callBinding.getScope(), right);
        if (!SqlTypeUtil.canCastFrom(returnType, validatedNodeType, true)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.toString(), returnType.toString()));
            }
            return false;
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(validatedNodeType, returnType)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.getFullTypeString(), returnType.getFullTypeString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep("AS");
        if (call.operand(1) instanceof SqlIntervalQualifier) {
            writer.sep("INTERVAL");
        }
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        RelDataTypeFamily castFrom = call.getOperandType(0).getFamily();
        RelDataTypeFamily castTo = call.getOperandType(1).getFamily();
        if (castFrom instanceof SqlTypeFamily && castTo instanceof SqlTypeFamily && this.nonMonotonicCasts.containsEntry(castFrom, castTo)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return call.getOperandMonotonicity(0);
    }
}

