/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry;

import org.apache.flink.calcite.shaded.com.esri.core.geometry.AttributeStreamOfInt32;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.EditShape;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Envelope2D;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.IndexHashTable;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.IndexMultiList;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.NumberUtils;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Point;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Point2D;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.StridedIndexTypeCollection;

final class Clusterer {
    Point2D m_origin = new Point2D();
    double m_tolerance;
    double m_sqr_tolerance;
    double m_cell_size;
    double m_inv_cell_size;
    int[] m_bucket_array = new int[4];
    int[] m_bucket_hash = new int[4];
    int m_dbg_candidate_check_count = 0;
    int m_hash_values = -1;
    int m_new_clusters = -1;
    EditShape m_shape;
    IndexMultiList m_clusters;
    ClusterHashFunction m_hash_function;
    IndexHashTable m_hash_table;

    static boolean executeNonReciprocal(EditShape shape, double tolerance) {
        Clusterer clusterer = new Clusterer();
        clusterer.m_shape = shape;
        clusterer.m_tolerance = tolerance;
        clusterer.m_sqr_tolerance = tolerance * tolerance;
        clusterer.m_cell_size = 2.0 * tolerance;
        clusterer.m_inv_cell_size = 1.0 / clusterer.m_cell_size;
        return clusterer.clusterNonReciprocal_();
    }

    static boolean isClusterCandidate_(double x_1, double y1, double x2, double y2, double sqr_tolerance) {
        double dx = x_1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy <= sqr_tolerance;
    }

    static int hashFunction_(int xi, int yi) {
        int h = NumberUtils.hash(xi);
        return NumberUtils.hash(h, yi);
    }

    void getNearestNeighbourCandidate_(int xyindex, Point2D pointOfInterest, int bucket_ptr, ClusterCandidate candidate) {
        candidate.vertex = -1;
        candidate.distance = NumberUtils.doubleMax();
        Point2D pt = new Point2D();
        int node = bucket_ptr;
        while (node != -1) {
            int xyind = this.m_hash_table.getElement(node);
            if (xyindex != xyind) {
                this.m_shape.getXY(xyind, pt);
                if (Clusterer.isClusterCandidate_(pointOfInterest.x, pointOfInterest.y, pt.x, pt.y, this.m_sqr_tolerance)) {
                    pt.sub(pointOfInterest);
                    double l = pt.length();
                    if (l < candidate.distance) {
                        candidate.distance = l;
                        candidate.vertex = xyind;
                    }
                }
            }
            node = this.m_hash_table.getNextInBucket(node);
        }
    }

    void findClusterCandidate_(int xyindex, ClusterCandidate candidate) {
        Point2D pointOfInterest = new Point2D();
        this.m_shape.getXY(xyindex, pointOfInterest);
        double x_0 = pointOfInterest.x - this.m_origin.x;
        double x = x_0 * this.m_inv_cell_size;
        double y0 = pointOfInterest.y - this.m_origin.y;
        double y = y0 * this.m_inv_cell_size;
        int xi = (int)x;
        int yi = (int)y;
        candidate.vertex = -1;
        candidate.distance = NumberUtils.doubleMax();
        ClusterCandidate c = new ClusterCandidate();
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                int bucket_ptr = this.m_hash_table.getFirstInBucket(Clusterer.hashFunction_(xi + dx, yi + dy));
                if (bucket_ptr == IndexHashTable.nullNode()) continue;
                this.getNearestNeighbourCandidate_(xyindex, pointOfInterest, bucket_ptr, c);
                if (c.vertex == IndexHashTable.nullNode() || !(c.distance < candidate.distance)) continue;
                candidate = c;
            }
        }
    }

    void collectClusterCandidates_(int xyindex, AttributeStreamOfInt32 candidates) {
        Point2D pointOfInterest = new Point2D();
        this.m_shape.getXY(xyindex, pointOfInterest);
        double x_0 = pointOfInterest.x - this.m_origin.x;
        double x = x_0 * this.m_inv_cell_size;
        double y0 = pointOfInterest.y - this.m_origin.y;
        double y = y0 * this.m_inv_cell_size;
        int xi = (int)x;
        int yi = (int)y;
        int bucket_count = 0;
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                int hash = Clusterer.hashFunction_(xi + dx, yi + dy);
                int bucket_ptr = this.m_hash_table.getFirstInBucket(hash);
                if (bucket_ptr == -1) continue;
                this.m_bucket_array[bucket_count] = bucket_ptr;
                this.m_bucket_hash[bucket_count] = hash;
                ++bucket_count;
            }
        }
        block2: for (int j2 = bucket_count - 1; j2 >= 1; --j2) {
            int bucket_ptr = this.m_bucket_array[j2];
            for (int i = j2 - 1; i >= 0; --i) {
                if (bucket_ptr != this.m_bucket_array[i]) continue;
                this.m_bucket_hash[i] = -1;
                if (j2 == --bucket_count) continue block2;
                this.m_bucket_hash[j2] = this.m_bucket_hash[bucket_count];
                this.m_bucket_array[j2] = this.m_bucket_array[bucket_count];
                continue block2;
            }
        }
        for (int i = 0; i < bucket_count; ++i) {
            this.collectNearestNeighbourCandidates_(xyindex, this.m_bucket_hash[i], pointOfInterest, this.m_bucket_array[i], candidates);
        }
    }

    void collectNearestNeighbourCandidates_(int xyindex, int hash, Point2D pointOfInterest, int bucket_ptr, AttributeStreamOfInt32 candidates) {
        Point2D pt = new Point2D();
        int node = bucket_ptr;
        while (node != -1) {
            int xyind = this.m_hash_table.getElement(node);
            if (xyindex != xyind && (hash == -1 || this.m_shape.getUserIndex(xyind, this.m_hash_values) == hash)) {
                this.m_shape.getXY(xyind, pt);
                ++this.m_dbg_candidate_check_count;
                if (Clusterer.isClusterCandidate_(pointOfInterest.x, pointOfInterest.y, pt.x, pt.y, this.m_sqr_tolerance)) {
                    candidates.add(node);
                }
            }
            node = this.m_hash_table.getNextInBucket(node);
        }
    }

    boolean mergeClusters_(int vertex1, int vertex2, boolean update_hash) {
        int cluster_1 = this.m_shape.getUserIndex(vertex1, this.m_new_clusters);
        int cluster_2 = this.m_shape.getUserIndex(vertex2, this.m_new_clusters);
        assert (cluster_1 != StridedIndexTypeCollection.impossibleIndex2());
        assert (cluster_2 != StridedIndexTypeCollection.impossibleIndex2());
        if (cluster_1 == -1) {
            cluster_1 = this.m_clusters.createList();
            this.m_clusters.addElement(cluster_1, vertex1);
            this.m_shape.setUserIndex(vertex1, this.m_new_clusters, cluster_1);
        }
        if (cluster_2 == -1) {
            this.m_clusters.addElement(cluster_1, vertex2);
        } else {
            this.m_clusters.concatenateLists(cluster_1, cluster_2);
        }
        this.m_shape.setUserIndex(vertex2, this.m_new_clusters, StridedIndexTypeCollection.impossibleIndex2());
        boolean res = this.mergeVertices_(vertex1, vertex2);
        if (update_hash) {
            int hash = this.m_hash_function.calculate_hash_from_vertex(vertex1);
            this.m_shape.setUserIndex(vertex1, this.m_hash_values, hash);
        }
        return res;
    }

    static boolean mergeVertices(Point pt_1, Point pt_2, double w_1, int rank_1, double w_2, int rank_2, Point pt_res, double[] w_res, int[] rank_res) {
        assert (!pt_1.isEmpty() && !pt_2.isEmpty());
        boolean res = pt_1.equals(pt_2);
        if (rank_1 > rank_2) {
            pt_res = pt_1;
            if (w_res != null) {
                rank_res[0] = rank_1;
                w_res[0] = w_1;
            }
            return res;
        }
        if (rank_2 > rank_1) {
            pt_res = pt_2;
            if (w_res != null) {
                rank_res[0] = rank_1;
                w_res[0] = w_1;
            }
            return res;
        }
        pt_res = pt_1;
        Point2D pt2d = new Point2D();
        Clusterer.mergeVertices2D(pt_1.getXY(), pt_2.getXY(), w_1, rank_1, w_2, rank_2, pt2d, w_res, rank_res);
        pt_res.setXY(pt2d);
        return res;
    }

    static boolean mergeVertices2D(Point2D pt_1, Point2D pt_2, double w_1, int rank_1, double w_2, int rank_2, Point2D pt_res, double[] w_res, int[] rank_res) {
        double w = w_1 + w_2;
        boolean r = false;
        double x = pt_1.x;
        if (pt_1.x != pt_2.x) {
            if (rank_1 == rank_2) {
                x = (pt_1.x * w_1 + pt_2.x * w_2) / w;
            }
            r = true;
        }
        double y = pt_1.y;
        if (pt_1.y != pt_2.y) {
            if (rank_1 == rank_2) {
                y = (pt_1.y * w_1 + pt_2.y * w_2) / w;
            }
            r = true;
        }
        if (rank_1 != rank_2) {
            if (rank_1 > rank_2) {
                if (w_res != null) {
                    rank_res[0] = rank_1;
                    w_res[0] = w_1;
                }
                pt_res = pt_1;
            } else {
                if (w_res != null) {
                    rank_res[0] = rank_2;
                    w_res[0] = w_2;
                }
                pt_res = pt_2;
            }
        } else {
            pt_res.setCoords(x, y);
            if (w_res != null) {
                w_res[0] = w;
                rank_res[0] = rank_1;
            }
        }
        return r;
    }

    boolean mergeVertices_(int vert_1, int vert_2) {
        Point2D pt_1 = new Point2D();
        this.m_shape.getXY(vert_1, pt_1);
        Point2D pt_2 = new Point2D();
        this.m_shape.getXY(vert_2, pt_2);
        double w_1 = this.m_shape.getWeight(vert_1);
        double w_2 = this.m_shape.getWeight(vert_2);
        double w = w_1 + w_2;
        int r = 0;
        double x = pt_1.x;
        if (pt_1.x != pt_2.x) {
            x = (pt_1.x * w_1 + pt_2.x * w_2) / w;
            ++r;
        }
        double y = pt_1.y;
        if (pt_1.y != pt_2.y) {
            y = (pt_1.y * w_1 + pt_2.y * w_2) / w;
            ++r;
        }
        if (r > 0) {
            this.m_shape.setXY(vert_1, x, y);
        }
        this.m_shape.setWeight(vert_1, w);
        return r != 0;
    }

    boolean clusterNonReciprocal_() {
        int point_count = this.m_shape.getTotalPointCount();
        Envelope2D env = this.m_shape.getEnvelope2D();
        this.m_origin = env.getLowerLeft();
        double dim = Math.max(env.getHeight(), env.getWidth());
        double mincell = dim / (double)(NumberUtils.intMax() - 1);
        if (this.m_cell_size < mincell) {
            this.m_cell_size = mincell;
            this.m_inv_cell_size = 1.0 / this.m_cell_size;
        }
        this.m_clusters = new IndexMultiList();
        this.m_clusters.reserveLists(this.m_shape.getTotalPointCount() / 3 + 1);
        this.m_clusters.reserveNodes(this.m_shape.getTotalPointCount() / 3 + 1);
        this.m_hash_values = this.m_shape.createUserIndex();
        this.m_new_clusters = this.m_shape.createUserIndex();
        this.m_hash_function = new ClusterHashFunction(this.m_shape, this.m_origin, this.m_sqr_tolerance, this.m_inv_cell_size, this.m_hash_values);
        this.m_hash_table = new IndexHashTable(4 * point_count / 3, this.m_hash_function);
        this.m_hash_table.reserveElements(this.m_shape.getTotalPointCount());
        boolean b_clustered = false;
        int geometry = this.m_shape.getFirstGeometry();
        while (geometry != -1) {
            int path = this.m_shape.getFirstPath(geometry);
            while (path != -1) {
                int vertex = this.m_shape.getFirstVertex(path);
                int nindex = this.m_shape.getPathSize(path);
                for (int index = 0; index < nindex; ++index) {
                    assert (vertex != -1);
                    int hash = this.m_hash_function.calculate_hash_from_vertex(vertex);
                    this.m_shape.setUserIndex(vertex, this.m_hash_values, hash);
                    this.m_hash_table.addElement(vertex, hash);
                    assert (this.m_shape.getUserIndex(vertex, this.m_new_clusters) == -1);
                    vertex = this.m_shape.getNextVertex(vertex);
                }
                path = this.m_shape.getNextPath(path);
            }
            geometry = this.m_shape.getNextGeometry(geometry);
        }
        AttributeStreamOfInt32 candidates = new AttributeStreamOfInt32(0);
        candidates.reserve(10);
        int geometry2 = this.m_shape.getFirstGeometry();
        while (geometry2 != -1) {
            int path = this.m_shape.getFirstPath(geometry2);
            while (path != -1) {
                int vertex = this.m_shape.getFirstVertex(path);
                int nindex = this.m_shape.getPathSize(path);
                for (int index = 0; index < nindex; ++index) {
                    boolean clustered;
                    if (this.m_shape.getUserIndex(vertex, this.m_new_clusters) == StridedIndexTypeCollection.impossibleIndex2()) {
                        vertex = this.m_shape.getNextVertex(vertex);
                        continue;
                    }
                    int hash = this.m_shape.getUserIndex(vertex, this.m_hash_values);
                    this.m_hash_table.deleteElement(vertex, hash);
                    do {
                        this.collectClusterCandidates_(vertex, candidates);
                        if (candidates.size() == 0) break;
                        clustered = false;
                        int ncandidates = candidates.size();
                        for (int candidate_index = 0; candidate_index < ncandidates; ++candidate_index) {
                            int cluster_node = candidates.get(candidate_index);
                            int other_vertex = this.m_hash_table.getElement(cluster_node);
                            this.m_hash_table.deleteNode(cluster_node);
                            clustered |= this.mergeClusters_(vertex, other_vertex, candidate_index + 1 == ncandidates);
                        }
                        b_clustered |= clustered;
                        candidates.clear(false);
                    } while (clustered);
                    vertex = this.m_shape.getNextVertex(vertex);
                }
                path = this.m_shape.getNextPath(path);
            }
            geometry2 = this.m_shape.getNextGeometry(geometry2);
        }
        if (b_clustered) {
            this.applyClusterPositions_();
        }
        this.m_hash_table = null;
        this.m_hash_function = null;
        this.m_shape.removeUserIndex(this.m_hash_values);
        this.m_shape.removeUserIndex(this.m_new_clusters);
        return b_clustered;
    }

    void applyClusterPositions_() {
        Point2D cluster_pt = new Point2D();
        int list = this.m_clusters.getFirstList();
        while (list != -1) {
            int node = this.m_clusters.getFirst(list);
            assert (node != -1);
            int vertex = this.m_clusters.getElement(node);
            this.m_shape.getXY(vertex, cluster_pt);
            node = this.m_clusters.getNext(node);
            while (node != -1) {
                int vertex_1 = this.m_clusters.getElement(node);
                this.m_shape.setXY(vertex_1, cluster_pt);
                node = this.m_clusters.getNext(node);
            }
            list = this.m_clusters.getNextList(list);
        }
    }

    Clusterer() {
    }

    static class ClusterCandidate {
        public int vertex;
        double distance;

        ClusterCandidate() {
        }
    }

    final class ClusterHashFunction
    extends IndexHashTable.HashFunction {
        EditShape m_shape;
        double m_sqr_tolerance;
        double m_inv_cell_size;
        Point2D m_origin = new Point2D();
        Point2D m_pt = new Point2D();
        Point2D m_pt_2 = new Point2D();
        int m_hash_values;

        public ClusterHashFunction(EditShape shape, Point2D origin, double sqr_tolerance, double inv_cell_size, int hash_values) {
            this.m_shape = shape;
            this.m_sqr_tolerance = sqr_tolerance;
            this.m_inv_cell_size = inv_cell_size;
            this.m_origin = origin;
            this.m_hash_values = hash_values;
            this.m_pt.setNaN();
            this.m_pt_2.setNaN();
        }

        int calculate_hash(int element) {
            return this.calculate_hash_from_vertex(element);
        }

        int dbg_calculate_hash_from_xy(double x, double y) {
            double dx = x - this.m_origin.x;
            int xi = (int)(dx * this.m_inv_cell_size + 0.5);
            double dy = y - this.m_origin.y;
            int yi = (int)(dy * this.m_inv_cell_size + 0.5);
            return Clusterer.hashFunction_(xi, yi);
        }

        int calculate_hash_from_vertex(int vertex) {
            this.m_shape.getXY(vertex, this.m_pt);
            double dx = this.m_pt.x - this.m_origin.x;
            int xi = (int)(dx * this.m_inv_cell_size + 0.5);
            double dy = this.m_pt.y - this.m_origin.y;
            int yi = (int)(dy * this.m_inv_cell_size + 0.5);
            return Clusterer.hashFunction_(xi, yi);
        }

        @Override
        public int getHash(int element) {
            return this.m_shape.getUserIndex(element, this.m_hash_values);
        }

        @Override
        public boolean equal(int element_1, int element_2) {
            int xyindex_1 = element_1;
            int xyindex_2 = element_2;
            this.m_shape.getXY(xyindex_1, this.m_pt);
            this.m_shape.getXY(xyindex_2, this.m_pt_2);
            return Clusterer.isClusterCandidate_(this.m_pt.x, this.m_pt.y, this.m_pt_2.x, this.m_pt_2.y, this.m_sqr_tolerance);
        }

        @Override
        public int getHash(Object element_descriptor) {
            return 0;
        }

        @Override
        public boolean equal(Object element_descriptor, int element) {
            return false;
        }
    }
}

