/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableSchema {
    private static final String ATOMIC_TYPE_FIELD_NAME = "f0";
    private final String[] fieldNames;
    private final TypeInformation<?>[] fieldTypes;
    private final Map<String, Integer> fieldNameToIndex;

    public TableSchema(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        this.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames);
        this.fieldTypes = (TypeInformation[])Preconditions.checkNotNull(fieldTypes);
        if (fieldNames.length != fieldTypes.length) {
            throw new TableException("Number of field names and field types must be equal.\nNumber of names is " + fieldNames.length + ", number of types is " + fieldTypes.length + ".\nList of field names: " + Arrays.toString(fieldNames) + "\nList of field types: " + Arrays.toString(fieldTypes));
        }
        this.fieldNameToIndex = new HashMap<String, Integer>();
        HashSet<String> duplicateNames = new HashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (int i = 0; i < fieldNames.length; ++i) {
            Preconditions.checkNotNull(fieldTypes[i]);
            String fieldName = (String)Preconditions.checkNotNull((Object)fieldNames[i]);
            this.fieldNameToIndex.put(fieldName, i);
            if (uniqueNames.contains(fieldName)) {
                duplicateNames.add(fieldName);
                continue;
            }
            uniqueNames.add(fieldName);
        }
        if (!duplicateNames.isEmpty()) {
            throw new TableException("Field names must be unique.\nList of duplicate fields: " + ((Object)duplicateNames).toString() + "\nList of all fields: " + Arrays.toString(fieldNames));
        }
    }

    public TableSchema copy() {
        return new TableSchema((String[])this.fieldNames.clone(), (TypeInformation[])this.fieldTypes.clone());
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    public Optional<TypeInformation<?>> getFieldType(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldTypes.length) {
            return Optional.empty();
        }
        return Optional.of(this.fieldTypes[fieldIndex]);
    }

    public Optional<TypeInformation<?>> getFieldType(String fieldName) {
        if (this.fieldNameToIndex.containsKey(fieldName)) {
            return Optional.of(this.fieldTypes[this.fieldNameToIndex.get(fieldName)]);
        }
        return Optional.empty();
    }

    public int getFieldCount() {
        return this.fieldNames.length;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Optional<String> getFieldName(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldNames.length) {
            return Optional.empty();
        }
        return Optional.of(this.fieldNames[fieldIndex]);
    }

    @Deprecated
    public TypeInformation<?>[] getTypes() {
        return this.getFieldTypes();
    }

    @Deprecated
    public String[] getColumnNames() {
        return this.getFieldNames();
    }

    public TypeInformation<Row> toRowType() {
        return Types.ROW_NAMED((String[])this.fieldNames, this.fieldTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("root\n");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            sb.append(" |-- ").append(this.fieldNames[i]).append(": ").append(this.fieldTypes[i]).append('\n');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema schema2 = (TableSchema)o;
        return Arrays.equals(this.fieldNames, schema2.fieldNames) && Arrays.equals(this.fieldTypes, schema2.fieldTypes);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.fieldNames);
        result = 31 * result + Arrays.hashCode(this.fieldTypes);
        return result;
    }

    public static TableSchema fromTypeInfo(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)typeInfo;
            String[] fieldNames = compositeType.getFieldNames();
            TypeInformation[] fieldTypes = new TypeInformation[fieldNames.length];
            for (int i = 0; i < fieldTypes.length; ++i) {
                fieldTypes[i] = compositeType.getTypeAt(i);
            }
            return new TableSchema(fieldNames, fieldTypes);
        }
        return new TableSchema(new String[]{ATOMIC_TYPE_FIELD_NAME}, new TypeInformation[]{typeInfo});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> fieldNames = new ArrayList<String>();
        private List<TypeInformation<?>> fieldTypes = new ArrayList();

        public Builder field(String name, TypeInformation<?> type) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull(type);
            this.fieldNames.add(name);
            this.fieldTypes.add(type);
            return this;
        }

        public TableSchema build() {
            return new TableSchema(this.fieldNames.toArray(new String[0]), this.fieldTypes.toArray(new TypeInformation[0]));
        }
    }
}

