/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.util.MiniClusterResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.FileUtils;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractTestBase
extends TestBaseUtils {
    private static final int DEFAULT_PARALLELISM = 4;
    @ClassRule
    public static MiniClusterResource miniClusterResource = new MiniClusterResource(new MiniClusterResource.MiniClusterResourceConfiguration(new Configuration(), 1, 4));
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    public String getTempDirPath(String dirName) throws IOException {
        File f = this.createAndRegisterTempFile(dirName);
        return f.toURI().toString();
    }

    public String getTempFilePath(String fileName) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        return f.toURI().toString();
    }

    public String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        FileUtils.writeFileUtf8((File)f, (String)contents);
        return f.toURI().toString();
    }

    public File createAndRegisterTempFile(String fileName) throws IOException {
        return new File(TEMPORARY_FOLDER.newFolder(), fileName);
    }
}

