/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.client.program.StandaloneClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.minicluster.JobExecutor;
import org.apache.flink.runtime.minicluster.JobExecutorService;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.test.util.TestEnvironment;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniClusterResource
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(MiniClusterResource.class);
    public static final String CODEBASE_KEY = "codebase";
    public static final String NEW_CODEBASE = "new";
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final MiniClusterResourceConfiguration miniClusterResourceConfiguration;
    private final MiniClusterType miniClusterType;
    private JobExecutorService jobExecutorService;
    private final boolean enableClusterClient;
    private ClusterClient<?> clusterClient;
    private Configuration restClusterClientConfig;
    private int numberSlots = -1;
    private TestEnvironment executionEnvironment;
    private int webUIPort = -1;

    public MiniClusterResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        this(miniClusterResourceConfiguration, false);
    }

    public MiniClusterResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration, MiniClusterType miniClusterType) {
        this(miniClusterResourceConfiguration, miniClusterType, false);
    }

    public MiniClusterResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration, boolean enableClusterClient) {
        this(miniClusterResourceConfiguration, Objects.equals(NEW_CODEBASE, System.getProperty(CODEBASE_KEY)) ? MiniClusterType.NEW : MiniClusterType.LEGACY, enableClusterClient);
    }

    private MiniClusterResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration, MiniClusterType miniClusterType, boolean enableClusterClient) {
        this.miniClusterResourceConfiguration = (MiniClusterResourceConfiguration)Preconditions.checkNotNull((Object)miniClusterResourceConfiguration);
        this.miniClusterType = (MiniClusterType)((Object)Preconditions.checkNotNull((Object)((Object)miniClusterType)));
        this.enableClusterClient = enableClusterClient;
    }

    public MiniClusterType getMiniClusterType() {
        return this.miniClusterType;
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public ClusterClient<?> getClusterClient() {
        if (!this.enableClusterClient) {
            throw new IllegalStateException("To use the client you must enable it with the constructor.");
        }
        return this.clusterClient;
    }

    public Configuration getClientConfiguration() {
        return this.restClusterClientConfig;
    }

    public TestEnvironment getTestEnvironment() {
        return this.executionEnvironment;
    }

    public int getWebUIPort() {
        return this.webUIPort;
    }

    public void before() throws Exception {
        this.temporaryFolder.create();
        this.startJobExecutorService(this.miniClusterType);
        this.numberSlots = this.miniClusterResourceConfiguration.getNumberSlotsPerTaskManager() * this.miniClusterResourceConfiguration.getNumberTaskManagers();
        this.executionEnvironment = new TestEnvironment((JobExecutor)this.jobExecutorService, this.numberSlots, false);
        this.executionEnvironment.setAsContext();
        TestStreamEnvironment.setAsContext((JobExecutor)this.jobExecutorService, this.numberSlots);
    }

    public void after() {
        this.temporaryFolder.delete();
        TestStreamEnvironment.unsetAsContext();
        TestEnvironment.unsetAsContext();
        Exception exception = null;
        if (this.clusterClient != null) {
            try {
                this.clusterClient.shutdown();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        this.clusterClient = null;
        CompletableFuture terminationFuture = this.jobExecutorService.closeAsync();
        try {
            terminationFuture.get(this.miniClusterResourceConfiguration.getShutdownTimeout().toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        this.jobExecutorService = null;
        if (exception != null) {
            LOG.warn("Could not properly shut down the MiniClusterResource.", (Throwable)exception);
        }
    }

    private void startJobExecutorService(MiniClusterType miniClusterType) throws Exception {
        switch (miniClusterType) {
            case LEGACY: {
                this.startLegacyMiniCluster();
                break;
            }
            case NEW: {
                this.startMiniCluster();
                break;
            }
            default: {
                throw new FlinkRuntimeException("Unknown MiniClusterType " + (Object)((Object)miniClusterType) + '.');
            }
        }
    }

    private void startLegacyMiniCluster() throws Exception {
        Configuration configuration = new Configuration(this.miniClusterResourceConfiguration.getConfiguration());
        configuration.setInteger("local.number-taskmanager", this.miniClusterResourceConfiguration.getNumberTaskManagers());
        configuration.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, this.miniClusterResourceConfiguration.getNumberSlotsPerTaskManager());
        configuration.setString(CoreOptions.TMP_DIRS, this.temporaryFolder.newFolder().getAbsolutePath());
        LocalFlinkMiniCluster flinkMiniCluster = TestBaseUtils.startCluster(configuration, !this.enableClusterClient);
        this.jobExecutorService = flinkMiniCluster;
        if (this.enableClusterClient) {
            this.clusterClient = new StandaloneClusterClient(configuration, flinkMiniCluster.highAvailabilityServices(), true);
        }
        Configuration restClientConfig = new Configuration();
        restClientConfig.setInteger(JobManagerOptions.PORT, flinkMiniCluster.getLeaderRPCPort());
        this.restClusterClientConfig = new UnmodifiableConfiguration(restClientConfig);
        if (flinkMiniCluster.webMonitor().isDefined()) {
            this.webUIPort = ((WebMonitor)flinkMiniCluster.webMonitor().get()).getServerPort();
        }
    }

    private void startMiniCluster() throws Exception {
        Configuration configuration = this.miniClusterResourceConfiguration.getConfiguration();
        configuration.setString(CoreOptions.TMP_DIRS, this.temporaryFolder.newFolder().getAbsolutePath());
        if (!configuration.contains(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE)) {
            configuration.setBoolean(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE, true);
        }
        if (!configuration.contains(TaskManagerOptions.MANAGED_MEMORY_SIZE)) {
            configuration.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 80L);
        }
        configuration.setInteger(RestOptions.PORT, 0);
        MiniClusterConfiguration miniClusterConfiguration = new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(this.miniClusterResourceConfiguration.getNumberTaskManagers()).setNumSlotsPerTaskManager(this.miniClusterResourceConfiguration.getNumberSlotsPerTaskManager()).build();
        MiniCluster miniCluster = new MiniCluster(miniClusterConfiguration);
        miniCluster.start();
        configuration.setInteger(RestOptions.PORT, miniCluster.getRestAddress().getPort());
        this.jobExecutorService = miniCluster;
        if (this.enableClusterClient) {
            this.clusterClient = new MiniClusterClient(configuration, miniCluster);
        }
        Configuration restClientConfig = new Configuration();
        restClientConfig.setString(JobManagerOptions.ADDRESS, miniCluster.getRestAddress().getHost());
        restClientConfig.setInteger(RestOptions.PORT, miniCluster.getRestAddress().getPort());
        this.restClusterClientConfig = new UnmodifiableConfiguration(restClientConfig);
        this.webUIPort = miniCluster.getRestAddress().getPort();
    }

    public static enum MiniClusterType {
        LEGACY,
        NEW;

    }

    public static class MiniClusterResourceConfiguration {
        private final Configuration configuration;
        private final int numberTaskManagers;
        private final int numberSlotsPerTaskManager;
        private final Time shutdownTimeout;

        public MiniClusterResourceConfiguration(Configuration configuration, int numberTaskManagers, int numberSlotsPerTaskManager) {
            this(configuration, numberTaskManagers, numberSlotsPerTaskManager, AkkaUtils.getTimeoutAsTime((Configuration)configuration));
        }

        public MiniClusterResourceConfiguration(Configuration configuration, int numberTaskManagers, int numberSlotsPerTaskManager, Time shutdownTimeout) {
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
            this.numberTaskManagers = numberTaskManagers;
            this.numberSlotsPerTaskManager = numberSlotsPerTaskManager;
            this.shutdownTimeout = (Time)Preconditions.checkNotNull((Object)shutdownTimeout);
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public int getNumberTaskManagers() {
            return this.numberTaskManagers;
        }

        public int getNumberSlotsPerTaskManager() {
            return this.numberSlotsPerTaskManager;
        }

        public Time getShutdownTimeout() {
            return this.shutdownTimeout;
        }
    }
}

