/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001=\u0011ABR5mi\u0016\u0014\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0013=\u0004XM]1u_J\u001c(BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005aiU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005!Qn\u001c3f!\tY2F\u0004\u0002\u001dS9\u0011Q\u0004\u000b\b\u0003=\u001dr!a\b\u0014\u000f\u0005\u0001*cBA\u0011%\u001b\u0005\u0011#BA\u0012\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003+!I!a\u0005\u000b\n\u0005)\u0012\u0012\u0001G'vYRL\u0007\u000f\\3Qe><'/Y7t)\u0016\u001cHOQ1tK&\u0011A&\f\u0002\u0012)\u0016\u001cH/\u0012=fGV$\u0018n\u001c8N_\u0012,'B\u0001\u0016\u0013\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0011\u0011g\r\t\u0003e\u0001i\u0011A\u0001\u0005\u000639\u0002\rA\u0007\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002oA\u0011\u0001(\u0010\b\u0003sm\u0002\"!\t\u001e\u000b\u0003\u0015I!\u0001\u0010\u001e\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yiBq!\u0011\u0001A\u0002\u0013%!)\u0001\bsKN,H\u000e\u001e)bi\"|F%Z9\u0015\u0005\r;\u0005C\u0001#F\u001b\u0005Q\u0014B\u0001$;\u0005\u0011)f.\u001b;\t\u000f!\u0003\u0015\u0011!a\u0001o\u0005\u0019\u0001\u0010J\u0019\t\r)\u0003\u0001\u0015)\u00038\u0003-\u0011Xm];miB\u000bG\u000f\u001b\u0011\t\u000f1\u0003\u0001\u0019!C\u0005m\u0005AQ\r\u001f9fGR,G\rC\u0004O\u0001\u0001\u0007I\u0011B(\u0002\u0019\u0015D\b/Z2uK\u0012|F%Z9\u0015\u0005\r\u0003\u0006b\u0002%N\u0003\u0003\u0005\ra\u000e\u0005\u0007%\u0002\u0001\u000b\u0015B\u001c\u0002\u0013\u0015D\b/Z2uK\u0012\u0004\u0003b\u0002+\u0001\u0005\u0004%I!V\u0001\f?R,W\u000e\u001d$pY\u0012,'/F\u0001W!\t9F,D\u0001Y\u0015\tI&,A\u0003sk2,7O\u0003\u0002\\\u0019\u0005)!.\u001e8ji&\u0011Q\f\u0017\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\"1q\f\u0001Q\u0001\nY\u000bAb\u0018;f[B4u\u000e\u001c3fe\u0002BQ!\u0019\u0001\u0005\u0002U\u000b!\u0002^3na\u001a{G\u000eZ3sQ\t\u00017\r\u0005\u0002eK6\t!,\u0003\u0002g5\n!!+\u001e7f\u0011\u0015A\u0007\u0001\"\u0001j\u0003\u0019\u0011WMZ8sKR\t1\t\u000b\u0002hWB\u0011A\r\\\u0005\u0003[j\u0013aAQ3g_J,\u0007\"B8\u0001\t\u0003I\u0017!B1gi\u0016\u0014\bF\u00018r!\t!'/\u0003\u0002t5\n)\u0011I\u001a;fe\")Q\u000f\u0001C\u0001S\u00061B/Z:u\u00032d'+\u001a6fGRLgn\u001a$jYR,'\u000f\u000b\u0002uoB\u0011A\r_\u0005\u0003sj\u0013A\u0001V3ti\")1\u0010\u0001C\u0001S\u0006!B/Z:u\u00032d\u0007+Y:tS:<g)\u001b7uKJD#A_<\t\u000by\u0004A\u0011A5\u00029Q,7\u000f\u001e$jYR,'o\u00148TiJLgn\u001a+va2,g)[3mI\"\u0012Qp\u001e\u0005\u0007\u0003\u0007\u0001A\u0011A5\u0002;Q,7\u000f\u001e$jYR,'o\u00148J]R,w-\u001a:UkBdWMR5fY\u0012D3!!\u0001x\u0011\u0019\tI\u0001\u0001C\u0001S\u0006\u0019B/Z:u\r&dG/\u001a:CCNL7\rV=qK\"\u001a\u0011qA<\t\r\u0005=\u0001\u0001\"\u0001j\u0003Y!Xm\u001d;GS2$XM](o\u0007V\u001cHo\\7UsB,\u0007fAA\u0007o\"1\u0011Q\u0003\u0001\u0005\u0002%\f\u0001\u0005^3tiJK7\r\u001b$jYR,'o\u00148TiJLgn\u001a+va2,g)[3mI\"\u001a\u00111C<)\u000f\u0001\tY\"a\n\u0002*A!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"i\u000baA];o]\u0016\u0014\u0018\u0002BA\u0013\u0003?\u0011qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022i\u000bqA];o]\u0016\u00148/\u0003\u0003\u00026\u0005=\"!\u0004)be\u0006lW\r^3sSj,G\r")
public class FilterITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testAllRejectingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testAllRejectingFilter$1(t)));
        String x$5 = this.resultPath();
        FileSystem.WriteMode x$6 = FileSystem.WriteMode.OVERWRITE;
        String x$7 = filterDs.writeAsCsv$default$2();
        String x$8 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$5, x$7, x$8, x$6);
        env.execute();
        this.expected_$eq("\n");
    }

    @Test
    public void testAllPassingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testAllPassingFilter$1(t)));
        String x$9 = this.resultPath();
        FileSystem.WriteMode x$10 = FileSystem.WriteMode.OVERWRITE;
        String x$11 = filterDs.writeAsCsv$default$2();
        String x$12 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$9, x$11, x$12, x$10);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n");
    }

    @Test
    public void testFilterOnStringTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testFilterOnStringTupleField$1(x$1)));
        String x$13 = this.resultPath();
        FileSystem.WriteMode x$14 = FileSystem.WriteMode.OVERWRITE;
        String x$15 = filterDs.writeAsCsv$default$2();
        String x$16 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$13, x$15, x$16, x$14);
        env.execute();
        this.expected_$eq("3,2,Hello world\n4,3,Hello world, how are you?\n");
    }

    @Test
    public void testFilterOnIntegerTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testFilterOnIntegerTupleField$1(x$2)));
        String x$17 = this.resultPath();
        FileSystem.WriteMode x$18 = FileSystem.WriteMode.OVERWRITE;
        String x$19 = filterDs.writeAsCsv$default$2();
        String x$20 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$17, x$19, x$20, x$18);
        env.execute();
        this.expected_$eq("2,2,Hello\n4,3,Hello world, how are you?\n6,3,Luke Skywalker\n8,4,Comment#2\n10,4,Comment#4\n12,5,Comment#6\n14,5,Comment#8\n16,6,Comment#10\n18,6,Comment#12\n20,6,Comment#14\n");
    }

    @Test
    public void testFilterBasicType() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("H")));
        filterDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("Hi\nHello\nHello world\nHello world, how are you?\n");
    }

    @Test
    public void testFilterOnCustomType() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testFilterOnCustomType$1(x$4)));
        filterDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n");
    }

    @Test
    public void testRichFilterOnStringTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ints = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(null){
            private int literal;

            public int literal() {
                return this.literal;
            }

            public void literal_$eq(int x$1) {
                this.literal = x$1;
            }

            public void open(OpenContext openContext) {
                List ints = this.getRuntimeContext().getBroadcastVariable("ints");
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ints).asScala()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.literal_$eq(this.literal() < i ? i : this.literal()));
            }

            public boolean filter(Tuple3<Object, Object, String> value) {
                return BoxesRunTime.unboxToInt((Object)value._1()) < this.literal();
            }
            {
                this.literal = -1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$open$1(org.apache.flink.api.scala.operators.FilterITCase$$anon$1 int )}, serializedLambda);
            }
        }).withBroadcastSet(ints, "ints");
        String x$21 = this.resultPath();
        FileSystem.WriteMode x$22 = FileSystem.WriteMode.OVERWRITE;
        String x$23 = filterDs.writeAsCsv$default$2();
        String x$24 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$21, x$23, x$24, x$22);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n");
    }

    public static final /* synthetic */ boolean $anonfun$testAllRejectingFilter$1(Tuple3 t) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testAllPassingFilter$1(Tuple3 t) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testFilterOnStringTupleField$1(Tuple3 x$1) {
        return ((String)x$1._3()).contains("world");
    }

    public static final /* synthetic */ boolean $anonfun$testFilterOnIntegerTupleField$1(Tuple3 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1()) % 2 == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testFilterOnCustomType$1(CollectionDataSets.CustomType x$4) {
        return x$4.myString().contains("a");
    }

    public FilterITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

