/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.FlatMapITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001=\u0011QB\u00127bi6\u000b\u0007/\u0013+DCN,'BA\u0002\u0005\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0002\u0006\r\u0005)1oY1mC*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA!\u001e;jY*\u0011Q\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0018%\tAR*\u001e7uSBdW\r\u0015:pOJ\fWn\u001d+fgR\u0014\u0015m]3\t\u0011e\u0001!\u0011!Q\u0001\ni\tA!\\8eKB\u00111d\u000b\b\u00039%r!!\b\u0015\u000f\u0005y9cBA\u0010'\u001d\t\u0001SE\u0004\u0002\"I5\t!E\u0003\u0002$\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005UA\u0011BA\n\u0015\u0013\tQ##\u0001\rNk2$\u0018\u000e\u001d7f!J|wM]1ngR+7\u000f\u001e\"bg\u0016L!\u0001L\u0017\u0003#Q+7\u000f^#yK\u000e,H/[8o\u001b>$WM\u0003\u0002+%!)q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u0002\t\u000beq\u0003\u0019\u0001\u000e\t\u000fU\u0002\u0001\u0019!C\u0005m\u0005Q!/Z:vYR\u0004\u0016\r\u001e5\u0016\u0003]\u0002\"\u0001O\u001f\u000f\u0005eZ\u0004CA\u0011;\u0015\u0005)\u0011B\u0001\u001f;\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qR\u0004bB!\u0001\u0001\u0004%IAQ\u0001\u000fe\u0016\u001cX\u000f\u001c;QCRDw\fJ3r)\t\u0019u\t\u0005\u0002E\u000b6\t!(\u0003\u0002Gu\t!QK\\5u\u0011\u001dA\u0005)!AA\u0002]\n1\u0001\u001f\u00132\u0011\u0019Q\u0005\u0001)Q\u0005o\u0005Y!/Z:vYR\u0004\u0016\r\u001e5!\u0011\u001da\u0005\u00011A\u0005\nY\n\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b\u001d\u0002\u0001\r\u0011\"\u0003P\u00031)\u0007\u0010]3di\u0016$w\fJ3r)\t\u0019\u0005\u000bC\u0004I\u001b\u0006\u0005\t\u0019A\u001c\t\rI\u0003\u0001\u0015)\u00038\u0003%)\u0007\u0010]3di\u0016$\u0007\u0005C\u0004U\u0001\t\u0007I\u0011B+\u0002\u0017}#X-\u001c9G_2$WM]\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0006eVdWm\u001d\u0006\u000372\tQA[;oSRL!!\u0018-\u0003\u001fQ+W\u000e]8sCJLhi\u001c7eKJDaa\u0018\u0001!\u0002\u00131\u0016\u0001D0uK6\u0004hi\u001c7eKJ\u0004\u0003\"B1\u0001\t\u0003)\u0016A\u0003;f[B4u\u000e\u001c3fe\"\u0012\u0001m\u0019\t\u0003I\u0016l\u0011AW\u0005\u0003Mj\u0013AAU;mK\")\u0001\u000e\u0001C\u0001S\u00061!-\u001a4pe\u0016$\u0012a\u0011\u0015\u0003O.\u0004\"\u0001\u001a7\n\u00055T&A\u0002\"fM>\u0014X\rC\u0003p\u0001\u0011\u0005\u0011.A\u0003bMR,'\u000f\u000b\u0002ocB\u0011AM]\u0005\u0003gj\u0013Q!\u00114uKJDQ!\u001e\u0001\u0005\u0002%\fQ\u0003^3ti:{g\u000eU1tg&twM\u00127bi6\u000b\u0007\u000f\u000b\u0002uoB\u0011A\r_\u0005\u0003sj\u0013A\u0001V3ti\")1\u0010\u0001C\u0001S\u0006QB/Z:u\t\u0006$\u0018\rR;qY&\u001c\u0017\r^5oO\u001ac\u0017\r^'ba\"\u0012!p\u001e\u0005\u0006}\u0002!\t![\u0001,i\u0016\u001cHO\u00127bi6\u000b\u0007oV5uQZ\u000b'/_5oO:+XNY3s\u001f\u001a,U.\u001b;uK\u0012$V\u000f\u001d7fg\"\u0012Qp\u001e\u0005\u0007\u0003\u0007\u0001A\u0011A5\u0002SQ,7\u000f\u001e+za\u0016\u001cuN\u001c<feNLwN\u001c$mCRl\u0015\r\u001d9fe\u000e+8\u000f^8n)>$V\u000f\u001d7fQ\r\t\ta\u001e\u0005\u0007\u0003\u0013\u0001A\u0011A5\u0002QQ,7\u000f\u001e+za\u0016\u001cuN\u001c<feNLwN\u001c$mCRl\u0015\r\u001d9feR+\b\u000f\\3U_\n\u000b7/[2)\u0007\u0005\u001dq\u000f\u0003\u0004\u0002\u0010\u0001!\t![\u0001Bi\u0016\u001cHO\u00127bi6\u000b\u0007\u000f]3s\u0013\u001a,FI\u0012*fiV\u0014hn]%oaV$xJ\u00196fGRlU\u000f\u001c;ja2,G+[7fg^C\u0017\u000e\\3DQ\u0006tw-\u001b8h\u0013RD3!!\u0004x\u0011\u0019\t)\u0002\u0001C\u0001S\u0006YB/Z:u\r2\fG/T1q/&$\bN\u0011:pC\u0012\u001c\u0017m\u001d;TKRD3!a\u0005xQ\u001d\u0001\u00111DA\u0014\u0003S\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003CQ\u0016A\u0002:v]:,'/\u0003\u0003\u0002&\u0005}!a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003W\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cQ\u0016a\u0002:v]:,'o]\u0005\u0005\u0003k\tyCA\u0007QCJ\fW.\u001a;fe&TX\r\u001a")
public class FlatMapITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testNonPassingFlatMap() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet nonPassingFlatMapDs = ds.flatMap((Function1 & Serializable & scala.Serializable)in -> in.contains("banana") ? Option$.MODULE$.option2Iterable((Option)new Some(in)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$), (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class));
        nonPassingFlatMapDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("\n");
    }

    @Test
    public void testDataDuplicatingFlatMap() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet duplicatingFlatMapDs = ds.flatMap((Function1 & Serializable & scala.Serializable)in -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{in, in.toUpperCase()})), (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class));
        duplicatingFlatMapDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("Hi\nHI\nHello\nHELLO\nHello world\nHELLO WORLD\nHello world, how are you?\nHELLO WORLD, HOW ARE YOU?\nI am fine.\nI AM FINE.\nLuke Skywalker\nLUKE SKYWALKER\nRandom comment\nRANDOM COMMENT\nLOL\nLOL\n");
    }

    @Test
    public void testFlatMapWithVaryingNumberOfEmittedTuples() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet varyingTuplesMapDs = ds.flatMap((Function1 & Serializable & scala.Serializable)in -> {
            int numTuples = BoxesRunTime.unboxToInt((Object)in._1()) % 3;
            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTuples).map((Function1 & Serializable & scala.Serializable)i -> in, IndexedSeq$.MODULE$.canBuildFrom());
        }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.FlatMapITCase$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        String x$1 = this.resultPath();
        FileSystem.WriteMode x$2 = FileSystem.WriteMode.OVERWRITE;
        String x$3 = varyingTuplesMapDs.writeAsCsv$default$2();
        String x$4 = varyingTuplesMapDs.writeAsCsv$default$3();
        varyingTuplesMapDs.writeAsCsv(x$1, x$3, x$4, x$2);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n2,2,Hello\n4,3,Hello world, how are you?\n5,3,I am fine.\n5,3,I am fine.\n7,4,Comment#1\n8,4,Comment#2\n8,4,Comment#2\n10,4,Comment#4\n11,5,Comment#5\n11,5,Comment#5\n13,5,Comment#7\n14,5,Comment#8\n14,5,Comment#8\n16,6,Comment#10\n17,6,Comment#11\n17,6,Comment#11\n19,6,Comment#13\n20,6,Comment#14\n20,6,Comment#14\n");
    }

    @Test
    public void testTypeConversionFlatMapperCustomToTuple() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet typeConversionFlatMapDs = ds.flatMap((Function1 & Serializable & scala.Serializable)in -> Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)in.myInt()), (Object)BoxesRunTime.boxToLong((long)in.myLong()), (Object)in.myString()))), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.FlatMapITCase$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        String x$5 = this.resultPath();
        FileSystem.WriteMode x$6 = FileSystem.WriteMode.OVERWRITE;
        String x$7 = typeConversionFlatMapDs.writeAsCsv$default$2();
        String x$8 = typeConversionFlatMapDs.writeAsCsv$default$3();
        typeConversionFlatMapDs.writeAsCsv(x$5, x$7, x$8, x$6);
        env.execute();
        this.expected_$eq("1,0,Hi\n2,1,Hello\n2,2,Hello world\n3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n4,6,Comment#1\n4,7,Comment#2\n4,8,Comment#3\n4,9,Comment#4\n5,10,Comment#5\n5,11,Comment#6\n5,12,Comment#7\n5,13,Comment#8\n5,14,Comment#9\n6,15,Comment#10\n6,16,Comment#11\n6,17,Comment#12\n6,18,Comment#13\n6,19,Comment#14\n6,20,Comment#15\n");
    }

    @Test
    public void testTypeConversionFlatMapperTupleToBasic() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet typeConversionFlatMapDs = ds.flatMap((Function1 & Serializable & scala.Serializable)in -> Option$.MODULE$.option2Iterable((Option)new Some(in._3())), (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class));
        typeConversionFlatMapDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n");
    }

    @Test
    public void testFlatMapperIfUDFReturnsInputObjectMultipleTimesWhileChangingIt() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)t -> new CollectionDataSets.MutableTuple3<Object, Object, Object>(t._1(), t._2(), t._3()), (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.operators.FlatMapITCase$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        DataSet inputObjFlatMapDs = ds.flatMap((Function2 & Serializable & scala.Serializable)(in, out) -> {
            FlatMapITCase.$anonfun$testFlatMapperIfUDFReturnsInputObjectMultipleTimesWhileChangingIt$2(in, out);
            return BoxedUnit.UNIT;
        }, (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.api.scala.operators.FlatMapITCase$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        String x$9 = this.resultPath();
        FileSystem.WriteMode x$10 = FileSystem.WriteMode.OVERWRITE;
        String x$11 = inputObjFlatMapDs.writeAsCsv$default$2();
        String x$12 = inputObjFlatMapDs.writeAsCsv$default$3();
        inputObjFlatMapDs.writeAsCsv(x$9, x$11, x$12, x$10);
        env.execute();
        this.expected_$eq("0,1,Hi\n0,2,Hello\n1,2,Hello\n0,2,Hello world\n1,2,Hello world\n2,2,Hello world\n0,3,I am fine.\n0,3,Luke Skywalker\n1,3,Luke Skywalker\n0,4,Comment#1\n1,4,Comment#1\n2,4,Comment#1\n0,4,Comment#3\n0,4,Comment#4\n1,4,Comment#4\n0,5,Comment#5\n1,5,Comment#5\n2,5,Comment#5\n0,5,Comment#7\n0,5,Comment#8\n1,5,Comment#8\n0,5,Comment#9\n1,5,Comment#9\n2,5,Comment#9\n0,6,Comment#11\n0,6,Comment#12\n1,6,Comment#12\n0,6,Comment#13\n1,6,Comment#13\n2,6,Comment#13\n0,6,Comment#15\n");
    }

    @Test
    public void testFlatMapWithBroadcastSet() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ints = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)t -> new CollectionDataSets.MutableTuple3<Object, Object, Object>(t._1(), t._2(), t._3()), (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.api.scala.operators.FlatMapITCase$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        DataSet bcFlatMapDs = ds.flatMap((FlatMapFunction)new RichFlatMapFunction<CollectionDataSets.MutableTuple3<Object, Object, String>, CollectionDataSets.MutableTuple3<Object, Object, String>>(null){
            private int f2Replace;
            private final CollectionDataSets.MutableTuple3<Object, Object, String> outTuple;

            private int f2Replace() {
                return this.f2Replace;
            }

            private void f2Replace_$eq(int x$1) {
                this.f2Replace = x$1;
            }

            private CollectionDataSets.MutableTuple3<Object, Object, String> outTuple() {
                return this.outTuple;
            }

            public void open(OpenContext openContext) {
                Buffer ints = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRuntimeContext().getBroadcastVariable("ints")).asScala();
                this.f2Replace_$eq(BoxesRunTime.unboxToInt((Object)ints.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            }

            public void flatMap(CollectionDataSets.MutableTuple3<Object, Object, String> value, Collector<CollectionDataSets.MutableTuple3<Object, Object, String>> out) {
                this.outTuple()._1_$eq(BoxesRunTime.boxToInteger((int)this.f2Replace()));
                this.outTuple()._2_$eq(value._2());
                this.outTuple()._3_$eq(value._3());
                out.collect(this.outTuple());
            }
            {
                this.f2Replace = 0;
                this.outTuple = new CollectionDataSets.MutableTuple3<Integer, Long, String>(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)0L), "");
            }
        }, (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.api.scala.operators.FlatMapITCase$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class)).withBroadcastSet(ints, "ints");
        String x$13 = this.resultPath();
        FileSystem.WriteMode x$14 = FileSystem.WriteMode.OVERWRITE;
        String x$15 = bcFlatMapDs.writeAsCsv$default$2();
        String x$16 = bcFlatMapDs.writeAsCsv$default$3();
        bcFlatMapDs.writeAsCsv(x$13, x$15, x$16, x$14);
        env.execute();
        this.expected_$eq("55,1,Hi\n55,2,Hello\n55,2,Hello world\n55,3,Hello world, how are you?\n55,3,I am fine.\n55,3,Luke Skywalker\n55,4,Comment#1\n55,4,Comment#2\n55,4,Comment#3\n55,4,Comment#4\n55,5,Comment#5\n55,5,Comment#6\n55,5,Comment#7\n55,5,Comment#8\n55,5,Comment#9\n55,6,Comment#10\n55,6,Comment#11\n55,6,Comment#12\n55,6,Comment#13\n55,6,Comment#14\n55,6,Comment#15\n");
    }

    public static final /* synthetic */ void $anonfun$testFlatMapperIfUDFReturnsInputObjectMultipleTimesWhileChangingIt$2(CollectionDataSets.MutableTuple3 in, Collector out) {
        int numTuples = BoxesRunTime.unboxToInt(in._1()) % 4;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTuples).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            in._1_$eq(BoxesRunTime.boxToInteger((int)i));
            out.collect((Object)in);
        });
    }

    public FlatMapITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

