/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.graph;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.runtime.operators.lifecycle.command.TestCommand;
import org.apache.flink.runtime.operators.lifecycle.command.TestCommandDispatcher;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointCompletedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.InputEndedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.OperatorFinishedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.OperatorStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.TestCommandAckEvent;
import org.apache.flink.runtime.operators.lifecycle.event.TestEventQueue;
import org.apache.flink.runtime.operators.lifecycle.event.WatermarkReceivedEvent;
import org.apache.flink.runtime.operators.lifecycle.graph.TestDataElement;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

class OneInputTestStreamOperator
extends AbstractStreamOperator<TestDataElement>
implements OneInputStreamOperator<TestDataElement, TestDataElement>,
BoundedOneInput,
ProcessingTimeService.ProcessingTimeCallback {
    private final String operatorID;
    private long lastDataSent;
    private final Map<String, OperatorFinishedEvent.LastVertexDataInfo> lastDataReceived = new HashMap<String, OperatorFinishedEvent.LastVertexDataInfo>();
    private boolean timerRegistered;
    private final TestEventQueue eventQueue;
    private final Set<TestCommand> receivedCommands;
    private final TestCommandDispatcher dispatcher;
    private transient ListState<String> state;

    OneInputTestStreamOperator(String operatorID, TestEventQueue eventQueue, TestCommandDispatcher dispatcher) {
        this.operatorID = operatorID;
        this.eventQueue = eventQueue;
        this.receivedCommands = new HashSet<TestCommand>();
        this.dispatcher = dispatcher;
    }

    public void open() throws Exception {
        super.open();
        this.eventQueue.add(new OperatorStartedEvent(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getAttemptNumber()));
        this.dispatcher.subscribe(this.receivedCommands::add, this.operatorID);
        this.state = this.getKeyedStateBackend() != null ? this.getRuntimeContext().getListState(new ListStateDescriptor("test", String.class)) : this.getOperatorStateBackend().getListState(new ListStateDescriptor("test", String.class));
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        if (this.receivedCommands.remove(TestCommand.DELAY_SNAPSHOT)) {
            Thread.sleep(10L);
        }
        if (this.receivedCommands.remove(TestCommand.FAIL_SNAPSHOT)) {
            this.ackAndFail(TestCommand.FAIL_SNAPSHOT);
        }
        this.eventQueue.add(new CheckpointStartedEvent(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getAttemptNumber(), context.getCheckpointId()));
        super.snapshotState(context);
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.eventQueue.add(new CheckpointCompletedEvent(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getAttemptNumber(), checkpointId));
        super.notifyCheckpointComplete(checkpointId);
    }

    public void finish() throws Exception {
        this.eventQueue.add(new OperatorFinishedEvent(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getAttemptNumber(), this.lastDataSent, new OperatorFinishedEvent.LastReceivedVertexDataInfo(this.lastDataReceived)));
        super.finish();
    }

    public void processElement(StreamRecord<TestDataElement> element) throws Exception {
        if (this.receivedCommands.remove(TestCommand.FAIL)) {
            this.ackAndFail(TestCommand.FAIL);
        }
        TestDataElement e = (TestDataElement)element.getValue();
        this.state.update(Collections.singletonList(String.valueOf(e.seq)));
        this.lastDataReceived.computeIfAbsent((String)e.operatorId, (Function<String, OperatorFinishedEvent.LastVertexDataInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processElement$0(java.lang.String ), (Ljava/lang/String;)Lorg/apache/flink/runtime/operators/lifecycle/event/OperatorFinishedEvent$LastVertexDataInfo;)()).bySubtask.put(e.subtaskIndex, e.seq);
        this.output.collect((Object)new StreamRecord((Object)new TestDataElement(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), ++this.lastDataSent)));
        if (!this.timerRegistered) {
            this.registerTimer();
            this.timerRegistered = true;
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.eventQueue.add(new WatermarkReceivedEvent(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getAttemptNumber(), mark.getTimestamp(), 1));
        super.processWatermark(mark);
    }

    public void endInput() throws Exception {
        this.eventQueue.add(new InputEndedEvent(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getAttemptNumber(), 1));
    }

    public void onProcessingTime(long timestamp) {
        this.registerTimer();
    }

    private void registerTimer() {
        this.getProcessingTimeService().registerTimer(this.getProcessingTimeService().getCurrentProcessingTime() + 1L, (ProcessingTimeService.ProcessingTimeCallback)this);
    }

    private void ack(TestCommand cmd) {
        LOG.info("Executed command: {}", (Object)cmd);
        this.eventQueue.add(new TestCommandAckEvent(this.operatorID, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getAttemptNumber(), cmd));
    }

    private void ackAndFail(TestCommand failSnapshot) {
        this.ack(failSnapshot);
        throw new RuntimeException("requested to fail");
    }

    private static /* synthetic */ OperatorFinishedEvent.LastVertexDataInfo lambda$processElement$0(String ign) {
        return new OperatorFinishedEvent.LastVertexDataInfo();
    }
}

