/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.graph;

import org.apache.flink.runtime.operators.lifecycle.command.TestCommandDispatcher;
import org.apache.flink.runtime.operators.lifecycle.event.TestEventQueue;
import org.apache.flink.runtime.operators.lifecycle.graph.OneInputTestStreamOperator;
import org.apache.flink.runtime.operators.lifecycle.graph.TestDataElement;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceAware;

public class OneInputTestStreamOperatorFactory
implements OneInputStreamOperatorFactory<TestDataElement, TestDataElement>,
ProcessingTimeServiceAware {
    private ChainingStrategy strategy = ChainingStrategy.DEFAULT_CHAINING_STRATEGY;
    private ProcessingTimeService processingTimeService;
    private final String operatorID;
    private final TestEventQueue eventQueue;
    private final TestCommandDispatcher commandDispatcher;

    public OneInputTestStreamOperatorFactory(String operatorID, TestEventQueue eventQueue, TestCommandDispatcher commandDispatcher) {
        this.operatorID = operatorID;
        this.eventQueue = eventQueue;
        this.commandDispatcher = commandDispatcher;
    }

    public <T extends StreamOperator<TestDataElement>> T createStreamOperator(StreamOperatorParameters<TestDataElement> parameters) {
        OneInputTestStreamOperator operator = new OneInputTestStreamOperator(this.operatorID, this.eventQueue, this.commandDispatcher);
        operator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        operator.setProcessingTimeService(this.processingTimeService);
        return (T)((Object)operator);
    }

    public void setChainingStrategy(ChainingStrategy strategy) {
        this.strategy = strategy;
    }

    public ChainingStrategy getChainingStrategy() {
        return this.strategy;
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return OneInputTestStreamOperator.class;
    }

    public void setProcessingTimeService(ProcessingTimeService processingTimeService) {
        this.processingTimeService = processingTimeService;
    }
}

