/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.util.Collector;
import org.junit.Assert;

public class AccumulatorIterativeITCase
extends JavaProgramTestBase {
    private static final int NUM_ITERATIONS = 3;
    private static final int NUM_SUBTASKS = 1;
    private static final String ACC_NAME = "test";

    protected boolean skipCollectionExecution() {
        return true;
    }

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        IterativeDataSet iteration = env.fromElements((Object[])new Integer[]{1, 2, 3}).iterate(3);
        iteration.closeWith((DataSet)iteration.reduceGroup((GroupReduceFunction)new SumReducer())).output((OutputFormat)new DiscardingOutputFormat());
        Assert.assertEquals((long)18L, (long)((Integer)env.execute().getAccumulatorResult(ACC_NAME)).intValue());
    }

    static final class SumReducer
    extends RichGroupReduceFunction<Integer, Integer> {
        private static final long serialVersionUID = 1L;
        private IntCounter testCounter = new IntCounter();

        SumReducer() {
        }

        public void open(OpenContext openContext) throws Exception {
            this.getRuntimeContext().addAccumulator(AccumulatorIterativeITCase.ACC_NAME, (Accumulator)this.testCounter);
        }

        public void reduce(Iterable<Integer> values, Collector<Integer> out) {
            int sum = 0;
            for (Integer value : values) {
                sum += value.intValue();
                this.testCounter.add(value);
            }
            out.collect((Object)sum);
        }
    }
}

