/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.test.util.ShellScript;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskManagerLoadingDynamicPropertiesITCase
extends TestLogger {
    private static final String KEY_A = "key.a";
    private static final String VALUE_A = "#a,b&c^d*e@f(g!h";
    private static final String KEY_B = "key.b";
    private static final String VALUE_B = "'foobar";
    private static final String KEY_C = "key.c";
    private static final String VALUE_C = "foo''bar";
    private static final String KEY_D = "key.d";
    private static final String VALUE_D = "'foo' 'bar'";
    private static final String KEY_E = "key.e";
    private static final String VALUE_E = "foo\"bar'";
    private static final String KEY_F = "key.f";
    private static final String VALUE_F = "\"foo\" \"bar\"";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadingDynamicPropertiesInBash() throws Exception {
        Configuration clientConfiguration = new Configuration();
        File root = this.folder.getRoot();
        File homeDir = new File(root, "home");
        Assert.assertTrue((boolean)homeDir.mkdir());
        BootstrapTools.writeConfiguration((Configuration)clientConfiguration, (File)new File(homeDir, "config.yaml"));
        Configuration jmUpdatedConfiguration = this.getJobManagerUpdatedConfiguration();
        File shellScriptFile = this.generateLaunchContainerScript(homeDir, BootstrapTools.getDynamicPropertiesAsString((Configuration)clientConfiguration, (Configuration)jmUpdatedConfiguration));
        Process process = new ProcessBuilder(shellScriptFile.getAbsolutePath()).start();
        try {
            StringWriter processOutput = new StringWriter();
            new CommonTestUtils.PipeForwarder(process.getErrorStream(), processOutput);
            if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                throw new Exception("TestingTaskManagerRunner did not shutdown in time.");
            }
            Assert.assertEquals((String)processOutput.toString(), (long)0L, (long)process.exitValue());
        }
        finally {
            process.destroy();
        }
    }

    private Configuration getJobManagerUpdatedConfiguration() {
        Configuration updatedConfig = new Configuration();
        updatedConfig.setString(KEY_A, VALUE_A);
        updatedConfig.setString(KEY_B, VALUE_B);
        updatedConfig.setString(KEY_C, VALUE_C);
        updatedConfig.setString(KEY_D, VALUE_D);
        updatedConfig.setString(KEY_E, VALUE_E);
        updatedConfig.setString(KEY_F, VALUE_F);
        return updatedConfig;
    }

    private File generateLaunchContainerScript(File homeDir, String dynamicProperties) throws IOException {
        ShellScript.ShellScriptBuilder shellScriptBuilder = ShellScript.createShellScriptBuilder();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getJavaCommandWithOS());
        commands.add(this.getInternalClassNameWithOS(TestingTaskManagerRunner.class.getName()));
        commands.add("--configDir");
        commands.add(homeDir.getAbsolutePath());
        commands.add(dynamicProperties);
        shellScriptBuilder.env("CLASSPATH", CommonTestUtils.getCurrentClasspath());
        shellScriptBuilder.command(commands);
        File shellScriptFile = new File(homeDir, "launch_container" + ShellScript.getScriptExtension());
        shellScriptBuilder.write(shellScriptFile);
        return shellScriptFile;
    }

    private String getJavaCommandWithOS() {
        if (OperatingSystem.isWindows()) {
            return "\"" + CommonTestUtils.getJavaCommandPath() + "\"";
        }
        return CommonTestUtils.getJavaCommandPath();
    }

    private String getInternalClassNameWithOS(String className) {
        if (!OperatingSystem.isWindows()) {
            return className.replace("$", "'$'");
        }
        return className;
    }

    public static class TestingTaskManagerRunner {
        public static void main(String[] args) throws FlinkParseException {
            Configuration flinkConfig = TaskManagerRunner.loadConfiguration((String[])args);
            Assert.assertThat(flinkConfig.toMap().values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{TaskManagerLoadingDynamicPropertiesITCase.VALUE_A, TaskManagerLoadingDynamicPropertiesITCase.VALUE_B, TaskManagerLoadingDynamicPropertiesITCase.VALUE_C, TaskManagerLoadingDynamicPropertiesITCase.VALUE_D, TaskManagerLoadingDynamicPropertiesITCase.VALUE_E, TaskManagerLoadingDynamicPropertiesITCase.VALUE_F}));
        }
    }
}

